/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import com.oracle.truffle.tools.profiler.ShadowStack;
import com.oracle.truffle.tools.profiler.StackTraceEntry;
import com.oracle.truffle.tools.profiler.impl.CPUSamplerInstrument;
import com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.polyglot.Engine;

public final class CPUSampler
implements Closeable {
    private Mode mode = Mode.EXCLUDE_INLINED_ROOTS;
    static final SourceSectionFilter DEFAULT_FILTER = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build();
    private volatile boolean closed;
    private volatile boolean collecting;
    private long period = 1L;
    private long delay = 0L;
    private int stackLimit = 10000;
    private SourceSectionFilter filter;
    private boolean stackOverflowed = false;
    private AtomicLong samplesTaken = new AtomicLong(0L);
    private Timer samplerThread;
    private TimerTask samplerTask;
    private volatile ShadowStack shadowStack;
    private volatile EventBinding<?> stacksBinding;
    private final Map<Thread, ProfilerNode<Payload>> rootNodes = new HashMap<Thread, ProfilerNode<Payload>>();
    private final TruffleInstrument.Env env;
    private boolean gatherSelfHitTimes = false;
    private volatile boolean nonInternalLanguageContextInitialized = false;
    private boolean delaySamplingUntilNonInternalLangInit = true;
    private static Supplier<Payload> payloadFactory = new Supplier<Payload>(){

        @Override
        public Payload get() {
            return new Payload();
        }
    };
    private static BiConsumer<Payload, Payload> mergePayload = new BiConsumer<Payload, Payload>(){

        @Override
        public void accept(Payload sourcePayload, Payload destinationPayload) {
            destinationPayload.selfCompiledHitCount += sourcePayload.selfCompiledHitCount;
            destinationPayload.selfInterpretedHitCount += sourcePayload.selfInterpretedHitCount;
            destinationPayload.compiledHitCount += sourcePayload.compiledHitCount;
            destinationPayload.interpretedHitCount += sourcePayload.interpretedHitCount;
            for (Long timestamp : sourcePayload.getSelfHitTimes()) {
                destinationPayload.addSelfHitTime(timestamp);
            }
        }
    };
    private final Function<Payload, Payload> copyPayload = new Function<Payload, Payload>(){

        @Override
        public Payload apply(Payload sourcePayload) {
            Payload destinationPayload = new Payload();
            destinationPayload.selfCompiledHitCount = sourcePayload.selfCompiledHitCount;
            destinationPayload.selfInterpretedHitCount = sourcePayload.selfInterpretedHitCount;
            destinationPayload.compiledHitCount = sourcePayload.compiledHitCount;
            destinationPayload.interpretedHitCount = sourcePayload.interpretedHitCount;
            for (Long timestamp : sourcePayload.getSelfHitTimes()) {
                destinationPayload.addSelfHitTime(timestamp);
            }
            return destinationPayload;
        }
    };

    CPUSampler(TruffleInstrument.Env env) {
        this.env = env;
        env.getInstrumenter().attachContextsListener(new ContextsListener(){

            public void onContextCreated(TruffleContext context) {
            }

            public void onLanguageContextCreated(TruffleContext context, LanguageInfo language) {
            }

            public void onLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
                if (!language.isInternal()) {
                    CPUSampler.this.nonInternalLanguageContextInitialized = true;
                }
            }

            public void onLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
            }

            public void onLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
            }

            public void onContextClosed(TruffleContext context) {
            }
        }, true);
    }

    public static CPUSampler find(Engine engine) {
        return CPUSamplerInstrument.getSampler(engine);
    }

    public synchronized void setCollecting(boolean collecting) {
        if (this.collecting != collecting) {
            this.collecting = collecting;
            this.resetSampling();
        }
    }

    public synchronized boolean isCollecting() {
        return this.collecting;
    }

    public synchronized void setMode(Mode mode) {
        this.enterChangeConfig();
        this.mode = mode;
    }

    public synchronized void setPeriod(long samplePeriod) {
        this.enterChangeConfig();
        if (samplePeriod < 1L) {
            throw new IllegalArgumentException(String.format("Invalid sample period %s.", samplePeriod));
        }
        this.period = samplePeriod;
    }

    public synchronized long getPeriod() {
        return this.period;
    }

    public synchronized void setDelay(long delay) {
        this.enterChangeConfig();
        this.delay = delay;
    }

    public synchronized void setStackLimit(int stackLimit) {
        this.enterChangeConfig();
        if (stackLimit < 1) {
            throw new IllegalArgumentException(String.format("Invalid stack limit %s.", stackLimit));
        }
        this.stackLimit = stackLimit;
    }

    public synchronized int getStackLimit() {
        return this.stackLimit;
    }

    public synchronized void setFilter(SourceSectionFilter filter) {
        this.enterChangeConfig();
        this.filter = filter;
    }

    public synchronized void setDelaySamplingUntilNonInternalLangInit(boolean delaySamplingUntilNonInternalLangInit) {
        this.enterChangeConfig();
        this.delaySamplingUntilNonInternalLangInit = delaySamplingUntilNonInternalLangInit;
    }

    public synchronized SourceSectionFilter getFilter() {
        return this.filter;
    }

    public long getSampleCount() {
        return this.samplesTaken.get();
    }

    public boolean hasStackOverflowed() {
        return this.stackOverflowed;
    }

    public synchronized Collection<ProfilerNode<Payload>> getRootNodes() {
        ProfilerNode<Payload> mergedRoot = new ProfilerNode<Payload>();
        for (ProfilerNode<Payload> node : this.rootNodes.values()) {
            mergedRoot.deepMergeChildrenFrom(node, mergePayload, payloadFactory);
        }
        return mergedRoot.getChildren();
    }

    public synchronized Map<Thread, Collection<ProfilerNode<Payload>>> getThreadToNodesMap() {
        HashMap returnValue = new HashMap();
        for (Map.Entry<Thread, ProfilerNode<Payload>> entry : this.rootNodes.entrySet()) {
            ProfilerNode<Payload> copy = new ProfilerNode<Payload>();
            copy.deepCopyChildrenFrom(entry.getValue(), this.copyPayload);
            returnValue.put(entry.getKey(), copy.getChildren());
        }
        return Collections.unmodifiableMap(returnValue);
    }

    public synchronized void clearData() {
        this.samplesTaken.set(0L);
        for (ProfilerNode<Payload> node : this.rootNodes.values()) {
            Map rootChildren = node.children;
            if (rootChildren == null) continue;
            rootChildren.clear();
        }
    }

    public synchronized boolean hasData() {
        boolean hasData = false;
        for (ProfilerNode<Payload> node : this.rootNodes.values()) {
            Map rootChildren = node.children;
            hasData = hasData || rootChildren != null && !rootChildren.isEmpty();
        }
        return hasData;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.resetSampling();
        this.clearData();
    }

    public boolean isGatherSelfHitTimes() {
        return this.gatherSelfHitTimes;
    }

    public synchronized void setGatherSelfHitTimes(boolean gatherSelfHitTimes) {
        this.enterChangeConfig();
        this.gatherSelfHitTimes = gatherSelfHitTimes;
    }

    public Map<Thread, List<StackTraceEntry>> takeSample() {
        ShadowStack localShadowStack = this.shadowStack;
        if (localShadowStack == null) {
            localShadowStack = this.initializeShadowStack();
        }
        if (this.delaySamplingUntilNonInternalLangInit && !this.nonInternalLanguageContextInitialized) {
            return Collections.emptyMap();
        }
        assert (localShadowStack != null);
        HashMap<Thread, List<StackTraceEntry>> stacks = new HashMap<Thread, List<StackTraceEntry>>();
        for (ShadowStack.ThreadLocalStack stack : localShadowStack.getStacks()) {
            if (stack.hasStackOverflowed()) {
                this.stackOverflowed = true;
                continue;
            }
            StackTraceEntry[] strace = stack.getStack();
            if (strace == null || strace.length <= 0) continue;
            assert (!stacks.containsKey(stack.getThread()));
            List<StackTraceEntry> stackTraceEntries = Arrays.asList(strace);
            Collections.reverse(stackTraceEntries);
            stacks.put(stack.getThread(), Collections.unmodifiableList(stackTraceEntries));
        }
        return Collections.unmodifiableMap(stacks);
    }

    static Map<Thread, StackTraceElement[]> toStackTraceElement(Map<Thread, List<StackTraceEntry>> sample) {
        HashMap<Thread, StackTraceElement[]> converted = new HashMap<Thread, StackTraceElement[]>();
        for (Map.Entry<Thread, List<StackTraceEntry>> entry : sample.entrySet()) {
            converted.put(entry.getKey(), (StackTraceElement[])entry.getValue().stream().map(e -> e.toStackTraceElement()).toArray());
        }
        return converted;
    }

    private synchronized ShadowStack initializeShadowStack() {
        ShadowStack localShadowStack = this.shadowStack;
        if (localShadowStack == null) {
            assert (this.stacksBinding == null);
            SourceSectionFilter f = this.filter;
            if (f == null) {
                f = DEFAULT_FILTER;
            }
            this.shadowStack = localShadowStack = new ShadowStack(this.stackLimit, f, this.env.getInstrumenter(), TruffleLogger.getLogger((String)"cpusampler"));
            this.stacksBinding = this.shadowStack.install(this.env.getInstrumenter(), CPUSampler.combine(f, this.mode), this.mode == Mode.EXCLUDE_INLINED_ROOTS);
        }
        return localShadowStack;
    }

    private void resetSampling() {
        assert (Thread.holdsLock(this));
        this.cleanup();
        if (!this.collecting || this.closed) {
            return;
        }
        if (this.samplerThread == null) {
            this.samplerThread = new Timer("Sampling thread", true);
        }
        this.stackOverflowed = false;
        this.initializeShadowStack();
        this.samplerTask = new SamplingTimerTask();
        this.samplerThread.schedule(this.samplerTask, this.delay, this.period);
    }

    private static SourceSectionFilter combine(SourceSectionFilter filter, Mode mode) {
        ArrayList<Class> tags = new ArrayList<Class>();
        tags.add(StandardTags.RootTag.class);
        if (mode == Mode.STATEMENTS) {
            tags.add(StandardTags.StatementTag.class);
        }
        return SourceSectionFilter.newBuilder().tagIs(tags.toArray(new Class[0])).and(filter).build();
    }

    private void cleanup() {
        assert (Thread.holdsLock(this));
        this.invalidateStack();
        if (this.samplerTask != null) {
            this.samplerTask.cancel();
            this.samplerTask = null;
        }
        if (this.samplerThread != null) {
            this.samplerThread.cancel();
            this.samplerThread = null;
        }
    }

    private void enterChangeConfig() {
        assert (Thread.holdsLock(this));
        if (this.closed) {
            throw new IllegalStateException("CPUSampler is already closed.");
        }
        if (this.collecting) {
            throw new IllegalStateException("Cannot change sampler configuration while collecting. Call setCollecting(false) to disable collection first.");
        }
        this.invalidateStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateStack() {
        ShadowStack localShadowStack = this.shadowStack;
        if (localShadowStack != null) {
            CPUSampler cPUSampler = this;
            synchronized (cPUSampler) {
                localShadowStack = this.shadowStack;
                if (localShadowStack != null) {
                    if (this.stacksBinding != null) {
                        this.stacksBinding.dispose();
                        this.stacksBinding = null;
                    }
                    this.shadowStack = null;
                } else assert (this.stacksBinding == null);
            }
        }
    }

    static {
        CPUSamplerInstrument.setFactory(new ProfilerToolFactory<CPUSampler>(){

            @Override
            public CPUSampler create(TruffleInstrument.Env env) {
                return new CPUSampler(env);
            }
        });
    }

    private class SamplingTimerTask
    extends TimerTask {
        private SamplingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CPUSampler.this.delaySamplingUntilNonInternalLangInit && !CPUSampler.this.nonInternalLanguageContextInitialized) {
                return;
            }
            long timestamp = System.currentTimeMillis();
            boolean sampleTaken = false;
            ShadowStack localShadowStack = CPUSampler.this.shadowStack;
            if (localShadowStack != null) {
                for (ShadowStack.ThreadLocalStack stack : localShadowStack.getStacks()) {
                    ProfilerNode<Payload> threadNode;
                    CPUSampler cPUSampler = CPUSampler.this;
                    synchronized (cPUSampler) {
                        threadNode = CPUSampler.this.rootNodes.computeIfAbsent(stack.getThread(), new Function<Thread, ProfilerNode<Payload>>(){

                            @Override
                            public ProfilerNode<Payload> apply(Thread thread) {
                                return new ProfilerNode<Payload>();
                            }
                        });
                    }
                    sampleTaken |= this.sample(stack, timestamp, threadNode);
                }
            }
            if (sampleTaken) {
                CPUSampler.this.samplesTaken.incrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean sample(ShadowStack.ThreadLocalStack stack, long timestamp, ProfilerNode<Payload> threadNode) {
            if (stack.hasStackOverflowed()) {
                CPUSampler.this.stackOverflowed = true;
                return false;
            }
            if (stack.getStackIndex() == -1) {
                return false;
            }
            StackTraceEntry[] stackFrames = stack.getStack();
            if (stackFrames == null || stackFrames.length == 0) {
                return false;
            }
            CPUSampler cPUSampler = CPUSampler.this;
            synchronized (cPUSampler) {
                ProfilerNode<Payload> treeNode = threadNode;
                for (int i = 0; i < stackFrames.length; ++i) {
                    StackTraceEntry location = stackFrames[i];
                    boolean isCompiled = location.isCompiled();
                    treeNode = this.addOrUpdateChild(treeNode, location);
                    Payload payload = treeNode.getPayload();
                    if (i == stackFrames.length - 1) {
                        if (isCompiled) {
                            ++payload.selfCompiledHitCount;
                        } else {
                            ++payload.selfInterpretedHitCount;
                        }
                        if (CPUSampler.this.gatherSelfHitTimes) {
                            payload.selfHitTimes.add(timestamp);
                            assert (payload.selfHitTimes.size() == payload.getSelfHitCount());
                        }
                    }
                    if (isCompiled) {
                        ++payload.compiledHitCount;
                        continue;
                    }
                    ++payload.interpretedHitCount;
                }
            }
            return true;
        }

        private ProfilerNode<Payload> addOrUpdateChild(ProfilerNode<Payload> treeNode, StackTraceEntry location) {
            ProfilerNode<Payload> child = treeNode.findChild(location);
            if (child == null) {
                Payload payload = new Payload();
                child = new ProfilerNode<Payload>(treeNode, location, payload);
                treeNode.addChild(location, child);
            }
            return child;
        }
    }

    public static enum Mode {
        EXCLUDE_INLINED_ROOTS,
        ROOTS,
        STATEMENTS;

    }

    public static final class Payload {
        int compiledHitCount;
        int interpretedHitCount;
        int selfCompiledHitCount;
        int selfInterpretedHitCount;
        final List<Long> selfHitTimes = new ArrayList<Long>();

        Payload() {
        }

        public int getCompiledHitCount() {
            return this.compiledHitCount;
        }

        public int getInterpretedHitCount() {
            return this.interpretedHitCount;
        }

        public int getSelfCompiledHitCount() {
            return this.selfCompiledHitCount;
        }

        public int getSelfInterpretedHitCount() {
            return this.selfInterpretedHitCount;
        }

        public int getSelfHitCount() {
            return this.selfCompiledHitCount + this.selfInterpretedHitCount;
        }

        public int getHitCount() {
            return this.compiledHitCount + this.interpretedHitCount;
        }

        public List<Long> getSelfHitTimes() {
            return Collections.unmodifiableList(this.selfHitTimes);
        }

        void addSelfHitTime(Long time) {
            this.selfHitTimes.add(time);
        }
    }
}

