/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class TypeHandler {
    static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private final TruffleInstrument.Env env;
    private final AtomicReference<EventBinding<TypeProfileEventFactory>> currentBinding;

    public TypeHandler(TruffleInstrument.Env env) {
        this.env = env;
        this.currentBinding = new AtomicReference();
    }

    public boolean isStarted() {
        return this.currentBinding.get() != null;
    }

    public boolean start(boolean inspectInternal) {
        if (this.currentBinding.get() == null) {
            SourceSectionFilter filter = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).includeInternal(inspectInternal).build();
            Instrumenter instrumenter = this.env.getInstrumenter();
            EventBinding binding = instrumenter.attachExecutionEventFactory(filter, (ExecutionEventNodeFactory)new TypeProfileEventFactory());
            if (this.currentBinding.compareAndSet(null, (EventBinding<TypeProfileEventFactory>)binding)) {
                return true;
            }
            binding.dispose();
        }
        return false;
    }

    public void stop() {
        EventBinding<TypeProfileEventFactory> binding = this.currentBinding.get();
        if (binding != null && this.currentBinding.compareAndSet(binding, null)) {
            binding.dispose();
        }
    }

    public void clearData() {
        EventBinding<TypeProfileEventFactory> binding = this.currentBinding.get();
        if (binding != null) {
            ((TypeProfileEventFactory)binding.getElement()).profileMap.clear();
        }
    }

    public Collection<SectionTypeProfile> getSectionTypeProfiles() {
        EventBinding<TypeProfileEventFactory> binding = this.currentBinding.get();
        ArrayList<SectionTypeProfile> profiles = new ArrayList<SectionTypeProfile>(((TypeProfileEventFactory)binding.getElement()).profileMap.values());
        profiles.sort((p1, p2) -> Integer.compare(((SectionTypeProfile)p1).sourceSection.getCharEndIndex(), ((SectionTypeProfile)p2).sourceSection.getCharEndIndex()));
        return profiles;
    }

    static String getMetaObjectString(TruffleInstrument.Env env, LanguageInfo language, Object argument) {
        Object view = env.getLanguageView(language, argument);
        InteropLibrary viewLib = (InteropLibrary)InteropLibrary.getFactory().getUncached(view);
        String retType = null;
        if (viewLib.hasMetaObject(view)) {
            try {
                retType = INTEROP.asString(INTEROP.getMetaQualifiedName(viewLib.getMetaObject(view)));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e);
            }
        }
        return retType;
    }

    private final class TypeProfileEventFactory
    implements ExecutionEventNodeFactory {
        private final Map<SourceSection, SectionTypeProfile> profileMap = new ConcurrentHashMap<SourceSection, SectionTypeProfile>();

        private TypeProfileEventFactory() {
        }

        public ExecutionEventNode create(final EventContext context) {
            return new ExecutionEventNode(){
                private final Node node;
                @Node.Child
                private NodeLibrary nodeLibrary;
                {
                    this.node = context.getInstrumentedNode();
                    this.nodeLibrary = (NodeLibrary)NodeLibrary.getFactory().create((Object)this.node);
                }

                protected void onEnter(VirtualFrame frame) {
                    if (this.nodeLibrary.hasScope((Object)this.node, (Frame)frame)) {
                        try {
                            Object scope = this.nodeLibrary.getScope((Object)this.node, (Frame)frame, true);
                            this.processArguments(scope);
                        }
                        catch (UnsupportedMessageException e) {
                            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                        }
                    }
                }

                protected void onReturnValue(VirtualFrame frame, Object result) {
                    this.processReturnValue(result);
                }

                @CompilerDirectives.TruffleBoundary
                private void processArguments(Object arguments) {
                    SourceSection section = context.getInstrumentedSourceSection();
                    LanguageInfo language = this.node.getRootNode().getLanguageInfo();
                    try {
                        Object keys = INTEROP.getMembers(arguments);
                        long size = INTEROP.getArraySize(keys);
                        for (long i = 0L; i < size; ++i) {
                            Object argument = INTEROP.readArrayElement(keys, i);
                            String key = INTEROP.asString(argument);
                            Object argumentValue = INTEROP.readMember(arguments, key);
                            String retType = TypeHandler.getMetaObjectString(TypeHandler.this.env, language, argumentValue);
                            SourceSection argSection = TypeProfileEventFactory.this.getArgSection(section, argument);
                            if (argSection == null) continue;
                            TypeProfileEventFactory.this.profileMap.computeIfAbsent(argSection, s -> new SectionTypeProfile((SourceSection)s)).types.add(retType);
                        }
                    }
                    catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                }

                @CompilerDirectives.TruffleBoundary
                private void processReturnValue(Object result) {
                    if (result != null) {
                        SourceSection section = context.getInstrumentedSourceSection();
                        LanguageInfo language = this.node.getRootNode().getLanguageInfo();
                        String retType = TypeHandler.getMetaObjectString(TypeHandler.this.env, language, result);
                        TypeProfileEventFactory.this.profileMap.computeIfAbsent(section, s -> new SectionTypeProfile((SourceSection)s)).types.add(retType);
                    }
                }
            };
        }

        @CompilerDirectives.TruffleBoundary
        private SourceSection getArgSection(SourceSection function, Object argument) {
            try {
                if (INTEROP.hasSourceLocation(argument)) {
                    return INTEROP.getSourceLocation(argument);
                }
                String argName = INTEROP.asString(INTEROP.toDisplayString(argument));
                int idx = function.getCharacters().toString().indexOf(argName);
                return idx < 0 ? null : function.getSource().createSection(function.getCharIndex() + idx, argName.length());
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }

    public static interface Provider {
        public TypeHandler getTypeHandler();
    }

    public static final class SectionTypeProfile {
        private final SourceSection sourceSection;
        private final Collection<String> types = new HashSet<String>();

        private SectionTypeProfile(SourceSection sourceSection) {
            this.sourceSection = sourceSection;
        }

        public SourceSection getSourceSection() {
            return this.sourceSection;
        }

        public Collection<String> getTypes() {
            return this.types;
        }
    }
}

