/*
 * Decompiled with CFR 0.152.
 */
package org.nanohttpd.protocols.http.response;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import org.nanohttpd.protocols.http.NanoHTTPD;
import org.nanohttpd.protocols.http.content.ContentType;
import org.nanohttpd.protocols.http.request.Method;
import org.nanohttpd.protocols.http.response.ChunkedOutputStream;
import org.nanohttpd.protocols.http.response.IStatus;
import org.nanohttpd.protocols.http.response.Status;

public class Response
implements Closeable {
    private IStatus status;
    private String mimeType;
    private InputStream data;
    private long contentLength;
    private final Map<String, String> header = new HashMap<String, String>(){

        @Override
        public String put(String key, String value) {
            Response.this.lowerCaseHeader.put(key == null ? key : key.toLowerCase(), value);
            return super.put(key, value);
        }
    };
    private final Map<String, String> lowerCaseHeader = new HashMap<String, String>();
    private Method requestMethod;
    private boolean chunkedTransfer;
    private boolean keepAlive;
    private List<String> cookieHeaders;
    private GzipUsage gzipUsage = GzipUsage.DEFAULT;

    protected Response(IStatus status, String mimeType, InputStream data, long totalBytes) {
        this.status = status;
        this.mimeType = mimeType;
        if (data == null) {
            this.data = new ByteArrayInputStream(new byte[0]);
            this.contentLength = 0L;
        } else {
            this.data = data;
            this.contentLength = totalBytes;
        }
        this.chunkedTransfer = this.contentLength < 0L;
        this.keepAlive = true;
        this.cookieHeaders = new ArrayList<String>(10);
    }

    @Override
    public void close() throws IOException {
        if (this.data != null) {
            this.data.close();
        }
    }

    public void addCookieHeader(String cookie) {
        this.cookieHeaders.add(cookie);
    }

    public List<String> getCookieHeaders() {
        return this.cookieHeaders;
    }

    public void addHeader(String name, String value) {
        this.header.put(name, value);
    }

    public void closeConnection(boolean close) {
        if (close) {
            this.header.put("connection", "close");
        } else {
            this.header.remove("connection");
        }
    }

    public boolean isCloseConnection() {
        return "close".equals(this.getHeader("connection"));
    }

    public InputStream getData() {
        return this.data;
    }

    public String getHeader(String name) {
        return this.lowerCaseHeader.get(name.toLowerCase());
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Method getRequestMethod() {
        return this.requestMethod;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setKeepAlive(boolean useKeepAlive) {
        this.keepAlive = useKeepAlive;
    }

    public void send(OutputStream outputStream) {
        SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            long pending;
            if (this.status == null) {
                throw new Error("sendResponse(): Status can't be null.");
            }
            PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, new ContentType(this.mimeType).getEncoding())), false);
            pw.append("HTTP/1.1 ").append(this.status.getDescription()).append(" \r\n");
            if (this.mimeType != null) {
                this.printHeader(pw, "Content-Type", this.mimeType);
            }
            if (this.getHeader("date") == null) {
                this.printHeader(pw, "Date", gmtFrmt.format(new Date()));
            }
            for (Map.Entry<String, String> entry : this.header.entrySet()) {
                this.printHeader(pw, entry.getKey(), entry.getValue());
            }
            for (String cookieHeader : this.cookieHeaders) {
                this.printHeader(pw, "Set-Cookie", cookieHeader);
            }
            if (this.getHeader("connection") == null) {
                this.printHeader(pw, "Connection", this.keepAlive ? "keep-alive" : "close");
            }
            if (this.getHeader("content-length") != null) {
                this.setUseGzip(false);
            }
            if (this.useGzipWhenAccepted()) {
                this.printHeader(pw, "Content-Encoding", "gzip");
                this.setChunkedTransfer(true);
            }
            long l = pending = this.data != null ? this.contentLength : 0L;
            if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
                this.printHeader(pw, "Transfer-Encoding", "chunked");
            } else if (!this.useGzipWhenAccepted()) {
                pending = this.sendContentLengthHeaderIfNotAlreadyPresent(pw, pending);
            }
            pw.append("\r\n");
            pw.flush();
            this.sendBodyWithCorrectTransferAndEncoding(outputStream, pending);
            outputStream.flush();
            NanoHTTPD.safeClose(this.data);
        }
        catch (IOException ioe) {
            NanoHTTPD.LOG.log(Level.SEVERE, "Could not send response to the client", ioe);
        }
    }

    protected void printHeader(PrintWriter pw, String key, String value) {
        pw.append(key).append(": ").append(value).append("\r\n");
    }

    protected long sendContentLengthHeaderIfNotAlreadyPresent(PrintWriter pw, long defaultSize) {
        String contentLengthString = this.getHeader("content-length");
        long size = defaultSize;
        if (contentLengthString != null) {
            try {
                size = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException ex) {
                NanoHTTPD.LOG.severe("content-length was no number " + contentLengthString);
            }
        } else {
            pw.print("Content-Length: " + size + "\r\n");
        }
        return size;
    }

    private void sendBodyWithCorrectTransferAndEncoding(OutputStream outputStream, long pending) throws IOException {
        if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
            ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(outputStream);
            this.sendBodyWithCorrectEncoding(chunkedOutputStream, -1L);
            try {
                chunkedOutputStream.finish();
            }
            catch (Exception e) {
                if (this.data != null) {
                    this.data.close();
                }
            }
        } else {
            this.sendBodyWithCorrectEncoding(outputStream, pending);
        }
    }

    private void sendBodyWithCorrectEncoding(OutputStream outputStream, long pending) throws IOException {
        if (this.useGzipWhenAccepted()) {
            GZIPOutputStream gzipOutputStream;
            block5: {
                gzipOutputStream = null;
                try {
                    gzipOutputStream = new GZIPOutputStream(outputStream);
                }
                catch (Exception e) {
                    if (this.data == null) break block5;
                    this.data.close();
                }
            }
            if (gzipOutputStream != null) {
                this.sendBody(gzipOutputStream, -1L);
                gzipOutputStream.finish();
            }
        } else {
            this.sendBody(outputStream, pending);
        }
    }

    private void sendBody(OutputStream outputStream, long pending) throws IOException {
        long bytesToRead;
        int read;
        boolean sendEverything;
        long BUFFER_SIZE = 16384L;
        byte[] buff = new byte[(int)BUFFER_SIZE];
        boolean bl = sendEverything = pending == -1L;
        while ((pending > 0L || sendEverything) && (read = this.data.read(buff, 0, (int)(bytesToRead = sendEverything ? BUFFER_SIZE : Math.min(pending, BUFFER_SIZE)))) > 0) {
            block3: {
                try {
                    outputStream.write(buff, 0, read);
                }
                catch (Exception e) {
                    if (this.data == null) break block3;
                    this.data.close();
                }
            }
            if (sendEverything) continue;
            pending -= (long)read;
        }
    }

    public void setChunkedTransfer(boolean chunkedTransfer) {
        this.chunkedTransfer = chunkedTransfer;
    }

    public void setData(InputStream data) {
        this.data = data;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setRequestMethod(Method requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    public static Response newChunkedResponse(IStatus status, String mimeType, InputStream data) {
        return new Response(status, mimeType, data, -1L);
    }

    public static Response newFixedLengthResponse(IStatus status, String mimeType, byte[] data) {
        return Response.newFixedLengthResponse(status, mimeType, new ByteArrayInputStream(data), data.length);
    }

    public static Response newFixedLengthResponse(IStatus status, String mimeType, InputStream data, long totalBytes) {
        return new Response(status, mimeType, data, totalBytes);
    }

    public static Response newFixedLengthResponse(IStatus status, String mimeType, String txt) {
        byte[] bytes;
        ContentType contentType = new ContentType(mimeType);
        if (txt == null) {
            return Response.newFixedLengthResponse(status, mimeType, new ByteArrayInputStream(new byte[0]), 0L);
        }
        try {
            CharsetEncoder newEncoder = Charset.forName(contentType.getEncoding()).newEncoder();
            if (!newEncoder.canEncode(txt)) {
                contentType = contentType.tryUTF8();
            }
            bytes = txt.getBytes(contentType.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            NanoHTTPD.LOG.log(Level.SEVERE, "encoding problem, responding nothing", e);
            bytes = new byte[]{};
        }
        return Response.newFixedLengthResponse(status, contentType.getContentTypeHeader(), new ByteArrayInputStream(bytes), bytes.length);
    }

    public static Response newFixedLengthResponse(String msg) {
        return Response.newFixedLengthResponse((IStatus)Status.OK, "text/html", msg);
    }

    public Response setUseGzip(boolean useGzip) {
        this.gzipUsage = useGzip ? GzipUsage.ALWAYS : GzipUsage.NEVER;
        return this;
    }

    public boolean useGzipWhenAccepted() {
        if (this.gzipUsage == GzipUsage.DEFAULT) {
            return this.getMimeType() != null && (this.getMimeType().toLowerCase().contains("text/") || this.getMimeType().toLowerCase().contains("/json"));
        }
        return this.gzipUsage == GzipUsage.ALWAYS;
    }

    private static enum GzipUsage {
        DEFAULT,
        ALWAYS,
        NEVER;

    }
}

