/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.chromeinspector.LanguageChecks;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import java.io.PrintWriter;

final class TypeInfo {
    final String type;
    final String subtype;
    final String className;
    final String descriptionType;
    final boolean isObject;
    final boolean isJS;

    TypeInfo(String type, String subtype, String className, String descriptionType, boolean isObject, boolean isJS) {
        this.type = type;
        this.subtype = subtype;
        this.className = className;
        this.descriptionType = descriptionType;
        this.isObject = isObject;
        this.isJS = isJS;
    }

    static TypeInfo fromValue(DebugValue debugValue, LanguageInfo originalLanguage, PrintWriter err) {
        DebugValue metaObject = RemoteObject.getMetaObject(debugValue, originalLanguage, err);
        boolean isObject = TypeInfo.isObject(debugValue, err);
        String type = null;
        String subtype = null;
        String className = null;
        boolean isJS = LanguageChecks.isJS(originalLanguage);
        if (metaObject != null && isJS) {
            try {
                DebugValue property = metaObject.getProperty("type");
                if (property != null) {
                    type = (String)property.as(String.class);
                    property = metaObject.getProperty("subtype");
                    if (property != null) {
                        subtype = (String)property.as(String.class);
                    }
                    if ((property = metaObject.getProperty("className")) != null) {
                        className = (String)property.as(String.class);
                    }
                }
            }
            catch (DebugException ex) {
                if (err != null && ex.isInternalError()) {
                    err.println("getProperties of meta object of (" + debugValue.getName() + ") has caused: " + (Object)((Object)ex));
                    ex.printStackTrace(err);
                }
                throw ex;
            }
        }
        String descriptionType = null;
        if (type == null) {
            if (debugValue.isArray()) {
                subtype = "array";
            }
            String metaType = null;
            if (metaObject != null) {
                metaType = RemoteObject.toString(metaObject, err);
            }
            if (debugValue.canExecute()) {
                type = TYPE.FUNCTION.getId();
                className = metaType;
            } else if (isObject) {
                type = TYPE.OBJECT.getId();
                className = metaType;
            } else {
                type = TypeInfo.getType(debugValue, metaType);
                className = null;
                if (TYPE.OBJECT.getId().equals(type)) {
                    descriptionType = metaType;
                }
            }
        }
        if (descriptionType == null) {
            descriptionType = className;
        }
        return new TypeInfo(type, subtype, className, descriptionType, isObject, isJS);
    }

    static boolean isObject(DebugValue debugValue, PrintWriter err) {
        boolean isObject;
        try {
            isObject = debugValue.getProperties() != null || debugValue.canExecute() || debugValue.isArray();
        }
        catch (DebugException ex) {
            if (err != null && ex.isInternalError()) {
                err.println("getProperties(" + debugValue.getName() + ") has caused: " + (Object)((Object)ex));
                ex.printStackTrace(err);
            }
            throw ex;
        }
        return isObject;
    }

    private static String getType(DebugValue value, String metaObject) {
        if (metaObject == null) {
            return TYPE.OBJECT.getId();
        }
        for (TYPE type : TYPE.values()) {
            if (!metaObject.equalsIgnoreCase(type.getId())) continue;
            return type.getId();
        }
        Number number = (Number)value.as(Number.class);
        if (number != null) {
            return TYPE.NUMBER.getId();
        }
        Boolean bool = (Boolean)value.as(Boolean.class);
        if (bool != null) {
            return TYPE.BOOLEAN.getId();
        }
        return TYPE.OBJECT.getId();
    }

    static enum TYPE {
        OBJECT("object"),
        FUNCTION("function"),
        UNDEFINED("undefined"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        SYMBOL("symbol");

        private final String id;

        private TYPE(String id) {
            this.id = id;
        }

        String getId() {
            return this.id;
        }
    }
}

