/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.stack.SubstrateStackIntrospection;
import com.oracle.svm.truffle.TruffleSupport;
import com.oracle.svm.truffle.api.SubstrateFastThreadLocal;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import com.oracle.svm.truffle.api.SubstrateThreadLocalHandshake;
import com.oracle.svm.truffle.api.SubstrateTruffleCompilationSupport;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.svm.truffle.api.SubstrateTruffleOptions;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.compiler.ConstantFieldInfo;
import com.oracle.truffle.compiler.HostMethodInfo;
import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.compiler.PartialEvaluationMethodInfo;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationSupport;
import com.oracle.truffle.compiler.TruffleCompiler;
import com.oracle.truffle.runtime.AbstractCompilationTask;
import com.oracle.truffle.runtime.BackgroundCompileQueue;
import com.oracle.truffle.runtime.CompilationTask;
import com.oracle.truffle.runtime.EngineCacheSupport;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.ModulesSupport;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.options.OptionDescriptors;

public final class SubstrateTruffleRuntime
extends OptimizedTruffleRuntime {
    private static final int DEBUG_TEAR_DOWN_TIMEOUT = 2000;
    private static final int PRODUCTION_TEAR_DOWN_TIMEOUT = 10000;
    private OptimizedTruffleRuntime.KnownMethods hostedCallMethods;
    private volatile BackgroundCompileQueue compileQueue;
    private volatile boolean initialized;
    private volatile Boolean profilingEnabled;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleRuntime() {
        super((TruffleCompilationSupport)new SubstrateTruffleCompilationSupport(), List.of());
        super.getLoopNodeFactory();
    }

    public BackgroundCompileQueue getCompileQueue() {
        return this.compileQueue;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetHosted() {
        this.truffleCompiler = null;
        this.engineOptions = null;
        this.initializeEngineCacheSupport((EngineCacheSupport)new EngineCacheSupport.Disabled());
    }

    public void onCodeInstallation(TruffleCompilable compilable, InstalledCode installedCode) {
        throw CompilerDirectives.shouldNotReachHere((String)("onCodeInstallation is not implemented by " + ((Object)((Object)this)).getClass().getName()));
    }

    public ThreadLocalHandshake getThreadLocalHandshake() {
        return SubstrateThreadLocalHandshake.SINGLETON;
    }

    protected AbstractFastThreadLocal getFastThreadLocalImpl() {
        return SubstrateFastThreadLocal.SINGLETON;
    }

    private void initializeAtRuntime(OptimizedCallTarget callTarget) {
        this.truffleCompiler.initialize((TruffleCompilable)callTarget, true);
        if (SubstrateTruffleOptions.isMultiThreaded()) {
            this.compileQueue = TruffleSupport.singleton().createBackgroundCompileQueue(this);
        }
        if (callTarget.engine.traceTransferToInterpreter) {
            Deoptimizer.Options.TraceDeoptimization.update((Object)true);
        }
        this.installDefaultListeners();
        RuntimeSupport.getRuntimeSupport().addTearDownHook(isFirstIsolate -> this.teardown());
    }

    protected EngineCacheSupport loadEngineCacheSupport(List<OptionDescriptors> options) {
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PartialEvaluationMethodInfo getPartialEvaluationMethodInfo(ResolvedJavaMethod method) {
        return super.getPartialEvaluationMethodInfo(method);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HostMethodInfo getHostMethodInfo(ResolvedJavaMethod method) {
        return super.getHostMethodInfo(method);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        return super.getConstantFieldInfo(field);
    }

    private void teardown() {
        TruffleCompiler tcp;
        long timeout = SubstrateUtil.assertionsEnabled() ? 2000L : 10000L;
        BackgroundCompileQueue queue = this.getCompileQueue();
        if (queue != null) {
            queue.shutdownAndAwaitTermination(timeout);
        }
        if ((tcp = this.truffleCompiler) != null) {
            ((SubstrateTruffleCompiler)tcp).teardown();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler preinitializeTruffleCompiler() {
        assert (this.truffleCompiler == null) : "Cannot re-initialize Substrate TruffleCompiler";
        ((SubstrateTruffleCompilationSupport)this.compilationSupport).preinitialize();
        SubstrateTruffleCompiler compiler = (SubstrateTruffleCompiler)this.newTruffleCompiler();
        this.truffleCompiler = compiler;
        return compiler;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler getPreinitializedTruffleCompiler() {
        assert (this.truffleCompiler != null);
        return (SubstrateTruffleCompiler)this.truffleCompiler;
    }

    public ResolvedJavaMethod[] getAnyFrameMethod() {
        return this.knownMethods.anyFrameMethod;
    }

    public SubstrateTruffleCompiler getTruffleCompiler(TruffleCompilable compilable) {
        Objects.requireNonNull(compilable, "Compilable must be non null.");
        this.ensureInitializedAtRuntime((OptimizedCallTarget)compilable);
        return (SubstrateTruffleCompiler)this.truffleCompiler;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initializeHostedKnownMethods(MetaAccessProvider hostedMetaAccess) {
        this.hostedCallMethods = new OptimizedTruffleRuntime.KnownMethods((OptimizedTruffleRuntime)this, hostedMetaAccess);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void clearState() {
        super.clearState();
        this.hostedCallMethods = null;
    }

    public OptimizedTruffleRuntime.KnownMethods getKnownMethods() {
        if (SubstrateUtil.HOSTED) {
            return this.hostedCallMethods;
        }
        return this.knownMethods;
    }

    public OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget source, RootNode rootNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.profilingEnabled == null) {
            this.profilingEnabled = SubstrateTruffleRuntime.getEngineData((RootNode)rootNode).profilingEnabled;
        }
        SubstrateOptimizedCallTarget callTarget = TruffleSupport.singleton().createOptimizedCallTarget(source, rootNode);
        this.ensureInitializedAtRuntime(callTarget);
        return callTarget;
    }

    protected OptimizedCallTarget createInitializationCallTarget(EngineData engine) {
        return TruffleSupport.singleton().createOptimizedCallTarget(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitializedAtRuntime(OptimizedCallTarget callTarget) {
        if (!SubstrateUtil.HOSTED && !this.initialized) {
            SubstrateTruffleRuntime substrateTruffleRuntime = this;
            synchronized (substrateTruffleRuntime) {
                if (!this.initialized) {
                    this.initializeAtRuntime(callTarget);
                    this.initialized = true;
                }
            }
        }
    }

    public SpeculationLog createSpeculationLog() {
        return new SubstrateSpeculationLog();
    }

    public void notifyTransferToInterpreter() {
    }

    public boolean isProfilingEnabled() {
        if (this.profilingEnabled == null) {
            return Boolean.TRUE;
        }
        return this.profilingEnabled;
    }

    public CompilationTask submitForCompilation(OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) {
        block5: {
            if (SubstrateUtil.HOSTED) {
                return null;
            }
            this.ensureInitializedAtRuntime(optimizedCallTarget);
            if (SubstrateTruffleOptions.isMultiThreaded()) {
                return super.submitForCompilation(optimizedCallTarget, lastTierCompilation);
            }
            try {
                this.doCompile(optimizedCallTarget, new SingleThreadedCompilationTask(optimizedCallTarget, lastTierCompilation));
            }
            catch (OptimizationFailedException e) {
                if (optimizedCallTarget.engine.compilationFailureAction == OptimizedRuntimeOptions.ExceptionAction.Throw) {
                    throw e;
                }
                if (!((Boolean)SubstrateTruffleOptions.TrufflePropagateCompilationErrors.getValue()).booleanValue()) break block5;
                throw e;
            }
        }
        return null;
    }

    public void finishCompilation(OptimizedCallTarget optimizedCallTarget, CompilationTask task, boolean mayBeAsynchronous) {
        if (SubstrateTruffleOptions.isMultiThreaded()) {
            super.finishCompilation(optimizedCallTarget, task, mayBeAsynchronous);
        }
    }

    public void waitForCompilation(OptimizedCallTarget optimizedCallTarget, long timeout) throws ExecutionException, TimeoutException {
        if (SubstrateTruffleOptions.isMultiThreaded()) {
            super.waitForCompilation(optimizedCallTarget, timeout);
            return;
        }
    }

    protected StackIntrospection getStackIntrospection() {
        return SubstrateStackIntrospection.SINGLETON;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetNativeImageState() {
        this.clearState();
    }

    protected <T> T asObject(Class<T> type, JavaConstant constant) {
        return (T)SubstrateObjectConstant.asObject(type, (JavaConstant)constant);
    }

    protected JavaConstant forObject(Object object) {
        return SubstrateObjectConstant.forObject((Object)object);
    }

    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        return TruffleSupport.singleton().registerOptimizedAssumptionDependency(optimizedAssumptionConstant);
    }

    public TruffleCompilable asCompilableTruffleAST(JavaConstant constant) {
        return TruffleSupport.singleton().asCompilableTruffleAST(constant);
    }

    public void log(String loggerId, TruffleCompilable compilable, String message) {
        if (!TruffleSupport.singleton().tryLog(this, loggerId, compilable, message)) {
            super.log(loggerId, compilable, message);
        }
    }

    public boolean isSuppressedFailure(TruffleCompilable compilable, Supplier<String> serializedException) {
        TriState res = TruffleSupport.singleton().tryIsSuppressedFailure(compilable, serializedException);
        switch (res) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case UNDEFINED: {
                return super.isSuppressedFailure(compilable, serializedException);
            }
        }
        throw new IllegalStateException("Unsupported value " + String.valueOf(res));
    }

    public long getStackOverflowLimit() {
        StackOverflowCheck stackOverflowCheck = (StackOverflowCheck)ImageSingletons.lookup(StackOverflowCheck.class);
        return stackOverflowCheck.getStackOverflowBoundary().rawValue();
    }

    protected int getObjectAlignment() {
        return ConfigurationValues.getObjectLayout().getAlignment();
    }

    protected int getArrayBaseOffset(Class<?> componentType) {
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.fromJavaClass(componentType));
    }

    protected int getArrayIndexScale(Class<?> componentType) {
        return ConfigurationValues.getObjectLayout().getArrayIndexScale(JavaKind.fromJavaClass(componentType));
    }

    protected int getBaseInstanceSize(Class<?> type) {
        int le = DynamicHub.fromClass(type).getLayoutEncoding();
        return (int)LayoutEncoding.getPureInstanceAllocationSize((int)le).rawValue();
    }

    protected int[] getFieldOffsets(Class<?> type, boolean includePrimitive, boolean includeSuperclasses) {
        if (type.isArray() || type.isPrimitive()) {
            throw new IllegalArgumentException("Class " + type.getName() + " is a primitive type or an array class!");
        }
        if (includePrimitive) {
            throw new IllegalArgumentException("Retrieval of primitive field offsets is not supported!");
        }
        if (!includeSuperclasses) {
            throw new IllegalArgumentException("Exclusion of field offsets from superclasses is not supported!");
        }
        ArrayList fieldOffsets = new ArrayList();
        DynamicHub dh = DynamicHub.fromClass(type);
        boolean referenceInstanceClass = dh.isReferenceInstanceClass();
        int monitorOffset = dh.getMonitorOffset();
        InteriorObjRefWalker.walkInstanceReferenceOffsets((DynamicHub)dh, offset -> {
            if (!(monitorOffset != 0 && offset == monitorOffset || referenceInstanceClass && ReferenceInternals.isAnyReferenceFieldOffset((long)offset))) {
                fieldOffsets.add(offset);
            }
        });
        return fieldOffsets.stream().mapToInt(Integer::intValue).toArray();
    }

    static {
        Module enterpriseModule;
        ModuleLayer layer = SubstrateTruffleRuntime.class.getModule().getLayer();
        if (layer != null && (enterpriseModule = (Module)layer.findModule("com.oracle.truffle.enterprise.svm").orElse(null)) != null) {
            ModulesSupport.exportJVMCI((Module)enterpriseModule);
        }
    }

    private static class SingleThreadedCompilationTask
    extends AbstractCompilationTask {
        private final boolean lastTierCompilation;
        private final boolean hasNextTier;

        SingleThreadedCompilationTask(OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) {
            this.hasNextTier = !optimizedCallTarget.engine.firstTierOnly && !lastTierCompilation;
            this.lastTierCompilation = lastTierCompilation;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isLastTier() {
            return this.lastTierCompilation;
        }

        public boolean hasNextTier() {
            return this.hasNextTier;
        }
    }
}

