/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.deopt.DeoptimizationRuntime;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.graal.TruffleRuntimeCompilationSupport;
import com.oracle.svm.graal.hosted.runtimecompilation.RuntimeCompilationFeature;
import com.oracle.svm.truffle.api.SubstrateKnownTruffleTypes;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTargetInstalledCode;
import com.oracle.svm.truffle.api.SubstratePartialEvaluator;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.svm.truffle.api.SubstrateTruffleCompilerImpl;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.svm.truffle.isolated.IsolateAwareTruffleCompiler;
import com.oracle.svm.truffle.isolated.IsolatedTruffleRuntimeSupport;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import com.oracle.truffle.runtime.BackgroundCompileQueue;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedAssumption;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedDirectCallNode;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.truffle.EconomyPartialEvaluatorConfiguration;
import jdk.graal.compiler.truffle.KnownTruffleTypes;
import jdk.graal.compiler.truffle.PartialEvaluatorConfiguration;
import jdk.graal.compiler.truffle.TruffleCompilerConfiguration;
import jdk.graal.compiler.truffle.TruffleCompilerImpl;
import jdk.graal.compiler.truffle.TruffleTierConfiguration;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.ImageSingletons;

public class TruffleSupport {
    public static TruffleSupport singleton() {
        return (TruffleSupport)ImageSingletons.lookup(TruffleSupport.class);
    }

    public Class<?> getOptimizedCallTargetClass() {
        return SubstrateOptimizedCallTarget.class;
    }

    public SubstrateOptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        return new SubstrateOptimizedCallTarget(sourceCallTarget, rootNode);
    }

    public SubstrateOptimizedCallTarget createOptimizedCallTarget(EngineData engine) {
        return new SubstrateOptimizedCallTarget(engine);
    }

    private static Method getOptimizedCallTargetInvokeMethod() {
        return ReflectionUtil.lookupMethod(SubstrateOptimizedCallTargetInstalledCode.class, (String)"doInvoke", (Class[])new Class[]{SubstrateOptimizedCallTarget.class, Object[].class});
    }

    public SubstratePartialEvaluator createPartialEvaluator(TruffleCompilerConfiguration config, GraphBuilderConfiguration graphBuilderConfigForRoot) {
        return new SubstratePartialEvaluator(config, graphBuilderConfigForRoot);
    }

    public SubstrateTruffleCompiler createTruffleCompiler(SubstrateTruffleRuntime runtime) {
        SubstrateTruffleCompiler compiler = new SubstrateTruffleCompilerImpl(TruffleSupport.createSubstrateTruffleCompilerConfig(runtime, "community", TruffleSupport.getOptimizedCallTargetInvokeMethod()));
        if (SubstrateOptions.supportCompileInIsolates()) {
            compiler = new IsolateAwareTruffleCompiler((SubstrateTruffleCompilerImpl)compiler);
        }
        return compiler;
    }

    protected static TruffleCompilerConfiguration createSubstrateTruffleCompilerConfig(SubstrateTruffleRuntime runtime, String compilerConfigurationName, Method optimizedCallTargetMethod) {
        RuntimeCompilationFeature runtimeCompilationFeature = RuntimeCompilationFeature.singleton();
        GraphBuilderConfiguration.Plugins graphBuilderPlugins = runtimeCompilationFeature.getHostedProviders().getGraphBuilderPlugins();
        SubstrateBackend substrateBackend = TruffleRuntimeCompilationSupport.getRuntimeConfig().getBackendForNormalMethod();
        substrateBackend.setRuntimeToRuntimeInvokeMethod(optimizedCallTargetMethod);
        Providers providers = TruffleRuntimeCompilationSupport.getRuntimeConfig().getProviders();
        SubstrateKnownTruffleTypes types = new SubstrateKnownTruffleTypes((TruffleCompilerRuntime)runtime, providers.getMetaAccess(), providers.getConstantReflection());
        TruffleTierConfiguration firstTier = new TruffleTierConfiguration((PartialEvaluatorConfiguration)new EconomyPartialEvaluatorConfiguration(), (Backend)substrateBackend, TruffleRuntimeCompilationSupport.getFirstTierProviders(), TruffleRuntimeCompilationSupport.getFirstTierSuites(), TruffleRuntimeCompilationSupport.getFirstTierLirSuites(), (KnownTruffleTypes)types, (ForeignCallDescriptor)DeoptimizationRuntime.DEOPTIMIZE);
        PartialEvaluatorConfiguration peConfig = TruffleCompilerImpl.createPartialEvaluatorConfiguration((String)compilerConfigurationName);
        TruffleTierConfiguration lastTier = new TruffleTierConfiguration(peConfig, (Backend)substrateBackend, TruffleRuntimeCompilationSupport.getRuntimeConfig().getProviders(), TruffleRuntimeCompilationSupport.getFullOptSuites(), TruffleRuntimeCompilationSupport.getLIRSuites(), (KnownTruffleTypes)types, (ForeignCallDescriptor)DeoptimizationRuntime.DEOPTIMIZE);
        return new TruffleCompilerConfiguration((TruffleCompilerRuntime)runtime, graphBuilderPlugins, runtimeCompilationFeature.getHostedProviders().getSnippetReflection(), firstTier, lastTier, (KnownTruffleTypes)types, TruffleRuntimeCompilationSupport.getFullOptSuites(), null);
    }

    public static boolean isIsolatedCompilation() {
        return !SubstrateUtil.HOSTED && SubstrateOptions.shouldCompileInIsolates();
    }

    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        if (TruffleSupport.isIsolatedCompilation()) {
            return IsolatedTruffleRuntimeSupport.registerOptimizedAssumptionDependency(optimizedAssumptionConstant);
        }
        Object target = SubstrateObjectConstant.asObject((Constant)optimizedAssumptionConstant);
        OptimizedAssumption assumption = (OptimizedAssumption)target;
        return assumption.registerDependency();
    }

    public JavaConstant getCallTargetForCallNode(JavaConstant callNodeConstant) {
        if (TruffleSupport.isIsolatedCompilation()) {
            return IsolatedTruffleRuntimeSupport.getCallTargetForCallNode(callNodeConstant);
        }
        Object target = SubstrateObjectConstant.asObject((Constant)callNodeConstant);
        OptimizedDirectCallNode callNode = (OptimizedDirectCallNode)target;
        OptimizedCallTarget callTarget = callNode.getCallTarget();
        return SubstrateObjectConstant.forObject((Object)callTarget);
    }

    public BackgroundCompileQueue createBackgroundCompileQueue(SubstrateTruffleRuntime runtime) {
        return new BackgroundCompileQueue((OptimizedTruffleRuntime)runtime);
    }

    public TruffleCompilable asCompilableTruffleAST(JavaConstant constant) {
        if (TruffleSupport.isIsolatedCompilation()) {
            return IsolatedTruffleRuntimeSupport.asCompilableTruffleAST(constant);
        }
        return (TruffleCompilable)SubstrateObjectConstant.asObject(OptimizedCallTarget.class, (JavaConstant)constant);
    }

    public boolean tryLog(SubstrateTruffleRuntime runtime, String loggerId, TruffleCompilable compilable, String message) {
        if (TruffleSupport.isIsolatedCompilation()) {
            return IsolatedTruffleRuntimeSupport.tryLog(loggerId, compilable, message);
        }
        return false;
    }

    public TriState tryIsSuppressedFailure(TruffleCompilable compilable, Supplier<String> serializedException) {
        if (TruffleSupport.isIsolatedCompilation()) {
            return IsolatedTruffleRuntimeSupport.tryIsSuppressedFailure(compilable, serializedException);
        }
        return TriState.UNDEFINED;
    }
}

