/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident.impl;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.deopt.DeoptState;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.interpreter.InterpreterFrameSourceInfo;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.EspressoFrame;
import com.oracle.svm.interpreter.InterpreterFrame;
import com.oracle.svm.interpreter.InterpreterToVM;
import com.oracle.svm.interpreter.SemanticJavaException;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaField;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterUniverse;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.FrameId;
import com.oracle.svm.jdwp.bridge.InvokeOptions;
import com.oracle.svm.jdwp.bridge.JDWP;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.Logger;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.SymbolicRefs;
import com.oracle.svm.jdwp.bridge.TagConstants;
import com.oracle.svm.jdwp.bridge.TypeTag;
import com.oracle.svm.jdwp.bridge.WritablePacket;
import com.oracle.svm.jdwp.resident.ClassUtils;
import com.oracle.svm.jdwp.resident.JDWPBridgeImpl;
import com.oracle.svm.jdwp.resident.ThreadStartDeathSupport;
import com.oracle.svm.jdwp.resident.api.StackframeDescriptor;
import com.oracle.svm.jdwp.resident.impl.GetStackframeDescriptorAtDepthVisitor;
import com.oracle.svm.jdwp.resident.impl.ResidentSymbolicRefs;
import com.oracle.svm.jdwp.resident.impl.SafeStackWalker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordBase;

public final class ResidentJDWP
implements JDWP {
    private static final boolean LOGGING = false;
    public static Logger LOGGER = new Logger(false, "[ResidentJDWP]", System.err);
    private final SymbolicRefs symbolicRefs = new ResidentSymbolicRefs();

    private static Object readReferenceOrNull(Packet.Reader reader) throws JDWPException {
        long objectId = reader.readLong();
        Object value = JDWPBridgeImpl.getIds().getObject(objectId);
        if (objectId != 0L && value == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        return value;
    }

    private static Object readArray(Packet.Reader reader) throws JDWPException {
        Object array = ResidentJDWP.readReferenceOrNull(reader);
        if (array == null || !array.getClass().isArray()) {
            throw JDWPException.raise(ErrorCode.INVALID_ARRAY);
        }
        return array;
    }

    private static <T> T readTypedObject(Packet.Reader reader, Class<T> clazz, ErrorCode errorCode) throws JDWPException {
        Object object = ResidentJDWP.readReferenceOrNull(reader);
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw JDWPException.raise(errorCode);
    }

    private static String readStringObject(Packet.Reader reader) throws JDWPException {
        return ResidentJDWP.readTypedObject(reader, String.class, ErrorCode.INVALID_STRING);
    }

    private static InterpreterResolvedJavaType readType(Packet.Reader reader) throws JDWPException {
        Object object = ResidentJDWP.readReferenceOrNull(reader);
        if (object instanceof InterpreterResolvedJavaType) {
            InterpreterResolvedJavaType interpreterResolvedJavaType = (InterpreterResolvedJavaType)object;
            InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
            OptionalInt knownInUniverse = universe.getTypeIndexFor(interpreterResolvedJavaType);
            if (knownInUniverse.isPresent()) {
                return interpreterResolvedJavaType;
            }
        }
        throw JDWPException.raise(ErrorCode.INVALID_CLASS);
    }

    private static InterpreterResolvedJavaField readField(Packet.Reader reader) throws JDWPException {
        Object object = ResidentJDWP.readReferenceOrNull(reader);
        if (object instanceof InterpreterResolvedJavaField) {
            InterpreterResolvedJavaField interpreterResolvedJavaField = (InterpreterResolvedJavaField)object;
            InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
            OptionalInt knownInUniverse = universe.getFieldIndexFor(interpreterResolvedJavaField);
            if (knownInUniverse.isPresent()) {
                return interpreterResolvedJavaField;
            }
        }
        throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
    }

    private static InterpreterResolvedJavaMethod readMethod(Packet.Reader reader) throws JDWPException {
        Object object = ResidentJDWP.readReferenceOrNull(reader);
        if (object instanceof InterpreterResolvedJavaMethod) {
            InterpreterResolvedJavaMethod interpreterResolvedJavaMethod = (InterpreterResolvedJavaMethod)object;
            InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
            OptionalInt knownInUniverse = universe.getMethodIndexFor(interpreterResolvedJavaMethod);
            if (knownInUniverse.isPresent()) {
                return interpreterResolvedJavaMethod;
            }
        }
        throw JDWPException.raise(ErrorCode.INVALID_METHODID);
    }

    private static ThreadGroup readThreadGroup(Packet.Reader reader) throws JDWPException {
        return ResidentJDWP.readTypedObject(reader, ThreadGroup.class, ErrorCode.INVALID_THREAD_GROUP);
    }

    private static Module readModule(Packet.Reader reader) throws JDWPException {
        return ResidentJDWP.readTypedObject(reader, Module.class, ErrorCode.INVALID_MODULE);
    }

    private static Class<?> readClassObject(Packet.Reader reader) throws JDWPException {
        return ResidentJDWP.readTypedObject(reader, Class.class, ErrorCode.INVALID_CLASS);
    }

    private static ClassLoader readClassLoader(Packet.Reader reader) throws JDWPException {
        return ResidentJDWP.readTypedObject(reader, ClassLoader.class, ErrorCode.INVALID_CLASS_LOADER);
    }

    private static Object verifyObjectIdOrNull(long objectId) throws JDWPException {
        Object object = JDWPBridgeImpl.getIds().getObject(objectId);
        if (object != null || objectId == 0L) {
            return object;
        }
        throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
    }

    private static ResolvedJavaType verifyRefType(long refTypeId) throws JDWPException {
        Object object = ResidentJDWP.verifyObjectIdOrNull(refTypeId);
        if (object instanceof InterpreterResolvedJavaType) {
            InterpreterResolvedJavaType interpreterResolvedJavaType = (InterpreterResolvedJavaType)object;
            InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
            OptionalInt knownInUniverse = universe.getTypeIndexFor(interpreterResolvedJavaType);
            if (knownInUniverse.isPresent()) {
                return interpreterResolvedJavaType;
            }
        }
        throw JDWPException.raise(ErrorCode.INVALID_CLASS);
    }

    private static ResolvedJavaField verifyRefField(long fieldId) throws JDWPException {
        Object object = ResidentJDWP.verifyObjectIdOrNull(fieldId);
        if (object instanceof InterpreterResolvedJavaField) {
            InterpreterResolvedJavaField interpreterResolvedJavaField = (InterpreterResolvedJavaField)object;
            InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
            OptionalInt knownInUniverse = universe.getFieldIndexFor(interpreterResolvedJavaField);
            if (knownInUniverse.isPresent()) {
                return interpreterResolvedJavaField;
            }
        }
        throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
    }

    private static ResolvedJavaMethod verifyRefMethod(long methodId) throws JDWPException {
        Object object = ResidentJDWP.verifyObjectIdOrNull(methodId);
        if (object instanceof InterpreterResolvedJavaMethod) {
            InterpreterResolvedJavaMethod interpreterResolvedJavaMethod = (InterpreterResolvedJavaMethod)object;
            InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
            OptionalInt knownInUniverse = universe.getMethodIndexFor(interpreterResolvedJavaMethod);
            if (knownInUniverse.isPresent()) {
                return interpreterResolvedJavaMethod;
            }
        }
        throw JDWPException.raise(ErrorCode.INVALID_METHODID);
    }

    private static void writeTaggedObject(Packet.Writer writer, Object value) {
        writer.writeByte(TagConstants.getTagFromReference(value));
        writer.writeLong(JDWPBridgeImpl.getIds().getIdOrCreateWeak(value));
    }

    @Override
    public Packet VirtualMachine_AllThreads(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        long[] allThreads = ResidentJDWP.getAllThreadIds();
        data.writeInt(allThreads.length);
        for (long threadId : allThreads) {
            data.writeLong(threadId);
        }
        return reply;
    }

    private static VMMutex lockThreads() {
        VMMutex mutex;
        try {
            Field mutexField = VMThreads.class.getDeclaredField("THREAD_MUTEX");
            mutexField.setAccessible(true);
            mutex = (VMMutex)mutexField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace();
            throw JDWPException.raise(ErrorCode.INTERNAL);
        }
        mutex.lock();
        return mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] getAllThreadIds() {
        long[] ids = new long[10];
        int i = 0;
        VMMutex mutex = ResidentJDWP.lockThreads();
        try {
            IsolateThread thread = VMThreads.firstThreadUnsafe();
            while (thread.isNonNull()) {
                Thread t = ThreadStartDeathSupport.get().filterAppThread(thread);
                if (t != null) {
                    if (i >= ids.length) {
                        ids = Arrays.copyOf(ids, i + i / 2);
                    }
                    ids[i++] = JDWPBridgeImpl.getIds().getIdOrCreateWeak(t);
                }
                thread = VMThreads.nextThread(thread);
            }
        }
        finally {
            mutex.unlock();
        }
        ids = Arrays.copyOf(ids, i);
        if (LOGGER.isLoggable()) {
            LOGGER.log("getAllThreadIds(): " + Arrays.toString(ids));
        }
        return ids;
    }

    @Override
    public Packet VirtualMachine_AllClassesWithGeneric(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        ResolvedJavaType[] allClasses = ResidentJDWP.allReferenceTypes();
        data.writeInt(allClasses.length);
        for (ResolvedJavaType type : allClasses) {
            data.writeByte(TypeTag.getKind(type));
            data.writeLong(JDWPBridgeImpl.getIds().getIdOrCreateWeak(type));
            data.writeString(ClassUtils.getTypeAsString(type));
            data.writeString(ClassUtils.getGenericTypeAsString(type));
            data.writeInt(ClassUtils.getStatus(type));
        }
        return reply;
    }

    @Override
    public Packet VirtualMachine_Dispose(Packet packet) throws JDWPException {
        JDWPBridgeImpl.getIds().reset();
        return WritablePacket.newReplyTo(packet);
    }

    @Override
    public Packet VirtualMachine_DisposeObjects(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        int numRequests = input.readInt();
        for (int i = 0; i < numRequests; ++i) {
            long objectId = input.readLong();
            int refCount = input.readInt();
            JDWPBridgeImpl.getIds().enableCollection(objectId, refCount, true);
        }
        return WritablePacket.newReplyTo(packet);
    }

    @Override
    public Packet ObjectReference_DisableCollection(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        long objectId = input.readLong();
        boolean success = JDWPBridgeImpl.getIds().disableCollection(objectId);
        if (!success) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        return WritablePacket.newReplyTo(packet);
    }

    @Override
    public Packet ObjectReference_EnableCollection(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        long objectId = input.readLong();
        boolean success = JDWPBridgeImpl.getIds().enableCollection(objectId);
        if (!success) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        return WritablePacket.newReplyTo(packet);
    }

    @Override
    public Packet ObjectReference_IsCollected(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        long objectId = input.readLong();
        Boolean collected = JDWPBridgeImpl.getIds().isCollected(objectId);
        if (collected == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        data.writeBoolean(collected);
        return reply;
    }

    @Override
    public Packet ThreadReference_Name(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        Thread thread = ResidentJDWP.readThread(input);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        data.writeString(thread.getName());
        return reply;
    }

    @Override
    public Packet ThreadReference_ThreadGroup(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        Thread thread = ResidentJDWP.readThread(input);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup == null) {
            throw JDWPException.raise(ErrorCode.INVALID_THREAD);
        }
        long id = JDWPBridgeImpl.getIds().getIdOrCreateWeak(threadGroup);
        data.writeLong(id);
        return reply;
    }

    private static Thread readThread(Packet.Reader reader) throws JDWPException {
        return ResidentJDWP.readTypedObject(reader, Thread.class, ErrorCode.INVALID_THREAD);
    }

    public static Thread getThread(long threadId) {
        Thread thread;
        try {
            thread = JDWPBridgeImpl.getIds().toObject(threadId, Thread.class);
        }
        catch (ClassCastException e) {
            throw JDWPException.raise(ErrorCode.INVALID_THREAD);
        }
        if (thread == null) {
            if (threadId == 0L) {
                throw JDWPException.raise(ErrorCode.INVALID_THREAD);
            }
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        return thread;
    }

    @Override
    public Packet ThreadGroupReference_Name(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        ThreadGroup threadGroup = ResidentJDWP.readThreadGroup(input);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        data.writeString(threadGroup.getName());
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Packet ThreadGroupReference_Children(Packet packet) throws JDWPException {
        int i;
        Packet.Reader input = packet.newDataReader();
        ThreadGroup threadGroup = ResidentJDWP.readThreadGroup(input);
        long[] threadIds = new long[10];
        long[] threadGroupIds = new long[10];
        int ti = 0;
        int tgi = 0;
        VMMutex mutex = ResidentJDWP.lockThreads();
        try {
            IsolateThread thread = VMThreads.firstThreadUnsafe();
            while (thread.isNonNull()) {
                Thread t = ThreadStartDeathSupport.get().filterAppThread(thread);
                if (t != null) {
                    ThreadGroup tg = t.getThreadGroup();
                    if (tg == threadGroup) {
                        if (ti >= threadIds.length) {
                            threadIds = Arrays.copyOf(threadIds, ti + ti / 2);
                        }
                        threadIds[ti++] = JDWPBridgeImpl.getIds().getIdOrCreateWeak(t);
                    }
                    if (tg != null && tg.getParent() == threadGroup) {
                        long id = JDWPBridgeImpl.getIds().getIdOrCreateWeak(tg);
                        boolean contains = false;
                        for (int i2 = 0; i2 < tgi; ++i2) {
                            if (threadGroupIds[i2] != id) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) {
                            if (tgi >= threadGroupIds.length) {
                                threadGroupIds = Arrays.copyOf(threadGroupIds, tgi + tgi / 2);
                            }
                            threadGroupIds[tgi++] = id;
                        }
                    }
                }
                thread = VMThreads.nextThread(thread);
            }
        }
        finally {
            mutex.unlock();
        }
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        data.writeInt(ti);
        for (i = 0; i < ti; ++i) {
            data.writeLong(threadIds[i]);
        }
        data.writeInt(tgi);
        for (i = 0; i < tgi; ++i) {
            data.writeLong(threadGroupIds[i]);
        }
        return reply;
    }

    @Override
    public Packet ThreadGroupReference_Parent(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        ThreadGroup threadGroup = ResidentJDWP.readThreadGroup(input);
        assert (input.isEndOfInput());
        ThreadGroup parentGroup = threadGroup.getParent();
        long parentId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(parentGroup);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        data.writeLong(parentId);
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Packet VirtualMachine_TopLevelThreadGroups(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        long[] threadGroupIds = new long[5];
        int tgi = 0;
        VMMutex mutex = ResidentJDWP.lockThreads();
        try {
            IsolateThread thread = VMThreads.firstThreadUnsafe();
            while (thread.isNonNull()) {
                ThreadGroup tg;
                Thread t = ThreadStartDeathSupport.get().filterAppThread(thread);
                if (t != null && (tg = t.getThreadGroup()) != null) {
                    ThreadGroup rootGroup = tg;
                    while ((tg = tg.getParent()) != null) {
                        rootGroup = tg;
                    }
                    long id = JDWPBridgeImpl.getIds().getIdOrCreateWeak(rootGroup);
                    boolean contains = false;
                    for (int i = 0; i < tgi; ++i) {
                        if (threadGroupIds[i] != id) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) {
                        if (tgi >= threadGroupIds.length) {
                            threadGroupIds = Arrays.copyOf(threadGroupIds, tgi + tgi / 2);
                        }
                        threadGroupIds[tgi++] = id;
                    }
                }
                thread = VMThreads.nextThread(thread);
            }
        }
        finally {
            mutex.unlock();
        }
        data.writeInt(tgi);
        for (int i = 0; i < tgi; ++i) {
            data.writeLong(threadGroupIds[i]);
        }
        return reply;
    }

    @Override
    public Packet VirtualMachine_AllClasses(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        ResolvedJavaType[] allClasses = ResidentJDWP.allReferenceTypes();
        data.writeInt(allClasses.length);
        for (ResolvedJavaType type : allClasses) {
            data.writeByte(TypeTag.getKind(type));
            data.writeLong(JDWPBridgeImpl.getIds().getIdOrCreateWeak(type));
            data.writeString(ClassUtils.getTypeAsString(type));
            data.writeInt(ClassUtils.getStatus(type));
        }
        return reply;
    }

    private static ResolvedJavaType[] allReferenceTypes() {
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        return (ResolvedJavaType[])universe.getTypes().stream().filter(type -> !type.isPrimitive()).toArray(ResolvedJavaType[]::new);
    }

    @Override
    public Packet ObjectReference_ReferenceType(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Object object = ResidentJDWP.readReferenceOrNull(reader);
        assert (reader.isEndOfInput());
        if (object == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        Class<?> c = object.getClass();
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        ResolvedJavaType type = universe.lookupType(c);
        long typeId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(type);
        byte typeKind = TypeTag.getKind(type);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer data = reply.dataWriter();
        data.writeByte(typeKind);
        data.writeLong(typeId);
        return reply;
    }

    @Override
    public Packet VirtualMachine_CreateString(Packet packet) throws JDWPException {
        assert (packet.commandSet() == 1);
        assert (packet.command() == 11);
        Packet.Reader reader = packet.newDataReader();
        String str = reader.readString();
        assert (reader.isEndOfInput());
        long stringId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(str);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeLong(stringId);
        return reply;
    }

    @Override
    public Packet StringReference_Value(Packet packet) throws JDWPException {
        assert (packet.commandSet() == 10);
        assert (packet.command() == 1);
        Packet.Reader reader = packet.newDataReader();
        String string = ResidentJDWP.readStringObject(reader);
        assert (reader.isEndOfInput());
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeString(string);
        return reply;
    }

    @Override
    public Packet ReferenceType_ClassObject(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        assert (reader.isEndOfInput());
        Class<?> javaClass = type.getJavaClass();
        long classId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(javaClass);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeLong(classId);
        return reply;
    }

    @Override
    public Packet ClassObjectReference_ReflectedType(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Class<?> classObject = ResidentJDWP.readClassObject(reader);
        assert (reader.isEndOfInput());
        ResolvedJavaType type = DebuggerSupport.lookupType(classObject);
        assert (type != null);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        long typeId = this.symbolicRefs.toTypeRef(type);
        writer.writeByte(TypeTag.getKind(type));
        writer.writeLong(typeId);
        return reply;
    }

    @Override
    public Packet ReferenceType_ClassLoader(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        assert (reader.isEndOfInput());
        Class<?> javaClass = type.getJavaClass();
        ClassLoader classLoader = javaClass.getClassLoader();
        long classLoaderId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(classLoader);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeLong(classLoaderId);
        return reply;
    }

    @Override
    public Packet ReferenceType_Module(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        assert (reader.isEndOfInput());
        Class<?> javaClass = type.getJavaClass();
        Module module = javaClass.getModule();
        long moduleId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(module);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeLong(moduleId);
        return reply;
    }

    @Override
    public Packet ModuleReference_Name(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Module module = ResidentJDWP.readModule(reader);
        assert (reader.isEndOfInput());
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        String moduleName = module.getName();
        if (moduleName == null) {
            moduleName = "";
        }
        writer.writeString(moduleName);
        return reply;
    }

    private static Module[] allModules() {
        HashSet<Module> allModules = new HashSet<Module>(ModuleLayer.boot().modules());
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        for (ResolvedJavaType resolvedJavaType : universe.getTypes()) {
            Module module;
            InterpreterResolvedObjectType objectType;
            Class<?> javaClass;
            if (!(resolvedJavaType instanceof InterpreterResolvedObjectType) || (javaClass = (objectType = (InterpreterResolvedObjectType)resolvedJavaType).getJavaClass()) == null || (module = javaClass.getModule()) == null) continue;
            allModules.add(module);
        }
        return (Module[])allModules.toArray(Module[]::new);
    }

    @Override
    public Packet VirtualMachine_AllModules(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        assert (reader.isEndOfInput());
        Module[] allModules = ResidentJDWP.allModules();
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(allModules.length);
        for (Module module : allModules) {
            long moduleId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(module);
            writer.writeLong(moduleId);
        }
        return reply;
    }

    @Override
    public Packet ModuleReference_ClassLoader(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Module module = ResidentJDWP.readModule(reader);
        assert (reader.isEndOfInput());
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        ClassLoader classLoader = module.getClassLoader();
        long classLoaderId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(classLoader);
        writer.writeLong(classLoaderId);
        return reply;
    }

    @Override
    public Packet ReferenceType_NestedTypes(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        assert (reader.isEndOfInput());
        Class<?> javaClass = type.getJavaClass();
        Class<?>[] declaredClasses = javaClass.getDeclaredClasses();
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(declaredClasses.length);
        for (Class<?> declaredClass : declaredClasses) {
            ResolvedJavaType declaredType = DebuggerSupport.lookupType(declaredClass);
            long declaredTypeId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(declaredType);
            writer.writeLong(declaredTypeId);
        }
        return reply;
    }

    @Override
    public Packet ThreadReference_IsVirtual(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Thread thread = ResidentJDWP.readThread(reader);
        assert (reader.isEndOfInput());
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeBoolean(thread.isVirtual());
        return reply;
    }

    @Override
    public Packet ArrayReference_Length(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Object array = ResidentJDWP.readArray(reader);
        assert (array.getClass().isArray());
        assert (reader.isEndOfInput());
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        int arrayLength = InterpreterToVM.arrayLength(array);
        writer.writeInt(arrayLength);
        return reply;
    }

    private static void validateArrayRegion(int firstIndex, int length, int arrayLength) {
        if (firstIndex < 0 || firstIndex >= arrayLength) {
            throw JDWPException.raise(ErrorCode.INVALID_INDEX);
        }
        if (length < 0 || firstIndex > arrayLength - length) {
            throw JDWPException.raise(ErrorCode.INVALID_LENGTH);
        }
    }

    @Override
    public Packet ArrayReference_GetValues(Packet packet) throws JDWPException {
        byte componentStorageTag;
        Packet.Reader reader = packet.newDataReader();
        Object array = ResidentJDWP.readArray(reader);
        int firstIndex = reader.readInt();
        int length = reader.readInt();
        assert (reader.isEndOfInput());
        int arrayLength = InterpreterToVM.arrayLength(array);
        if (length == -1) {
            length = arrayLength - firstIndex;
        }
        ResidentJDWP.validateArrayRegion(firstIndex, length, arrayLength);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        Class<?> componentType = array.getClass().getComponentType();
        boolean isWordTypeComponent = WordBase.class.isAssignableFrom(componentType);
        if (isWordTypeComponent) {
            componentStorageTag = switch (InterpreterToVM.wordJavaKind()) {
                case JavaKind.Int -> 73;
                case JavaKind.Long -> 74;
                default -> throw VMError.shouldNotReachHere("Unexpected word kind " + String.valueOf(InterpreterToVM.wordJavaKind()));
            };
        } else {
            componentStorageTag = TagConstants.getTagFromClass(componentType);
        }
        writer.writeByte(componentStorageTag);
        writer.writeInt(length);
        assert (firstIndex >= 0);
        assert (firstIndex < arrayLength);
        assert (firstIndex <= arrayLength - length);
        if (isWordTypeComponent) {
            int i = firstIndex;
            while (i - firstIndex < length) {
                WordBase value = InterpreterToVM.getArrayWord(i, (WordBase[])array);
                switch (InterpreterToVM.wordJavaKind()) {
                    case Int: {
                        writer.writeInt((int)value.rawValue());
                        break;
                    }
                    case Long: {
                        writer.writeLong(value.rawValue());
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere("Unexpected word kind " + String.valueOf(InterpreterToVM.wordJavaKind()));
                    }
                }
                ++i;
            }
        } else if (componentType.isPrimitive()) {
            int i = firstIndex;
            while (i - firstIndex < length) {
                switch (componentStorageTag) {
                    case 73: {
                        int value = InterpreterToVM.getArrayInt(i, (int[])array);
                        writer.writeInt(value);
                        break;
                    }
                    case 70: {
                        float value = InterpreterToVM.getArrayFloat(i, (float[])array);
                        writer.writeFloat(value);
                        break;
                    }
                    case 68: {
                        double value = InterpreterToVM.getArrayDouble(i, (double[])array);
                        writer.writeDouble(value);
                        break;
                    }
                    case 74: {
                        long value = InterpreterToVM.getArrayLong(i, (long[])array);
                        writer.writeLong(value);
                        break;
                    }
                    case 66: {
                        byte value = InterpreterToVM.getArrayByte(i, array);
                        writer.writeByte(value);
                        break;
                    }
                    case 83: {
                        short value = InterpreterToVM.getArrayShort(i, (short[])array);
                        writer.writeShort(value);
                        break;
                    }
                    case 67: {
                        char value = InterpreterToVM.getArrayChar(i, (char[])array);
                        writer.writeChar(value);
                        break;
                    }
                    case 90: {
                        byte value = InterpreterToVM.getArrayByte(i, array);
                        writer.writeBoolean(value != 0);
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere("Illegal primitive component tag: " + componentStorageTag);
                    }
                }
                ++i;
            }
        } else {
            int i = firstIndex;
            while (i - firstIndex < length) {
                Object value = InterpreterToVM.getArrayObject(i, (Object[])array);
                ResidentJDWP.writeTaggedObject(writer, value);
                ++i;
            }
        }
        return reply;
    }

    @Override
    public Packet ArrayReference_SetValues(Packet packet) throws JDWPException {
        byte componentStorageTag;
        Packet.Reader reader = packet.newDataReader();
        Object array = ResidentJDWP.readArray(reader);
        int firstIndex = reader.readInt();
        int length = reader.readInt();
        int arrayLength = InterpreterToVM.arrayLength(array);
        ResidentJDWP.validateArrayRegion(firstIndex, length, arrayLength);
        Class<?> componentType = array.getClass().getComponentType();
        boolean isWordTypeComponent = WordBase.class.isAssignableFrom(componentType);
        if (isWordTypeComponent) {
            componentStorageTag = switch (InterpreterToVM.wordJavaKind()) {
                case JavaKind.Int -> 73;
                case JavaKind.Long -> 74;
                default -> throw VMError.shouldNotReachHere("Unexpected word kind " + String.valueOf(InterpreterToVM.wordJavaKind()));
            };
        } else {
            componentStorageTag = TagConstants.getTagFromClass(componentType);
        }
        assert (firstIndex >= 0);
        assert (firstIndex < arrayLength);
        assert (firstIndex <= arrayLength - length);
        if (isWordTypeComponent) {
            int i = firstIndex;
            while (i - firstIndex < length) {
                switch (InterpreterToVM.wordJavaKind()) {
                    case Int: {
                        SignedWord value = Word.signed((int)reader.readInt());
                        InterpreterToVM.setArrayWord((WordBase)value, i, (WordBase[])array);
                        break;
                    }
                    case Long: {
                        SignedWord value = Word.signed((long)reader.readLong());
                        InterpreterToVM.setArrayWord((WordBase)value, i, (WordBase[])array);
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere("Unexpected word kind " + String.valueOf(InterpreterToVM.wordJavaKind()));
                    }
                }
                ++i;
            }
        } else if (componentType.isPrimitive()) {
            int i = firstIndex;
            while (i - firstIndex < length) {
                switch (componentStorageTag) {
                    case 73: {
                        int value = reader.readInt();
                        InterpreterToVM.setArrayInt(value, i, (int[])array);
                        break;
                    }
                    case 70: {
                        float value = reader.readFloat();
                        InterpreterToVM.setArrayFloat(value, i, (float[])array);
                        break;
                    }
                    case 68: {
                        double value = reader.readDouble();
                        InterpreterToVM.setArrayDouble(value, i, (double[])array);
                        break;
                    }
                    case 74: {
                        long value = reader.readLong();
                        InterpreterToVM.setArrayLong(value, i, (long[])array);
                        break;
                    }
                    case 66: {
                        byte value = (byte)reader.readByte();
                        InterpreterToVM.setArrayByte(value, i, array);
                        break;
                    }
                    case 83: {
                        short value = reader.readShort();
                        InterpreterToVM.setArrayShort(value, i, (short[])array);
                        break;
                    }
                    case 67: {
                        char value = reader.readChar();
                        InterpreterToVM.setArrayChar(value, i, (char[])array);
                        break;
                    }
                    case 90: {
                        boolean value = reader.readBoolean();
                        InterpreterToVM.setArrayByte(value ? (byte)1 : 0, i, array);
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere("Illegal primitive component tag: " + componentStorageTag);
                    }
                }
                ++i;
            }
        } else {
            int i = firstIndex;
            while (i - firstIndex < length) {
                Object value = ResidentJDWP.readReferenceOrNull(reader);
                if (value != null && !componentType.isInstance(value)) {
                    throw JDWPException.raise(ErrorCode.TYPE_MISMATCH);
                }
                InterpreterToVM.setArrayObject(value, i, (Object[])array);
                ++i;
            }
        }
        assert (reader.isEndOfInput());
        return WritablePacket.newReplyTo(packet);
    }

    @Override
    public Packet ArrayType_NewInstance(Packet packet) throws JDWPException {
        Object array;
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType arrayType = ResidentJDWP.readType(reader);
        if (!arrayType.isArray()) {
            throw JDWPException.raise(ErrorCode.TYPE_MISMATCH);
        }
        int length = reader.readInt();
        if (length < 0) {
            throw JDWPException.raise(ErrorCode.INVALID_LENGTH);
        }
        assert (reader.isEndOfInput());
        ResolvedJavaType componentType = arrayType.getComponentType();
        try {
            if (componentType.isPrimitive()) {
                assert (componentType.getJavaKind() != JavaKind.Void);
                array = InterpreterToVM.createNewPrimitiveArray((byte)componentType.getJavaKind().getBasicType(), length);
            } else {
                array = InterpreterToVM.createNewReferenceArray((InterpreterResolvedJavaType)componentType, length);
            }
        }
        catch (OutOfMemoryError e) {
            throw JDWPException.raise(ErrorCode.OUT_OF_MEMORY);
        }
        assert (array != null);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        ResidentJDWP.writeTaggedObject(writer, array);
        return reply;
    }

    private static StackframeDescriptor getStackframeDescriptor(Thread thread, int frameDepth) {
        assert (!thread.isVirtual());
        GetStackframeDescriptorAtDepthVisitor visitor = new GetStackframeDescriptorAtDepthVisitor(false, frameDepth);
        SafeStackWalker.safeStackWalk(thread, visitor);
        return visitor;
    }

    public static Object getThis(Thread thread, int frameDepth) {
        Object thisObject;
        StackframeDescriptor stackframeDescriptor = ResidentJDWP.getStackframeDescriptor(thread, frameDepth);
        FrameSourceInfo frameSourceInfo = stackframeDescriptor.getFrameSourceInfo();
        ResidentJDWP.require(frameSourceInfo != null, ErrorCode.INVALID_FRAMEID, "Frame depth %s not found for thread.threadId()=%s", frameDepth, thread.threadId());
        if (frameSourceInfo instanceof InterpreterFrameSourceInfo) {
            InterpreterFrameSourceInfo interpreterJavaFrameInfo = (InterpreterFrameSourceInfo)frameSourceInfo;
            ResolvedJavaMethod method = interpreterJavaFrameInfo.getInterpretedMethod();
            if (method.isStatic() || method.isNative()) {
                thisObject = null;
            } else {
                InterpreterFrame interpreterFrame = (InterpreterFrame)interpreterJavaFrameInfo.getInterpreterFrame();
                thisObject = EspressoFrame.getThis(interpreterFrame);
            }
        } else {
            FrameInfoQueryResult frameInfoQueryResult = (FrameInfoQueryResult)frameSourceInfo;
            if (frameInfoQueryResult.isNativeMethod()) {
                thisObject = null;
            } else {
                InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
                ResolvedJavaType type = universe.lookupType(frameInfoQueryResult.getSourceClass());
                ResolvedJavaMethod method = JDWPBridgeImpl.findSourceMethod(type, frameInfoQueryResult);
                assert (!method.isNative());
                if (method.isStatic()) {
                    thisObject = null;
                } else {
                    DeoptState deoptState = new DeoptState(stackframeDescriptor.getStackPointer(), (IsolateThread)Word.zero());
                    JavaConstant javaConstant = deoptState.readLocalVariable(0, frameInfoQueryResult);
                    thisObject = SubstrateObjectConstant.asObject((Constant)javaConstant);
                }
            }
        }
        return thisObject;
    }

    @Override
    public Packet StackFrame_ThisObject(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Thread thread = ResidentJDWP.readThread(reader);
        assert (!thread.isVirtual());
        long frameId = reader.readLong();
        int frameDepth = FrameId.getFrameDepth(frameId);
        assert (reader.isEndOfInput());
        Object thisObject = ResidentJDWP.getThis(thread, frameDepth);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        ResidentJDWP.writeTaggedObject(writer, thisObject);
        return reply;
    }

    @Override
    public Packet StackFrame_GetValues(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Thread thread = ResidentJDWP.readThread(reader);
        assert (!thread.isVirtual());
        long frameId = reader.readLong();
        int frameDepth = FrameId.getFrameDepth(frameId);
        assert (frameDepth >= 0);
        int slots = reader.readInt();
        assert (slots >= 0);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        StackframeDescriptor stackframeDescriptor = ResidentJDWP.getStackframeDescriptor(thread, frameDepth);
        FrameSourceInfo frameSourceInfo = stackframeDescriptor.getFrameSourceInfo();
        ResidentJDWP.require(frameSourceInfo != null, ErrorCode.INVALID_FRAMEID, "Frame depth %s not found for thread.threadId()=%s", frameDepth, thread.threadId());
        writer.writeInt(slots);
        Pointer stackPointer = stackframeDescriptor.getStackPointer();
        for (int i = 0; i < slots; ++i) {
            int slot = reader.readInt();
            byte tag = JDWP.readTag(reader);
            if (frameSourceInfo instanceof InterpreterFrameSourceInfo) {
                InterpreterFrameSourceInfo interpreterJavaFrameInfo = (InterpreterFrameSourceInfo)frameSourceInfo;
                ResidentJDWP.readLocalFromInterpreterFrame(tag, interpreterJavaFrameInfo, slot, writer);
                continue;
            }
            FrameInfoQueryResult frameInfoQueryResult = (FrameInfoQueryResult)frameSourceInfo;
            ResidentJDWP.readLocalFromCompiledFrame(tag, frameInfoQueryResult, stackPointer, slot, writer);
        }
        assert (reader.isEndOfInput());
        return reply;
    }

    private static void sharedReadField(Packet.Writer writer, Object typeOrReceiver, InterpreterResolvedJavaField field) {
        Object receiver;
        JavaKind fieldKind = field.getJavaKind();
        if (field.isStatic()) {
            assert (typeOrReceiver instanceof InterpreterResolvedJavaType);
            receiver = fieldKind.isPrimitive() || field.getType().isWordType() ? StaticFieldsSupport.getStaticPrimitiveFieldsAtRuntime(0) : StaticFieldsSupport.getStaticObjectFieldsAtRuntime(0);
        } else {
            receiver = typeOrReceiver;
            assert (receiver != null);
        }
        if (field.isUndefined()) {
            writer.writeByte(86);
            return;
        }
        assert (!field.isUndefined()) : "Cannot read undefined field " + String.valueOf(field);
        if (field.getType().isWordType()) {
            switch (InterpreterToVM.wordJavaKind()) {
                case Int: {
                    writer.writeByte(73);
                    writer.writeInt((int)InterpreterToVM.getFieldWord(receiver, field).rawValue());
                    break;
                }
                case Long: {
                    writer.writeByte(74);
                    writer.writeLong(InterpreterToVM.getFieldWord(receiver, field).rawValue());
                }
            }
            return;
        }
        switch (fieldKind) {
            case Boolean: {
                writer.writeByte(90);
                writer.writeBoolean(InterpreterToVM.getFieldBoolean(receiver, field));
                break;
            }
            case Byte: {
                writer.writeByte(66);
                writer.writeByte(InterpreterToVM.getFieldByte(receiver, field));
                break;
            }
            case Short: {
                writer.writeByte(83);
                writer.writeShort(InterpreterToVM.getFieldShort(receiver, field));
                break;
            }
            case Char: {
                writer.writeByte(67);
                writer.writeChar(InterpreterToVM.getFieldChar(receiver, field));
                break;
            }
            case Int: {
                writer.writeByte(73);
                writer.writeInt(InterpreterToVM.getFieldInt(receiver, field));
                break;
            }
            case Float: {
                writer.writeByte(70);
                writer.writeFloat(InterpreterToVM.getFieldFloat(receiver, field));
                break;
            }
            case Long: {
                writer.writeByte(74);
                writer.writeLong(InterpreterToVM.getFieldLong(receiver, field));
                break;
            }
            case Double: {
                writer.writeByte(68);
                writer.writeDouble(InterpreterToVM.getFieldDouble(receiver, field));
                break;
            }
            case Object: {
                Object value = InterpreterToVM.getFieldObject(receiver, field);
                ResidentJDWP.writeTaggedObject(writer, value);
                break;
            }
            default: {
                throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
            }
        }
    }

    @Override
    public Packet ObjectReference_GetValues(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Object object = ResidentJDWP.readReferenceOrNull(reader);
        if (object == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        int length = reader.readInt();
        assert (length >= 0);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(length);
        for (int i = 0; i < length; ++i) {
            InterpreterResolvedJavaField field = ResidentJDWP.readField(reader);
            if (field.isStatic() || !InterpreterToVM.instanceOf(object, field.getDeclaringClass())) {
                throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
            }
            ResidentJDWP.sharedReadField(writer, object, field);
        }
        assert (reader.isEndOfInput());
        return reply;
    }

    @Override
    public Packet ReferenceType_GetValues(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        int length = reader.readInt();
        assert (length >= 0);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(length);
        for (int i = 0; i < length; ++i) {
            InterpreterResolvedJavaField field = ResidentJDWP.readField(reader);
            if (!field.isStatic() || !field.getDeclaringClass().getJavaClass().isAssignableFrom(type.getJavaClass())) {
                throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
            }
            ResidentJDWP.sharedReadField(writer, type, field);
        }
        assert (reader.isEndOfInput());
        return reply;
    }

    @Override
    public Packet ClassLoaderReference_VisibleClasses(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Object object = ResidentJDWP.readReferenceOrNull(reader);
        if (object != null && !(object instanceof ClassLoader)) {
            throw JDWPException.raise(ErrorCode.INVALID_CLASS_LOADER);
        }
        assert (reader.isEndOfInput());
        ClassLoader classLoader = (ClassLoader)object;
        List<ResolvedJavaType> visibleTypes = ResidentJDWP.classesWithInitiatingClassLoader(classLoader);
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(visibleTypes.size());
        for (ResolvedJavaType type : visibleTypes) {
            writer.writeByte(TypeTag.getKind(type));
            writer.writeLong(JDWPBridgeImpl.getIds().getIdOrCreateWeak(type));
        }
        return reply;
    }

    private static Class<?> getElementalClass(Class<?> clazz) {
        Class<?> elemental = clazz;
        while (elemental.isArray()) {
            elemental = elemental.getComponentType();
        }
        return elemental;
    }

    private static List<ResolvedJavaType> classesWithInitiatingClassLoader(ClassLoader classLoader) {
        ArrayList<ResolvedJavaType> visibleTypes = new ArrayList<ResolvedJavaType>();
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        for (ResolvedJavaType resolvedJavaType : universe.getTypes()) {
            Class<?> javaClass;
            if (resolvedJavaType.isPrimitive() || !DynamicHub.fromClass(javaClass = ((InterpreterResolvedJavaType)resolvedJavaType).getJavaClass()).isLoaded() || ResidentJDWP.getElementalClass(javaClass).isHidden()) continue;
            Object bootLoader = null;
            ClassLoader platformLoader = ClassLoader.getPlatformClassLoader();
            ClassLoader appLoader = ClassLoader.getSystemClassLoader();
            ClassLoader loader = javaClass.getClassLoader();
            boolean isClassVisible = false;
            if (classLoader == bootLoader) {
                isClassVisible = loader == bootLoader;
            } else if (classLoader == platformLoader) {
                isClassVisible = loader == bootLoader || loader == platformLoader;
            } else if (classLoader == appLoader) {
                isClassVisible = loader == bootLoader || loader == platformLoader || loader == appLoader;
            } else {
                Class<?> forNameClass = ClassForNameSupport.forNameOrNull(resolvedJavaType.toClassName(), classLoader);
                if (javaClass == forNameClass) {
                    isClassVisible = true;
                }
            }
            if (!isClassVisible) continue;
            visibleTypes.add(resolvedJavaType);
        }
        return visibleTypes;
    }

    private static void readLocalFromCompiledFrame(byte tag, FrameInfoQueryResult frame, Pointer stackPointer, int slot, Packet.Writer writer) throws JDWPException {
        if (slot < 0 || slot > frame.getNumLocals()) {
            throw JDWPException.raise(ErrorCode.INVALID_SLOT);
        }
        if (frame.getValueInfos() == null) {
            throw JDWPException.raise(ErrorCode.ABSENT_INFORMATION);
        }
        IsolateThread targetThread = (IsolateThread)Word.zero();
        DeoptState deoptState = new DeoptState(stackPointer, targetThread);
        JavaConstant javaConstant = deoptState.readLocalVariable(slot, frame);
        if (javaConstant.getJavaKind().equals((Object)JavaKind.Illegal)) {
            throw JDWPException.raise(ErrorCode.ABSENT_INFORMATION);
        }
        switch (tag) {
            case 66: {
                ResidentJDWP.expectKind(javaConstant, JavaKind.Byte.getStackKind());
                writer.writeByte(66);
                writer.writeByte((byte)javaConstant.asInt());
                break;
            }
            case 90: {
                ResidentJDWP.expectKind(javaConstant, JavaKind.Boolean.getStackKind());
                writer.writeByte(90);
                writer.writeBoolean(javaConstant.asInt() != 0);
                break;
            }
            case 83: {
                ResidentJDWP.expectKind(javaConstant, JavaKind.Short.getStackKind());
                writer.writeByte(83);
                writer.writeShort((short)javaConstant.asInt());
                break;
            }
            case 67: {
                ResidentJDWP.expectKind(javaConstant, JavaKind.Char.getStackKind());
                writer.writeByte(67);
                writer.writeChar((char)javaConstant.asInt());
                break;
            }
            case 73: {
                ResidentJDWP.expectKind(javaConstant, JavaKind.Int);
                writer.writeByte(73);
                writer.writeInt(javaConstant.asInt());
                break;
            }
            case 74: {
                ResidentJDWP.expectKind(javaConstant, JavaKind.Long);
                writer.writeByte(74);
                writer.writeLong(javaConstant.asLong());
                break;
            }
            case 70: {
                ResidentJDWP.expectKind(javaConstant, JavaKind.Float);
                writer.writeByte(70);
                writer.writeFloat(javaConstant.asFloat());
                break;
            }
            case 68: {
                ResidentJDWP.expectKind(javaConstant, JavaKind.Double);
                writer.writeByte(68);
                writer.writeDouble(javaConstant.asDouble());
                break;
            }
            case 86: {
                writer.writeByte(86);
                break;
            }
            default: {
                ResidentJDWP.expectKind(javaConstant, JavaKind.Object);
                Object value = SubstrateObjectConstant.asObject((Constant)javaConstant);
                byte valueTag = TagConstants.getTagFromReference(value);
                writer.writeByte(valueTag);
                writer.writeLong(JDWPBridgeImpl.getIds().getIdOrCreateWeak(value));
            }
        }
    }

    private static void expectKind(JavaConstant jc, JavaKind expectedKind) {
        JavaKind givenKind = jc.getJavaKind();
        if (givenKind != expectedKind) {
            throw JDWPException.raise(ErrorCode.INVALID_TAG);
        }
    }

    private static void readLocalFromInterpreterFrame(byte tag, InterpreterFrameSourceInfo interpreterJavaFrameInfo, int slot, Packet.Writer writer) throws JDWPException {
        LocalVariableTable localVariableTable = interpreterJavaFrameInfo.getInterpretedMethod().getLocalVariableTable();
        if (localVariableTable != null) {
            JavaKind tagKind;
            Local local = localVariableTable.getLocal(slot, interpreterJavaFrameInfo.getBci());
            if (local == null) {
                throw JDWPException.raise(ErrorCode.INVALID_SLOT);
            }
            JavaKind localKind = local.getType().getJavaKind();
            if (localKind != (tagKind = TagConstants.tagToKind(tag))) {
                throw JDWPException.raise(ErrorCode.INVALID_TAG);
            }
        }
        InterpreterFrame interpreterFrame = (InterpreterFrame)interpreterJavaFrameInfo.getInterpreterFrame();
        switch (tag) {
            case 66: {
                int value = EspressoFrame.getLocalInt(interpreterFrame, slot);
                writer.writeByte(66);
                writer.writeByte((byte)value);
                break;
            }
            case 90: {
                int value = EspressoFrame.getLocalInt(interpreterFrame, slot);
                writer.writeByte(90);
                writer.writeBoolean(value != 0);
                break;
            }
            case 83: {
                int value = EspressoFrame.getLocalInt(interpreterFrame, slot);
                writer.writeByte(83);
                writer.writeShort((short)value);
                break;
            }
            case 67: {
                int value = EspressoFrame.getLocalInt(interpreterFrame, slot);
                writer.writeByte(67);
                writer.writeChar((char)value);
                break;
            }
            case 73: {
                int value = EspressoFrame.getLocalInt(interpreterFrame, slot);
                writer.writeByte(73);
                writer.writeInt(value);
                break;
            }
            case 74: {
                long value = EspressoFrame.getLocalLong(interpreterFrame, slot);
                writer.writeByte(74);
                writer.writeLong(value);
                break;
            }
            case 70: {
                float value = EspressoFrame.getLocalFloat(interpreterFrame, slot);
                writer.writeByte(70);
                writer.writeFloat(value);
                break;
            }
            case 68: {
                double value = EspressoFrame.getLocalDouble(interpreterFrame, slot);
                writer.writeByte(68);
                writer.writeDouble(value);
                break;
            }
            case 86: {
                writer.writeByte(86);
                break;
            }
            default: {
                Object value = EspressoFrame.getLocalObject(interpreterFrame, slot);
                ResidentJDWP.writeTaggedObject(writer, value);
            }
        }
    }

    @Override
    public Packet ClassType_SetValues(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        if (!DynamicHub.fromClass(type.getJavaClass()).isLoaded()) {
            throw JDWPException.raise(ErrorCode.CLASS_NOT_PREPARED);
        }
        int fieldCount = reader.readInt();
        assert (fieldCount >= 0);
        for (int i = 0; i < fieldCount; ++i) {
            InterpreterResolvedJavaField field = ResidentJDWP.readField(reader);
            InterpreterResolvedJavaType fieldType = field.getType();
            if (!field.isStatic()) {
                throw JDWPException.raise(ErrorCode.ILLEGAL_ARGUMENT);
            }
            if (field.isUndefined() || fieldType.isWordType() || field.isUnmaterializedConstant()) {
                throw JDWPException.raise(ErrorCode.ILLEGAL_ARGUMENT);
            }
            ResidentJDWP.sharedWriteField(reader, type, field);
        }
        assert (reader.isEndOfInput());
        return WritablePacket.newReplyTo(packet);
    }

    @Override
    public Packet ObjectReference_SetValues(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Object receiver = ResidentJDWP.readReferenceOrNull(reader);
        if (receiver == null) {
            throw JDWPException.raise(ErrorCode.ILLEGAL_ARGUMENT);
        }
        int fieldCount = reader.readInt();
        assert (fieldCount >= 0);
        for (int i = 0; i < fieldCount; ++i) {
            InterpreterResolvedJavaField field = ResidentJDWP.readField(reader);
            InterpreterResolvedJavaType fieldType = field.getType();
            if (field.isStatic()) {
                throw JDWPException.raise(ErrorCode.ILLEGAL_ARGUMENT);
            }
            if (field.isUndefined() || fieldType.isWordType() || field.isUnmaterializedConstant()) {
                throw JDWPException.raise(ErrorCode.ILLEGAL_ARGUMENT);
            }
            ResidentJDWP.sharedWriteField(reader, receiver, field);
        }
        assert (reader.isEndOfInput());
        return WritablePacket.newReplyTo(packet);
    }

    private static void sharedWriteField(Packet.Reader reader, Object typeOrReceiver, InterpreterResolvedJavaField field) {
        Object receiver;
        JavaKind fieldKind = field.getJavaKind();
        if (field.isStatic()) {
            assert (typeOrReceiver instanceof InterpreterResolvedJavaType);
            receiver = fieldKind.isPrimitive() || field.getType().isWordType() ? StaticFieldsSupport.getStaticPrimitiveFieldsAtRuntime(0) : StaticFieldsSupport.getStaticObjectFieldsAtRuntime(0);
        } else {
            receiver = typeOrReceiver;
            assert (receiver != null);
        }
        if (field.isUndefined() || field.isUnmaterializedConstant()) {
            throw JDWPException.raise(ErrorCode.ILLEGAL_ARGUMENT);
        }
        assert (!field.isUndefined() && !field.isUnmaterializedConstant()) : "Cannot write undefined or unmaterialized field " + String.valueOf(field);
        if (field.getType().isWordType()) {
            switch (InterpreterToVM.wordJavaKind()) {
                case Int: {
                    InterpreterToVM.setFieldWord((WordBase)Word.signed((int)reader.readInt()), receiver, field);
                    break;
                }
                case Long: {
                    InterpreterToVM.setFieldWord((WordBase)Word.signed((long)reader.readLong()), receiver, field);
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere("Unexpected word kind " + String.valueOf(InterpreterToVM.wordJavaKind()));
                }
            }
            return;
        }
        switch (fieldKind) {
            case Boolean: {
                InterpreterToVM.setFieldBoolean(reader.readBoolean(), receiver, field);
                break;
            }
            case Byte: {
                InterpreterToVM.setFieldByte((byte)reader.readByte(), receiver, field);
                break;
            }
            case Short: {
                InterpreterToVM.setFieldShort(reader.readShort(), receiver, field);
                break;
            }
            case Char: {
                InterpreterToVM.setFieldChar(reader.readChar(), receiver, field);
                break;
            }
            case Int: {
                InterpreterToVM.setFieldInt(reader.readInt(), receiver, field);
                break;
            }
            case Float: {
                InterpreterToVM.setFieldFloat(reader.readFloat(), receiver, field);
                break;
            }
            case Long: {
                InterpreterToVM.setFieldLong(reader.readLong(), receiver, field);
                break;
            }
            case Double: {
                InterpreterToVM.setFieldDouble(reader.readDouble(), receiver, field);
                break;
            }
            case Object: {
                assert (!field.getType().isWordType()) : field;
                Object value = ResidentJDWP.readReferenceOrNull(reader);
                if (value != null && !field.getType().getJavaClass().isInstance(value)) {
                    throw JDWPException.raise(ErrorCode.TYPE_MISMATCH);
                }
                InterpreterToVM.setFieldObject(value, receiver, field);
                break;
            }
            default: {
                throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
            }
        }
    }

    @Override
    public Packet StackFrame_SetValues(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Thread thread = ResidentJDWP.readThread(reader);
        assert (!thread.isVirtual());
        long frameId = reader.readLong();
        int frameDepth = FrameId.getFrameDepth(frameId);
        assert (frameDepth >= 0);
        int slotValues = reader.readInt();
        assert (slotValues >= 0);
        StackframeDescriptor stackframeDescriptor = ResidentJDWP.getStackframeDescriptor(thread, frameDepth);
        FrameSourceInfo frameSourceInfo = stackframeDescriptor.getFrameSourceInfo();
        ResidentJDWP.require(frameSourceInfo != null, ErrorCode.INVALID_FRAMEID, "Frame depth %s not found for thread.threadId()=%s", frameDepth, thread.threadId());
        if (!(frameSourceInfo instanceof InterpreterFrameSourceInfo)) {
            throw JDWPException.raise(ErrorCode.NOT_IMPLEMENTED);
        }
        for (int i = 0; i < slotValues; ++i) {
            int slot = reader.readInt();
            byte tag = JDWP.readTag(reader);
            InterpreterFrameSourceInfo interpreterJavaFrameInfo = (InterpreterFrameSourceInfo)frameSourceInfo;
            ResidentJDWP.writeLocalToInterpreterFrame(tag, interpreterJavaFrameInfo, slot, reader);
        }
        assert (reader.isEndOfInput());
        return WritablePacket.newReplyTo(packet);
    }

    private static void writeLocalToInterpreterFrame(byte tag, InterpreterFrameSourceInfo interpreterJavaFrameInfo, int slot, Packet.Reader reader) {
        LocalVariableTable localVariableTable = interpreterJavaFrameInfo.getInterpretedMethod().getLocalVariableTable();
        if (localVariableTable != null) {
            JavaKind tagKind;
            Local local = localVariableTable.getLocal(slot, interpreterJavaFrameInfo.getBci());
            if (local == null) {
                throw JDWPException.raise(ErrorCode.INVALID_SLOT);
            }
            JavaKind localKind = local.getType().getJavaKind();
            if (localKind != (tagKind = TagConstants.tagToKind(tag))) {
                throw JDWPException.raise(ErrorCode.INVALID_TAG);
            }
        }
        InterpreterFrame interpreterFrame = (InterpreterFrame)interpreterJavaFrameInfo.getInterpreterFrame();
        switch (tag) {
            case 66: {
                EspressoFrame.setLocalInt(interpreterFrame, slot, (byte)reader.readByte());
                break;
            }
            case 90: {
                EspressoFrame.setLocalInt(interpreterFrame, slot, reader.readBoolean() ? 1 : 0);
                break;
            }
            case 83: {
                EspressoFrame.setLocalInt(interpreterFrame, slot, reader.readShort());
                break;
            }
            case 67: {
                EspressoFrame.setLocalInt(interpreterFrame, slot, reader.readChar());
                break;
            }
            case 73: {
                EspressoFrame.setLocalInt(interpreterFrame, slot, reader.readInt());
                break;
            }
            case 74: {
                EspressoFrame.setLocalLong(interpreterFrame, slot, reader.readLong());
                break;
            }
            case 70: {
                EspressoFrame.setLocalFloat(interpreterFrame, slot, reader.readFloat());
                break;
            }
            case 68: {
                EspressoFrame.setLocalDouble(interpreterFrame, slot, reader.readDouble());
                break;
            }
            case 86: {
                break;
            }
            default: {
                EspressoFrame.setLocalObject(interpreterFrame, slot, ResidentJDWP.readReferenceOrNull(reader));
            }
        }
    }

    private static Object[] readArguments(Packet.Reader reader) {
        int argCount = reader.readInt();
        assert (argCount >= 0);
        Object[] args = new Object[argCount];
        block11: for (int i = 0; i < argCount; ++i) {
            byte tag = JDWP.readTag(reader);
            switch (tag) {
                case 66: {
                    args[i] = (byte)reader.readByte();
                    continue block11;
                }
                case 90: {
                    args[i] = reader.readBoolean();
                    continue block11;
                }
                case 83: {
                    args[i] = reader.readShort();
                    continue block11;
                }
                case 67: {
                    args[i] = Character.valueOf(reader.readChar());
                    continue block11;
                }
                case 73: {
                    args[i] = reader.readInt();
                    continue block11;
                }
                case 74: {
                    args[i] = reader.readLong();
                    continue block11;
                }
                case 70: {
                    args[i] = Float.valueOf(reader.readFloat());
                    continue block11;
                }
                case 68: {
                    args[i] = reader.readDouble();
                    continue block11;
                }
                case 86: {
                    continue block11;
                }
                default: {
                    args[i] = ResidentJDWP.readReferenceOrNull(reader);
                }
            }
        }
        return args;
    }

    private static void writeTaggedValue(Packet.Writer writer, Object value, JavaKind valueKind) {
        switch (valueKind) {
            case Boolean: {
                writer.writeByte(90);
                writer.writeBoolean((Boolean)value);
                break;
            }
            case Byte: {
                writer.writeByte(66);
                writer.writeByte(((Byte)value).byteValue());
                break;
            }
            case Short: {
                writer.writeByte(83);
                writer.writeShort((Short)value);
                break;
            }
            case Char: {
                writer.writeByte(67);
                writer.writeChar(((Character)value).charValue());
                break;
            }
            case Int: {
                writer.writeByte(73);
                writer.writeInt((Integer)value);
                break;
            }
            case Float: {
                writer.writeByte(70);
                writer.writeFloat(((Float)value).floatValue());
                break;
            }
            case Long: {
                writer.writeByte(74);
                writer.writeLong((Long)value);
                break;
            }
            case Double: {
                writer.writeByte(68);
                writer.writeDouble((Double)value);
                break;
            }
            case Object: {
                ResidentJDWP.writeTaggedObject(writer, value);
                break;
            }
            case Void: {
                writer.writeByte(86);
                break;
            }
            default: {
                throw VMError.shouldNotReachHere("unexpected kind " + String.valueOf(valueKind));
            }
        }
    }

    private static void require(boolean condition, ErrorCode errorCode, String logMessageSimpleFormat, Object ... args) throws JDWPException {
        if (!condition) {
            LOGGER.log(logMessageSimpleFormat, args);
            throw JDWPException.raise(errorCode);
        }
    }

    private static void require(boolean condition, ErrorCode errorCode) throws JDWPException {
        if (!condition) {
            throw JDWPException.raise(errorCode);
        }
    }

    static Packet invokeReply(Packet packet, Result invokeResult, JavaKind returnValueKind) {
        return ResidentJDWP.invokeReply(packet, invokeResult.value(), invokeResult.throwable(), returnValueKind);
    }

    static Packet invokeReply(Packet packet, Object value, Throwable throwable, JavaKind returnValueKind) {
        WritablePacket reply = WritablePacket.newReplyTo(packet);
        Packet.Writer writer = reply.dataWriter();
        if (throwable != null) {
            ResidentJDWP.writeTaggedObject(writer, null);
        } else {
            ResidentJDWP.writeTaggedValue(writer, value, returnValueKind);
        }
        ResidentJDWP.writeTaggedObject(writer, throwable);
        return reply;
    }

    @Override
    public Packet ClassType_InvokeMethod(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        Thread thread = ResidentJDWP.readThread(reader);
        InterpreterResolvedJavaMethod method = ResidentJDWP.readMethod(reader);
        Object[] args = ResidentJDWP.readArguments(reader);
        int options = reader.readInt();
        assert (reader.isEndOfInput());
        ResidentJDWP.require(thread == Thread.currentThread(), ErrorCode.ILLEGAL_ARGUMENT, "method invocation only supports current/same thread", new Object[0]);
        ResidentJDWP.require(method.isStatic(), ErrorCode.ILLEGAL_ARGUMENT, "method must be static %s", method);
        ResidentJDWP.require(type.equals(method.getDeclaringClass()), ErrorCode.ILLEGAL_ARGUMENT, "method declaring type %s and type %s differ", method.getDeclaringClass(), type);
        ResidentJDWP.require(!thread.isVirtual(), ErrorCode.ILLEGAL_ARGUMENT, "virtual threads not supported", new Object[0]);
        return ResidentJDWP.invokeReply(packet, Result.ofInvoke(false, method, args), method.getSignature().getReturnKind());
    }

    @Override
    public Packet InterfaceType_InvokeMethod(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        Thread thread = ResidentJDWP.readThread(reader);
        InterpreterResolvedJavaMethod method = ResidentJDWP.readMethod(reader);
        Object[] args = ResidentJDWP.readArguments(reader);
        int options = reader.readInt();
        assert (reader.isEndOfInput());
        ResidentJDWP.require(!method.isClassInitializer(), ErrorCode.ILLEGAL_ARGUMENT, "method cannot be a static initializer %s", method);
        ResidentJDWP.require(method.isStatic(), ErrorCode.ILLEGAL_ARGUMENT, "method must be be static %s", method);
        ResidentJDWP.require(type.equals(method.getDeclaringClass()), ErrorCode.ILLEGAL_ARGUMENT, "method declaring type %s and type %s differ", method.getDeclaringClass(), type);
        ResidentJDWP.require(type.isInterface(), ErrorCode.ILLEGAL_ARGUMENT, "type %s is not an interface", new Object[0]);
        ResidentJDWP.require(type.equals(method.getDeclaringClass()), ErrorCode.ILLEGAL_ARGUMENT, "method %s is not a member of the interface type %s", method, type);
        ResidentJDWP.require(!thread.isVirtual(), ErrorCode.ILLEGAL_ARGUMENT, "virtual threads not supported", new Object[0]);
        return ResidentJDWP.invokeReply(packet, Result.ofInvoke(false, method, args), method.getSignature().getReturnKind());
    }

    @Override
    public Packet ObjectReference_InvokeMethod(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        Object receiver = ResidentJDWP.readReferenceOrNull(reader);
        Thread thread = ResidentJDWP.readThread(reader);
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        InterpreterResolvedJavaMethod method = ResidentJDWP.readMethod(reader);
        Object[] argsWithoutReceiver = ResidentJDWP.readArguments(reader);
        int options = reader.readInt();
        assert (reader.isEndOfInput());
        ResidentJDWP.require(receiver != null, ErrorCode.ILLEGAL_ARGUMENT, "receiver is null", new Object[0]);
        ResidentJDWP.require(!method.isStatic(), ErrorCode.ILLEGAL_ARGUMENT, "method cannot be static %s", method);
        ResidentJDWP.require(method.getDeclaringClass().isAssignableFrom(type), ErrorCode.ILLEGAL_ARGUMENT, "method %s is not declared in type %s nor any of its super types (or super interfaces)", method, type);
        ResidentJDWP.require(method.getDeclaringClass().getJavaClass().isInstance(receiver), ErrorCode.ILLEGAL_ARGUMENT, "method %s is not declared in the receiver type %s nor any of its super types (or super interfaces)", method, receiver.getClass());
        ResidentJDWP.require(!thread.isVirtual(), ErrorCode.ILLEGAL_ARGUMENT, "virtual threads not supported", new Object[0]);
        Object[] args = ResidentJDWP.prepend(receiver, argsWithoutReceiver);
        boolean isVirtual = !InvokeOptions.nonVirtual(options);
        return ResidentJDWP.invokeReply(packet, Result.ofInvoke(isVirtual, method, args), method.getSignature().getReturnKind());
    }

    @Override
    public Packet ClassType_NewInstance(Packet packet) throws JDWPException {
        Object instance;
        Packet.Reader reader = packet.newDataReader();
        InterpreterResolvedJavaType type = ResidentJDWP.readType(reader);
        Thread thread = ResidentJDWP.readThread(reader);
        InterpreterResolvedJavaMethod method = ResidentJDWP.readMethod(reader);
        Object[] argsWithoutReceiver = ResidentJDWP.readArguments(reader);
        int options = reader.readInt();
        assert (reader.isEndOfInput());
        ResidentJDWP.require(!type.isPrimitive(), ErrorCode.ILLEGAL_ARGUMENT, "invalid primitive type %s", type);
        ResidentJDWP.require(!type.isArray(), ErrorCode.ILLEGAL_ARGUMENT, "invalid array type %s", type);
        ResidentJDWP.require(!type.isAbstract(), ErrorCode.ILLEGAL_ARGUMENT, "invalid abstract type %s", type);
        ResidentJDWP.require(method.isConstructor(), ErrorCode.ILLEGAL_ARGUMENT, "method is not a constructor %s", method);
        ResidentJDWP.require(!method.isStatic(), ErrorCode.ILLEGAL_ARGUMENT, "constructor cannot be static %s", method);
        ResidentJDWP.require(type.equals(method.getDeclaringClass()), ErrorCode.ILLEGAL_ARGUMENT, "constructor %s is not a member of the given type %s", method, type);
        ResidentJDWP.require(!thread.isVirtual(), ErrorCode.ILLEGAL_ARGUMENT, "virtual threads not supported", new Object[0]);
        try {
            instance = InterpreterToVM.createNewReference(type);
            assert (instance != null);
        }
        catch (SemanticJavaException e) {
            return ResidentJDWP.invokeReply(packet, null, e.getCause(), JavaKind.Object);
        }
        Object[] args = ResidentJDWP.prepend(instance, argsWithoutReceiver);
        return ResidentJDWP.invokeReply(packet, instance, Result.ofInvoke(false, method, args).throwable(), JavaKind.Object);
    }

    private static Object[] prepend(Object newFirst, Object[] array) {
        Object[] newArray = new Object[array.length + 1];
        newArray[0] = newFirst;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    @Override
    public Packet dispatch(Packet packet) throws JDWPException {
        try {
            return JDWP.super.dispatch(packet);
        }
        catch (JDWPException e) {
            LOGGER.log(e, "JDWP exception");
            throw e;
        }
        catch (Throwable t) {
            LOGGER.log(t, "Internal error");
            throw t;
        }
    }

    record Result(Object value, Throwable throwable) {
        static Result fromValue(Object value) {
            return new Result(value, null);
        }

        static Result fromThrowable(Throwable throwable) {
            return new Result(null, MetadataUtil.requireNonNull(throwable));
        }

        static Result ofInvoke(boolean isVirtual, InterpreterResolvedJavaMethod method, Object ... args) {
            try {
                return Result.fromValue(InterpreterToVM.dispatchInvocation(method, args, isVirtual, false, false, false));
            }
            catch (SemanticJavaException e) {
                return Result.fromThrowable(e.getCause());
            }
            catch (OutOfMemoryError | StackOverflowError error) {
                return Result.fromThrowable(error);
            }
        }
    }
}

