/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class DebugOptions {
    private static Map<String, String> parseKeyValues(String text) {
        HashMap<String, String> options = new HashMap<String, String>();
        int index = 0;
        while (index < text.length()) {
            int equalsIndex = text.indexOf(61, index);
            if (equalsIndex < 0) {
                throw new IllegalArgumentException("Invalid key=value at index " + index);
            }
            String key = text.substring(index, equalsIndex);
            int nextIndex = text.indexOf(44, equalsIndex + 1);
            if (nextIndex < 0) {
                nextIndex = text.length();
            }
            String value = text.substring(equalsIndex + 1, nextIndex);
            if (options.containsKey(key)) {
                throw new IllegalArgumentException("Repeated key " + key);
            }
            options.put(key, value);
            index = nextIndex + 1;
        }
        return options;
    }

    private static String checkAllowedValues(String key, String value, String ... allowedValues) {
        for (String allowedValue : allowedValues) {
            if (!Objects.equals(value, allowedValue)) continue;
            return value;
        }
        throw new IllegalArgumentException("Invalid entry " + key + "=" + value + " allowed values: " + String.join((CharSequence)", ", allowedValues));
    }

    private static int checkInt(String key, String value, int lowerBound, int upperBound) {
        int intValue;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid entry " + key + "=" + value + " not an integer");
        }
        if (lowerBound > intValue || intValue > upperBound) {
            throw new IllegalArgumentException("Invalid entry " + key + "=" + value + " must be within [" + lowerBound + ", " + upperBound + "]");
        }
        return intValue;
    }

    public static Options parse(String jdwpOptions, boolean throwIfUnknown) {
        return DebugOptions.parse(jdwpOptions, null, throwIfUnknown, false);
    }

    public static Options parse(String jdwpOptions, String additionalOptions, boolean throwIfUnknown, boolean tracing) {
        Object combinedOptions;
        boolean help = false;
        boolean server = false;
        boolean suspend = true;
        boolean quiet = false;
        int timeout = 0;
        String address = null;
        String host = null;
        int port = 0;
        String transport = null;
        String mode = "native";
        String libraryPath = null;
        String vmOptions = null;
        HashMap<String, String> unknownOptions = new HashMap<String, String>();
        help = "help".equals(jdwpOptions);
        Object object = combinedOptions = help ? "" : jdwpOptions;
        if (additionalOptions != null && !additionalOptions.isEmpty()) {
            if (!((String)combinedOptions).isEmpty()) {
                combinedOptions = (String)combinedOptions + ",";
            }
            combinedOptions = (String)combinedOptions + additionalOptions;
        }
        Map<String, String> keyValues = DebugOptions.parseKeyValues((String)combinedOptions);
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            switch (key) {
                case "server": {
                    server = DebugOptions.checkAllowedValues(key, value, "y", "n").equals("y");
                    break;
                }
                case "suspend": {
                    suspend = DebugOptions.checkAllowedValues(key, value, "y", "n").equals("y");
                    break;
                }
                case "quiet": {
                    quiet = DebugOptions.checkAllowedValues(key, value, "y", "n").equals("y");
                    break;
                }
                case "timeout": {
                    timeout = DebugOptions.checkInt(key, value, 0, Integer.MAX_VALUE);
                    break;
                }
                case "transport": {
                    transport = DebugOptions.checkAllowedValues(key, value, "dt_socket");
                    break;
                }
                case "address": {
                    String inputPort;
                    String[] parts = value.split(":");
                    String inputHost = null;
                    if (parts.length == 1) {
                        inputPort = parts[0];
                    } else if (parts.length == 2) {
                        inputHost = parts[0];
                        inputPort = parts[1];
                    } else {
                        throw new IllegalArgumentException("Invalid entry " + key + "=" + value + " not a '[host:]port' pair");
                    }
                    address = value;
                    host = inputHost;
                    port = DebugOptions.checkInt(key, inputPort, 0, 65535);
                    break;
                }
                case "mode": {
                    String[] parts = value.split(":", 2);
                    mode = DebugOptions.checkAllowedValues(key, parts[0], "native", "jvm");
                    if (parts.length > 1) {
                        libraryPath = parts[1];
                        break;
                    }
                    libraryPath = null;
                    break;
                }
                case "vm.options": {
                    vmOptions = value;
                    break;
                }
                default: {
                    if (throwIfUnknown) {
                        throw new IllegalArgumentException("Unknown/unsupported option: " + key);
                    }
                    unknownOptions.put(key, value);
                }
            }
        }
        return new Options(jdwpOptions, additionalOptions, help, server, suspend, quiet, timeout, address, host, port, transport, mode, libraryPath, vmOptions, tracing, unknownOptions);
    }

    public record Options(String jdwpOptions, String additionalOptions, boolean help, boolean server, boolean suspend, boolean quiet, int timeout, String address, String host, int port, String transport, String mode, String libraryPath, String vmOptions, boolean tracing, Map<String, String> unknownOptions) {
        public boolean hasUnknownOptions() {
            return this.unknownOptions != null && !this.unknownOptions.isEmpty();
        }
    }
}

