/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata.serialization;

import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class ForkedDataOutput
implements DataOutput,
AutoCloseable {
    private final DataOutput root;
    private final ByteArrayOutputStream bytes;
    private final DataOutput delegate;

    ForkedDataOutput(DataOutput root) {
        this.root = ForkedDataOutput.getRoot(root);
        this.bytes = new ByteArrayOutputStream();
        this.delegate = new DataOutputStream(this.bytes);
    }

    private static DataOutput getRoot(DataOutput out) {
        DataOutput root = out;
        while (root instanceof ForkedDataOutput) {
            root = ((ForkedDataOutput)root).root;
        }
        return root;
    }

    @Override
    public void close() throws IOException {
        this.root.write(this.bytes.toByteArray());
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.delegate.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.delegate.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.delegate.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.delegate.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.delegate.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.delegate.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.delegate.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.delegate.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Override
    public void writeUTF(String s) throws IOException {
        throw VMError.shouldNotReachHereAtRuntime();
    }
}

