/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.interpreter.metadata.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Path;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.Signature;

public final class MetadataUtil {
    private static final String METADATA_SUFFIX = ".metadata";

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <T> T requireNonNull(T obj) {
        obj.getClass();
        return obj;
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static int arrayHashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (Object element : a) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public static boolean arrayEquals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (MetadataUtil.equals(a[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static String fmt(String simpleFormat, Object ... args) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int argIndex = 0;
        while (index < simpleFormat.length()) {
            char ch;
            if ((ch = simpleFormat.charAt(index++)) == '%') {
                if (index >= simpleFormat.length()) {
                    throw new IllegalArgumentException("An unquoted '%' character cannot terminate a format specification");
                }
                char specifier = simpleFormat.charAt(index++);
                switch (specifier) {
                    case 's': {
                        if (argIndex >= args.length) {
                            throw new IllegalArgumentException("Too many format specifiers or not enough arguments");
                        }
                        sb.append(args[argIndex++]);
                        break;
                    }
                    case '%': {
                        sb.append('%');
                        break;
                    }
                    case 'n': {
                        sb.append(System.lineSeparator());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal format specifier: " + specifier);
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        if (argIndex < args.length) {
            throw new IllegalArgumentException("Not enough format specifiers or too many arguments");
        }
        return sb.toString();
    }

    public static String toUniqueString(Signature signature) {
        return signature.toMethodDescriptor();
    }

    public static String toUniqueString(JavaMethod method) {
        return MetadataUtil.fmt("%s.%s/%s", MetadataUtil.toUniqueString(method.getDeclaringClass()), method.getName(), MetadataUtil.toUniqueString(method.getSignature()));
    }

    public static String toUniqueString(JavaType type) {
        return type.getName();
    }

    public static String toUniqueString(JavaField field) {
        return MetadataUtil.fmt("%s.%s/%s", MetadataUtil.toUniqueString(field.getDeclaringClass()), field.getName(), MetadataUtil.toUniqueString(field.getType()));
    }

    public static String metadataFileName(String binaryFileName) {
        assert (!binaryFileName.isEmpty());
        assert (!binaryFileName.endsWith(File.pathSeparator));
        return binaryFileName + METADATA_SUFFIX;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="path.getParent() is never null")
    public static Path metadataFilePath(Path binaryFilePath) {
        String binaryFileName = binaryFilePath.getFileName().toString();
        String metadataFileName = MetadataUtil.metadataFileName(binaryFileName);
        return binaryFilePath.resolveSibling(metadataFileName);
    }
}

