/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.BytecodeStream;
import com.oracle.svm.interpreter.metadata.InterpreterConstantPool;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterUnresolvedSignature;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class InterpreterResolvedJavaMethod
implements ResolvedJavaMethod {
    public static final LocalVariableTable EMPTY_LOCAL_VARIABLE_TABLE = new LocalVariableTable(new Local[0]);
    public static final int UNKNOWN_METHOD_ID = 0;
    private byte[] interpretedCode;
    private final String name;
    private final int maxLocals;
    private final int maxStackSize;
    private final int modifiers;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ResolvedJavaMethod originalMethod;
    private final InterpreterResolvedObjectType declaringClass;
    private final InterpreterUnresolvedSignature signature;
    private final LineNumberTable lineNumberTable;
    private ExceptionHandler[] exceptionHandlers;
    private LocalVariableTable localVariableTable;
    private ReferenceConstant<FunctionPointerHolder> nativeEntryPoint;
    private volatile Object interpreterExecToken;
    protected InlinedBy inlinedBy;
    public static final int VTBL_NO_ENTRY = -1;
    public static final int VTBL_ONE_IMPL = -2;
    private int vtableIndex = -1;
    private InterpreterResolvedJavaMethod oneImplementation;
    private int gotOffset;
    public static final int EST_NO_ENTRY = -5;
    private int enterStubOffset = -5;
    private int methodId;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean needMethodBody;
    private volatile byte[] originalCode;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private InterpreterResolvedJavaMethod(ResolvedJavaMethod originalMethod, String name, int maxLocals, int maxStackSize, int modifiers, InterpreterResolvedObjectType declaringClass, InterpreterUnresolvedSignature signature, byte[] code, ExceptionHandler[] exceptionHandlers, LineNumberTable lineNumberTable, LocalVariableTable localVariableTable, ReferenceConstant<FunctionPointerHolder> nativeEntryPoint, int vtableIndex, int gotOffset, int enterStubOffset, int methodId) {
        this(name, maxLocals, maxStackSize, modifiers, declaringClass, signature, code, exceptionHandlers, lineNumberTable, localVariableTable, nativeEntryPoint, vtableIndex, gotOffset, enterStubOffset, methodId);
        this.originalMethod = originalMethod;
        this.needMethodBody = false;
        this.inlinedBy = new InlinedBy(this, new HashSet<InterpreterResolvedJavaMethod>());
    }

    private InterpreterResolvedJavaMethod(String name, int maxLocals, int maxStackSize, int modifiers, InterpreterResolvedObjectType declaringClass, InterpreterUnresolvedSignature signature, byte[] code, ExceptionHandler[] exceptionHandlers, LineNumberTable lineNumberTable, LocalVariableTable localVariableTable, ReferenceConstant<FunctionPointerHolder> nativeEntryPoint, int vtableIndex, int gotOffset, int enterStubOffset, int methodId) {
        this.name = name;
        this.maxLocals = maxLocals;
        this.maxStackSize = maxStackSize;
        this.modifiers = modifiers;
        this.declaringClass = declaringClass;
        this.signature = signature;
        this.interpretedCode = code;
        this.exceptionHandlers = exceptionHandlers;
        this.lineNumberTable = lineNumberTable;
        this.localVariableTable = localVariableTable;
        this.nativeEntryPoint = nativeEntryPoint;
        this.vtableIndex = vtableIndex;
        this.gotOffset = gotOffset;
        this.enterStubOffset = enterStubOffset;
        this.methodId = methodId;
        this.inlinedBy = new InlinedBy(this, new HashSet<InterpreterResolvedJavaMethod>());
    }

    public static InterpreterResolvedJavaMethod create(String name, int maxLocals, int maxStackSize, int modifiers, InterpreterResolvedObjectType declaringClass, InterpreterUnresolvedSignature signature, byte[] code, ExceptionHandler[] exceptionHandlers, LineNumberTable lineNumberTable, LocalVariableTable localVariableTable, ReferenceConstant<FunctionPointerHolder> nativeEntryPoint, int vtableIndex, int gotOffset, int enterStubOffset, int methodId) {
        return new InterpreterResolvedJavaMethod(name, maxLocals, maxStackSize, modifiers, declaringClass, signature, code, exceptionHandlers, lineNumberTable, localVariableTable, nativeEntryPoint, vtableIndex, gotOffset, enterStubOffset, methodId);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static InterpreterResolvedJavaMethod create(ResolvedJavaMethod originalMethod, String name, int maxLocals, int maxStackSize, int modifiers, InterpreterResolvedObjectType declaringClass, InterpreterUnresolvedSignature signature, byte[] code, ExceptionHandler[] exceptionHandlers, LineNumberTable lineNumberTable, LocalVariableTable localVariableTable, ReferenceConstant<FunctionPointerHolder> nativeEntryPoint, int vtableIndex, int gotOffset, int enterStubOffset, int methodId) {
        return new InterpreterResolvedJavaMethod(originalMethod, name, maxLocals, maxStackSize, modifiers, declaringClass, signature, code, exceptionHandlers, lineNumberTable, localVariableTable, nativeEntryPoint, vtableIndex, gotOffset, enterStubOffset, methodId);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean needsMethodBody() {
        return this.needMethodBody;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ResolvedJavaMethod getOriginalMethod() {
        return this.originalMethod;
    }

    public byte[] getInterpretedCode() {
        return this.interpretedCode;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setCode(byte[] code) {
        VMError.guarantee(this.originalCode == null);
        this.interpretedCode = code;
    }

    public int getOriginalOpcodeAt(int bci) {
        return this.getCode()[bci] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCode() {
        if (this.interpretedCode == null) {
            return null;
        }
        byte[] result = this.originalCode;
        if (result == null) {
            InterpreterResolvedJavaMethod interpreterResolvedJavaMethod = this;
            synchronized (interpreterResolvedJavaMethod) {
                result = this.originalCode;
                if (result == null) {
                    this.originalCode = result = (byte[])this.getInterpretedCode().clone();
                    InterpreterResolvedJavaMethod.verifySanitizedCode(result);
                }
            }
        }
        return result;
    }

    private static void verifySanitizedCode(byte[] code) {
        int bci = 0;
        while (bci < BytecodeStream.endBCI(code)) {
            int currentBC = BytecodeStream.currentBC(code, bci);
            VMError.guarantee(202 != currentBC);
            bci = BytecodeStream.nextBCI(code, bci);
        }
    }

    public int getCodeSize() {
        if (this.interpretedCode == null) {
            return 0;
        }
        return this.interpretedCode.length;
    }

    public String getName() {
        return this.name;
    }

    public InterpreterResolvedObjectType getDeclaringClass() {
        return this.declaringClass;
    }

    public InterpreterUnresolvedSignature getSignature() {
        return this.signature;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public boolean isDeclared() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isClassInitializer() {
        return "<clinit>".equals(this.getName()) && this.isStatic();
    }

    public boolean isConstructor() {
        return "<init>".equals(this.getName()) && !this.isStatic();
    }

    public ExceptionHandler[] getExceptionHandlers() {
        ExceptionHandler[] result = this.exceptionHandlers;
        VMError.guarantee(result != null);
        return result;
    }

    public InterpreterConstantPool getConstantPool() {
        return this.declaringClass.getConstantPool();
    }

    public LineNumberTable getLineNumberTable() {
        return this.lineNumberTable;
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.localVariableTable;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        return "InterpreterResolvedJavaMethod<holder=" + this.getDeclaringClass().getName() + " name=" + this.getName() + " descriptor=" + this.getSignature().toMethodDescriptor() + ">";
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setExceptionHandlers(ExceptionHandler[] exceptionHandlers) {
        this.exceptionHandlers = MetadataUtil.requireNonNull(exceptionHandlers);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setLocalVariableTable(LocalVariableTable localVariableTable) {
        this.localVariableTable = MetadataUtil.requireNonNull(localVariableTable);
    }

    private void patchOpcode(int bci, int newOpcode) {
        BytecodeStream.patchOpcodeOpaque(this.interpretedCode, bci, newOpcode);
    }

    public void ensureCanSetBreakpointAt(int bci) {
        if (!this.hasBytecodes()) {
            throw new IllegalArgumentException("Cannot set breakpoint: method " + this.name + " doesn't have bytecodes");
        }
        if (bci < 0 || this.getCodeSize() <= bci) {
            throw new IllegalArgumentException("Cannot set breakpoint: BCI out of bounds");
        }
        if (!InterpreterResolvedJavaMethod.isValidBCI(this.getCode(), bci)) {
            throw new IllegalArgumentException("Cannot set breakpoint: targetBCI is not a valid first opcode");
        }
    }

    public void toggleBreakpoint(int bci, boolean enabled) {
        this.ensureCanSetBreakpointAt(bci);
        if (enabled) {
            this.patchOpcode(bci, 202);
        } else {
            int originalOpcode = this.getOriginalOpcodeAt(bci);
            this.patchOpcode(bci, originalOpcode);
        }
    }

    public static boolean isValidBCI(byte[] code, int targetBCI) {
        int bci = 0;
        while (bci < BytecodeStream.endBCI(code)) {
            if (bci == targetBCI) {
                return true;
            }
            bci = BytecodeStream.nextBCI(code, bci);
        }
        return false;
    }

    public int getMethodId() {
        return this.methodId;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setMethodId(int methodId) {
        assert (methodId >= 0);
        this.methodId = methodId;
    }

    public void setGOTOffset(int gotOffset) {
        this.gotOffset = gotOffset;
    }

    public int getGotOffset() {
        return this.gotOffset;
    }

    public void setEnterStubOffset(int offset) {
        this.enterStubOffset = offset;
    }

    public int getEnterStubOffset() {
        return this.enterStubOffset;
    }

    public boolean hasNativeEntryPoint() {
        return this.nativeEntryPoint != null;
    }

    public MethodPointer getNativeEntryPoint() {
        if (this.nativeEntryPoint == null) {
            return (MethodPointer)Word.nullPointer();
        }
        return (MethodPointer)this.nativeEntryPoint.getReferent().functionPointer;
    }

    public ReferenceConstant<FunctionPointerHolder> getNativeEntryPointHolderConstant() {
        return this.nativeEntryPoint;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setNativeEntryPoint(MethodPointer nativeEntryPoint) {
        if (this.nativeEntryPoint != null && nativeEntryPoint != null) {
            ResolvedJavaMethod setMethod = ((MethodPointer)this.nativeEntryPoint.getReferent().functionPointer).getMethod();
            VMError.guarantee(setMethod.equals((Object)nativeEntryPoint.getMethod()));
            return;
        }
        this.nativeEntryPoint = nativeEntryPoint == null ? null : ReferenceConstant.createFromNonNullReference(new FunctionPointerHolder(nativeEntryPoint));
    }

    public int getVTableIndex() {
        return this.vtableIndex;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setVTableIndex(int vtableIndex) {
        VMError.guarantee(vtableIndex == -1 || !this.isStatic() && !this.isConstructor());
        if (vtableIndex >= 0) {
            VMError.guarantee(!this.isFinal());
        }
        this.vtableIndex = vtableIndex;
    }

    public boolean hasVTableIndex() {
        return this.vtableIndex != -1 && this.vtableIndex != -2;
    }

    public void setOneImplementation(InterpreterResolvedJavaMethod oneImplementation) {
        this.oneImplementation = oneImplementation;
    }

    public InterpreterResolvedJavaMethod getOneImplementation() {
        VMError.guarantee(this.vtableIndex != -2 || this.oneImplementation != null);
        return this.oneImplementation;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InterpreterResolvedJavaMethod)) {
            return false;
        }
        InterpreterResolvedJavaMethod that = (InterpreterResolvedJavaMethod)other;
        return this.name.equals(that.name) && this.declaringClass.equals(that.declaringClass) && this.signature.equals(that.signature);
    }

    public int hashCode() {
        int result = MetadataUtil.hashCode(this.name);
        result = 31 * result + MetadataUtil.hashCode(this.declaringClass);
        result = 31 * result + MetadataUtil.hashCode(this.signature);
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isInterpreterExecutable() {
        return this.hasBytecodes();
    }

    public Set<InterpreterResolvedJavaMethod> getInlinedBy() {
        return this.inlinedBy.inliners;
    }

    public void addInliner(InterpreterResolvedJavaMethod inliner) {
        this.inlinedBy.inliners.add(inliner);
    }

    public Object getInterpreterExecToken() {
        return this.interpreterExecToken;
    }

    public void setInterpreterExecToken(Object interpreterExecToken) {
        this.interpreterExecToken = interpreterExecToken;
    }

    public Annotation[][] getParameterAnnotations() {
        throw VMError.intentionallyUnimplemented();
    }

    public Type[] getGenericParameterTypes() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean canBeInlined() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean hasNeverInlineDirective() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean shouldBeInlined() {
        throw VMError.intentionallyUnimplemented();
    }

    public Constant getEncoding() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw VMError.intentionallyUnimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.intentionallyUnimplemented();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw VMError.intentionallyUnimplemented();
    }

    public Annotation[] getAnnotations() {
        throw VMError.intentionallyUnimplemented();
    }

    public Annotation[] getDeclaredAnnotations() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isSynthetic() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isVarArgs() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isBridge() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isDefault() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean canBeStaticallyBound() {
        throw VMError.intentionallyUnimplemented();
    }

    public StackTraceElement asStackTraceElement(int bci) {
        throw VMError.intentionallyUnimplemented();
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw VMError.intentionallyUnimplemented();
    }

    public void reprofile() {
        throw VMError.intentionallyUnimplemented();
    }

    public static class InlinedBy {
        public InterpreterResolvedJavaMethod holder;
        public Set<InterpreterResolvedJavaMethod> inliners;

        public InlinedBy(InterpreterResolvedJavaMethod holder, Set<InterpreterResolvedJavaMethod> inliners) {
            this.holder = holder;
            this.inliners = inliners;
        }
    }
}

