/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.debug;

import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public interface Location {
    public static final int LINENUMBER_MARKER = -2;

    public JavaMethod method();

    public int bci();

    public int lineNumber();

    public static Location create(ResolvedJavaMethod method, int bci) {
        return Location.create(method, bci, -2);
    }

    public static Location create(final ResolvedJavaMethod method, final int bci, final int lineNo) {
        return new Location(){
            private int lineNumber;
            {
                this.lineNumber = lineNo;
            }

            @Override
            public JavaMethod method() {
                return method;
            }

            @Override
            public int bci() {
                return bci;
            }

            @Override
            public int lineNumber() {
                if (this.lineNumber != -2) {
                    return this.lineNumber;
                }
                LineNumberTable lineNumberTable = method.getLineNumberTable();
                this.lineNumber = lineNumberTable != null ? lineNumberTable.getLineNumber(bci) : -1;
                return this.lineNumber;
            }
        };
    }

    public static int getLineNumber(ResolvedJavaMethod method, int bci) {
        if (method.isNative()) {
            return -1;
        }
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        if (lineNumberTable != null) {
            return lineNumberTable.getLineNumber(bci);
        }
        return -1;
    }
}

