/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.hub.CremaSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.hosted.substitute.DeletedElementException;
import com.oracle.svm.interpreter.BuildTimeInterpreterUniverse;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class CremaSupportImpl
implements CremaSupport {
    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ResolvedJavaType createInterpreterType(DynamicHub hub, ResolvedJavaType type) {
        BuildTimeInterpreterUniverse btiUniverse = BuildTimeInterpreterUniverse.singleton();
        AnalysisType analysisType = (AnalysisType)type;
        AnalysisUniverse analysisUniverse = analysisType.getUniverse();
        InterpreterResolvedJavaType interpreterType = btiUniverse.getOrCreateType((ResolvedJavaType)analysisType);
        ResolvedJavaMethod[] declaredMethods = interpreterType.getDeclaredMethods();
        assert (declaredMethods == null || declaredMethods == InterpreterResolvedJavaType.NO_METHODS) : "should only be set once";
        if (analysisType.isPrimitive()) {
            return interpreterType;
        }
        ArrayList<InterpreterResolvedJavaMethod> methods = new ArrayList<InterpreterResolvedJavaMethod>();
        for (ResolvedJavaMethod wrappedMethod : analysisType.getWrapped().getDeclaredMethods(false)) {
            AnalysisMethod analysisMethod;
            if (!analysisUniverse.hostVM().platformSupported((AnnotatedElement)wrappedMethod)) continue;
            try {
                analysisMethod = analysisUniverse.lookup((JavaMethod)wrappedMethod);
            }
            catch (DeletedElementException e) {
                continue;
            }
            InterpreterResolvedJavaMethod method = btiUniverse.getOrCreateMethod((ResolvedJavaMethod)analysisMethod);
            method.setNativeEntryPoint(new MethodPointer((ResolvedJavaMethod)analysisMethod));
            methods.add(method);
        }
        ((InterpreterResolvedObjectType)interpreterType).setDeclaredMethods(methods.toArray(new InterpreterResolvedJavaMethod[0]));
        return interpreterType;
    }
}

