/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.amd64.AMD64InterpreterStubs;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.interpreter.InterpreterStubSection;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import java.util.Collection;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class AMD64InterpreterStubSection
extends InterpreterStubSection {
    private int resolverPatchOffset;
    private int resolverKindAddend;
    private ObjectFile.RelocationKind resolverPatchRelocationKind = null;

    public AMD64InterpreterStubSection() {
        this.target = ConfigurationValues.getTarget();
        this.registerConfig = new SubstrateAMD64RegisterConfig(SubstrateRegisterConfig.ConfigKind.NATIVE_TO_JAVA, null, this.target, true);
        this.valueKindFactory = javaKind -> LIRKind.fromJavaKind((Architecture)this.target.arch, (JavaKind)javaKind);
    }

    @Override
    protected byte[] generateEnterStubs(Collection<InterpreterResolvedJavaMethod> methods) {
        AMD64MacroAssembler masm = new AMD64MacroAssembler((TargetDescription)this.target);
        if (SubstrateControlFlowIntegrity.enabled()) {
            VMError.unimplemented("GR-63035: Add CFI support for interpreter stubs");
        }
        Label interpEnterStub = new Label();
        masm.bind(interpEnterStub);
        masm.setCodePatchingAnnotationConsumer(this::recordEnterStubForPatching);
        masm.jmp();
        for (InterpreterResolvedJavaMethod method : methods) {
            VMError.guarantee(method.getEnterStubOffset() != -5);
            InterpreterUtil.log("[svm_interp] Adding stub for %s", method);
            this.recordEnterTrampoline(method, masm.position());
            masm.movq(AMD64InterpreterStubs.TRAMPOLINE_ARGUMENT, (long)method.getEnterStubOffset());
            masm.jmp(interpEnterStub);
        }
        return masm.close(true);
    }

    @Override
    public int getVTableStubSize() {
        int branchTargetAlignment = ConfigurationValues.getTarget().wordSize * 2;
        int stubSize = 10;
        return NumUtil.roundUp((int)stubSize, (int)branchTargetAlignment);
    }

    @Override
    protected byte[] generateVTableEnterStubs(int maxVTableIndex) {
        AMD64MacroAssembler masm = new AMD64MacroAssembler((TargetDescription)this.target);
        if (SubstrateControlFlowIntegrity.enabled()) {
            VMError.unimplemented("GR-63035: Add CFI support for interpreter stubs");
        }
        Label interpEnterStub = new Label();
        masm.bind(interpEnterStub);
        masm.setCodePatchingAnnotationConsumer(this::recordEnterStubForPatching);
        masm.jmp();
        masm.align(this.getVTableStubSize());
        this.recordVTableStubBaseOffset(masm.position());
        for (int vTableIndex = 0; vTableIndex < maxVTableIndex; ++vTableIndex) {
            int expectedStubEnd = masm.position() + this.getVTableStubSize();
            masm.moveInt(AMD64InterpreterStubs.TRAMPOLINE_ARGUMENT, vTableIndex);
            masm.jmp(interpEnterStub);
            masm.align(this.getVTableStubSize());
            assert (masm.position() == expectedStubEnd);
        }
        return masm.close(true);
    }

    private void recordEnterStubForPatching(Assembler.CodeAnnotation a) {
        if (this.resolverPatchRelocationKind != null) {
            return;
        }
        assert (a instanceof AMD64BaseAssembler.OperandDataAnnotation);
        AMD64BaseAssembler.OperandDataAnnotation annotation = (AMD64BaseAssembler.OperandDataAnnotation)a;
        this.resolverPatchOffset = annotation.operandPosition;
        this.resolverKindAddend = -annotation.operandSize;
        this.resolverPatchRelocationKind = ObjectFile.RelocationKind.getPCRelative((int)annotation.operandSize);
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void markEnterStubPatch(ObjectFile.ProgbitsSectionImpl pltBuffer, ResolvedJavaMethod enterStub) {
        pltBuffer.markRelocationSite(this.resolverPatchOffset, this.resolverPatchRelocationKind, NativeImage.localSymbolNameForMethod(enterStub), (long)this.resolverKindAddend);
    }
}

