/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.option;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.SubstrateOptionKey;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.option.HostedOptionParser;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class BuildTimeOptionValidationFeature
implements InternalFeature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl a = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        HostedOptionParser optionParser = a.getImageClassLoader().classLoaderSupport.getHostedOptionParser();
        MapCursor cursor = optionParser.getAllHostedOptions().getEntries();
        while (cursor.advance()) {
            BuildTimeOptionValidationFeature.validate((OptionDescriptor)cursor.getValue());
        }
        cursor = optionParser.getAllRuntimeOptions().getEntries();
        while (cursor.advance()) {
            BuildTimeOptionValidationFeature.validate((OptionDescriptor)cursor.getValue());
        }
    }

    private static void validate(OptionDescriptor desc) {
        OptionKey optionKey = desc.getOptionKey();
        if (optionKey instanceof SubstrateOptionKey) {
            SubstrateOptionKey option = (SubstrateOptionKey)optionKey;
            option.validate();
        }
    }
}

