/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.graal.code.CGlobalDataBasePointer;
import com.oracle.svm.core.meta.MethodOffset;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.core.common.spi.JavaConstantFieldProvider;
import jdk.internal.vm.annotation.Stable;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public abstract class SharedConstantFieldProvider
extends JavaConstantFieldProvider {
    protected final UniverseMetaAccess metaAccess;
    protected final SVMHost hostVM;
    protected final FieldValueInterceptionSupport fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();

    public SharedConstantFieldProvider(MetaAccessProvider metaAccess, SVMHost hostVM) {
        super(metaAccess);
        this.metaAccess = (UniverseMetaAccess)metaAccess;
        this.hostVM = hostVM;
    }

    protected abstract AnalysisField asAnalysisField(ResolvedJavaField var1);

    public boolean isFinalField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        return super.isFinalField(field, tool) && this.allowConstantFolding(field, tool);
    }

    public boolean isStableField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        boolean stable = field.isAnnotationPresent(Stable.class) ? true : super.isStableField(field, tool);
        return stable && this.allowConstantFolding(field, tool);
    }

    private boolean allowConstantFolding(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        ImageHeapConstant receiver;
        JavaConstant javaConstant;
        AnalysisField aField = this.asAnalysisField(field);
        if (aField.preventConstantFolding()) {
            return false;
        }
        if (!(field.isStatic() || (javaConstant = tool.getReceiver()) instanceof ImageHeapConstant && (receiver = (ImageHeapConstant)javaConstant).allowConstantFolding())) {
            return false;
        }
        if (!this.fieldValueInterceptionSupport.isValueAvailable(aField)) {
            return false;
        }
        if (field.isStatic() && !this.isClassInitialized(field) && !this.fieldValueInterceptionSupport.hasFieldValueTransformer(aField)) {
            return false;
        }
        return this.hostVM.allowConstantFolding(field);
    }

    protected boolean isClassInitialized(ResolvedJavaField field) {
        return field.getDeclaringClass().isInitialized();
    }

    protected boolean isFinalFieldValueConstant(ResolvedJavaField field, JavaConstant value, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (value.getJavaKind() == JavaKind.Object && (this.metaAccess.isInstanceOf(value, MethodPointer.class) || this.metaAccess.isInstanceOf(value, MethodOffset.class) || this.metaAccess.isInstanceOf(value, CGlobalDataBasePointer.class))) {
            return false;
        }
        return super.isFinalFieldValueConstant(field, value, tool);
    }
}

