/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.config.DynamicHubLayout;
import com.oracle.svm.hosted.thread.VMThreadFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
public final class KnownOffsetsFeature
implements InternalFeature,
FeatureSingleton,
UnsavedSingleton {
    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(VMThreadFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(KnownOffsets.class, (Object)new KnownOffsets());
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        DynamicHubLayout dynamicHubLayout = DynamicHubLayout.singleton();
        int vtableBaseOffset = dynamicHubLayout.vTableOffset();
        int vtableEntrySize = dynamicHubLayout.vTableSlotSize;
        int typeIDSlotsOffset = SubstrateOptions.useClosedTypeWorldHubLayout() ? dynamicHubLayout.getClosedTypeWorldTypeCheckSlotsOffset() : -1;
        int javaFrameAnchorLastSPOffset = KnownOffsetsFeature.findStructOffset(access, JavaFrameAnchor.class, "getLastJavaSP");
        int javaFrameAnchorLastIPOffset = KnownOffsetsFeature.findStructOffset(access, JavaFrameAnchor.class, "getLastJavaIP");
        int vmThreadStatusOffset = ((VMThreadFeature)ImageSingletons.lookup(VMThreadFeature.class)).offsetOf(VMThreads.StatusSupport.statusTL);
        int imageCodeInfoCodeStartOffset = KnownOffsetsFeature.findFieldOffset(access, ImageCodeInfo.class, "codeStart");
        KnownOffsets.singleton().setLazyState(vtableBaseOffset, vtableEntrySize, typeIDSlotsOffset, javaFrameAnchorLastSPOffset, javaFrameAnchorLastIPOffset, vmThreadStatusOffset, imageCodeInfoCodeStartOffset);
    }

    private static int findFieldOffset(FeatureImpl.BeforeCompilationAccessImpl access, Class<?> clazz, String fieldName) {
        return access.getMetaAccess().lookupJavaField(ReflectionUtil.lookupField(clazz, (String)fieldName)).getLocation();
    }

    private static int findStructOffset(FeatureImpl.BeforeCompilationAccessImpl access, Class<?> clazz, String accessorName) {
        Method method = ReflectionUtil.lookupPublicMethodInClassHierarchy(clazz, (String)accessorName, (Class[])new Class[0]);
        AccessorInfo accessorInfo = (AccessorInfo)access.getNativeLibraries().findElementInfo(access.getMetaAccess().lookupJavaMethod(method));
        StructFieldInfo structFieldInfo = (StructFieldInfo)accessorInfo.getParent();
        return structFieldInfo.getOffsetInfo().getProperty();
    }
}

