/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.imagelayer.HostedDynamicLayerInfo;
import com.oracle.svm.util.LogUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class HostedMethodNameFactory
implements InternalFeature {
    private Map<String, Integer> methodNameCount = new ConcurrentHashMap<String, Integer>();
    private Set<String> uniqueShortNames = ConcurrentHashMap.newKeySet();
    private final boolean buildingExtensionLayer = ImageLayerBuildingSupport.buildingExtensionLayer();
    private final boolean logUniqueNameInconsistencies = Options.LogUniqueNameInconsistencies.getValue();
    private Set<String> reservedUniqueShortNames;

    public static HostedMethodNameFactory singleton() {
        return (HostedMethodNameFactory)ImageSingletons.lookup(HostedMethodNameFactory.class);
    }

    MethodNameInfo createNames(NameGenerator generator, AnalysisMethod aMethod) {
        MethodNameInfo initialName;
        MethodNameInfo result;
        MethodNameInfo methodNameInfo = result = this.buildingExtensionLayer ? HostedDynamicLayerInfo.loadMethodNameInfo(aMethod) : null;
        if (result != null) {
            boolean added;
            boolean consistentNames;
            assert (this.reservedUniqueShortNames.contains(result.uniqueShortName())) : result;
            if (this.logUniqueNameInconsistencies && !(consistentNames = generator.generateUniqueName(result.name()).equals(result.uniqueShortName))) {
                LogUtils.warning((String)"Unique names are inconsistent for %s", (Object[])new Object[]{aMethod.getQualifiedName()});
            }
            if (added = this.uniqueShortNames.add(result.uniqueShortName())) {
                return result;
            }
        }
        result = initialName = generator.generateMethodNameInfo(0);
        do {
            int collisionCount;
            if ((collisionCount = this.methodNameCount.merge(initialName.uniqueShortName(), 0, (oldValue, value) -> oldValue + 1).intValue()) == 0) continue;
            result = generator.generateMethodNameInfo(collisionCount);
        } while (this.buildingExtensionLayer && this.reservedUniqueShortNames.contains(result.uniqueShortName()));
        boolean added = this.uniqueShortNames.add(result.uniqueShortName());
        VMError.guarantee(added, "failed to generate uniqueShortName for HostedMethod: %s", result.uniqueShortName());
        return result;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.reservedUniqueShortNames = this.buildingExtensionLayer ? HostedDynamicLayerInfo.singleton().getReservedNames() : null;
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        this.methodNameCount = null;
        this.uniqueShortNames = null;
        this.reservedUniqueShortNames = null;
    }

    public static final class Options {
        public static final HostedOptionKey<Boolean> LogUniqueNameInconsistencies = new HostedOptionKey<Boolean>(false);
    }

    public record MethodNameInfo(String name, String uniqueShortName) {
    }

    public static interface NameGenerator {
        public MethodNameInfo generateMethodNameInfo(int var1);

        public String generateUniqueName(String var1);
    }
}

