/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.ImageLayerWriter;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.graal.code.CGlobalDataBasePointer;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.InitialLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.RuntimeOnlyWrapper;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import com.oracle.svm.hosted.annotation.CustomSubstitutionType;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CEntryPointCallStubMethod;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.FactoryMethod;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.imagelayer.CrossLayerConstantRegistryFeature;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.LayeredDispatchTableFeature;
import com.oracle.svm.hosted.imagelayer.LayeredStaticFieldSupport;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSnapshotUtil;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.hosted.jni.JNIJavaCallVariantWrapperMethod;
import com.oracle.svm.hosted.lambda.LambdaSubstitutionType;
import com.oracle.svm.hosted.lambda.StableLambdaProxyNameFeature;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.PatchedWordConstant;
import com.oracle.svm.hosted.methodhandles.MethodHandleFeature;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerSubstitutionType;
import com.oracle.svm.hosted.reflect.ReflectionExpandSignatureMethod;
import com.oracle.svm.hosted.reflect.proxy.ProxyRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.reflect.proxy.ProxySubstitutionType;
import com.oracle.svm.hosted.substitute.PolymorphicSignatureWrapperMethod;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.shaded.org.capnproto.FromPointerBuilder;
import com.oracle.svm.shaded.org.capnproto.ListBuilder;
import com.oracle.svm.shaded.org.capnproto.MessageBuilder;
import com.oracle.svm.shaded.org.capnproto.PrimitiveList;
import com.oracle.svm.shaded.org.capnproto.Serialize;
import com.oracle.svm.shaded.org.capnproto.StructBuilder;
import com.oracle.svm.shaded.org.capnproto.StructList;
import com.oracle.svm.shaded.org.capnproto.Text;
import com.oracle.svm.shaded.org.capnproto.TextList;
import com.oracle.svm.shaded.org.capnproto.Void;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.NodeClassMap;
import jdk.graal.compiler.nodes.spi.IdentityHashCodeProvider;
import jdk.graal.compiler.util.ObjectCopier;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.CEntryPointLiteralCodePointer;
import org.graalvm.word.WordBase;
import sun.reflect.annotation.AnnotationType;

public class SVMImageLayerWriter
extends ImageLayerWriter {
    private final SVMImageLayerSnapshotUtil imageLayerSnapshotUtil;
    private ImageHeap imageHeap;
    private AnalysisUniverse aUniverse;
    private IdentityHashMap<String, String> internedStringsIdentityMap;
    private final MessageBuilder snapshotFileBuilder = new MessageBuilder();
    private final SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Builder snapshotBuilder = (SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Builder)((Object)this.snapshotFileBuilder.initRoot((FromPointerBuilder)SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.factory));
    private Map<ImageHeapConstant, ConstantParent> constantsMap;
    private final Map<String, MethodGraphsInfo> methodsMap = new ConcurrentHashMap<String, MethodGraphsInfo>();
    private final Map<InitialLayerOnlyImageSingleton, Integer> initialLayerOnlySingletonMap = new ConcurrentHashMap<InitialLayerOnlyImageSingleton, Integer>();
    private final Map<AnalysisMethod, Set<AnalysisMethod>> polymorphicSignatureCallers = new ConcurrentHashMap<AnalysisMethod, Set<AnalysisMethod>>();
    private final GraphsOutput graphsOutput;
    private final boolean useSharedLayerGraphs;
    private final boolean useSharedLayerStrengthenedGraphs;
    private NativeImageHeap nativeImageHeap;
    private HostedUniverse hUniverse;
    private final ClassInitializationSupport classInitializationSupport;
    private boolean polymorphicSignatureSealed = false;
    private final NodeClassMap nodeClassMap = GraphEncoder.GLOBAL_NODE_CLASS_MAP;

    public SVMImageLayerWriter(SVMImageLayerSnapshotUtil imageLayerSnapshotUtil, boolean useSharedLayerGraphs, boolean useSharedLayerStrengthenedGraphs) {
        this.imageLayerSnapshotUtil = imageLayerSnapshotUtil;
        this.useSharedLayerGraphs = useSharedLayerGraphs;
        this.useSharedLayerStrengthenedGraphs = useSharedLayerStrengthenedGraphs;
        this.graphsOutput = new GraphsOutput();
        this.classInitializationSupport = ClassInitializationSupport.singleton();
    }

    public void setInternedStringsIdentityMap(IdentityHashMap<String, String> map) {
        this.internedStringsIdentityMap = map;
    }

    public void setImageHeap(ImageHeap heap) {
        this.imageHeap = heap;
    }

    public void setAnalysisUniverse(AnalysisUniverse aUniverse) {
        this.aUniverse = aUniverse;
    }

    public void setNativeImageHeap(NativeImageHeap nativeImageHeap) {
        this.nativeImageHeap = nativeImageHeap;
    }

    public void setHostedUniverse(HostedUniverse hUniverse) {
        this.hUniverse = hUniverse;
    }

    public void dumpFiles() {
        SVMImageLayerSnapshotUtil.SVMGraphEncoder graphEncoder = this.imageLayerSnapshotUtil.getGraphEncoder(null);
        byte[] encodedNodeClassMap = ObjectCopier.encode((ObjectCopier.Encoder)graphEncoder, (Object)this.nodeClassMap);
        String location = this.graphsOutput.add(encodedNodeClassMap);
        this.snapshotBuilder.setNodeClassMapLocation(location);
        this.graphsOutput.finish();
        Path snapshotFile = HostedImageLayerBuildingSupport.singleton().getWriteLayerArchiveSupport().getSnapshotPath();
        try (FileOutputStream outputStream = new FileOutputStream(snapshotFile.toFile());){
            Serialize.write((WritableByteChannel)Channels.newChannel(outputStream), (MessageBuilder)this.snapshotFileBuilder);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Unable to write " + String.valueOf(snapshotFile), e);
        }
    }

    public void initializeExternalValues() {
        this.imageLayerSnapshotUtil.initializeExternalValues();
    }

    public void setImageHeapSize(long imageHeapSize) {
        this.snapshotBuilder.setImageHeapSize(imageHeapSize);
    }

    public void onTrackedAcrossLayer(AnalysisMethod method, Object reason) {
        ResolvedJavaMethod resolvedJavaMethod = method.wrapped;
        if (resolvedJavaMethod instanceof FactoryMethod) {
            FactoryMethod factoryMethod = (FactoryMethod)resolvedJavaMethod;
            AnalysisMethod targetConstructor = method.getUniverse().lookup((JavaMethod)factoryMethod.getTargetConstructor());
            targetConstructor.registerAsTrackedAcrossLayers(reason);
        }
    }

    public void persistAnalysisInfo() {
        ImageHeapConstant staticPrimitiveFields = (ImageHeapConstant)this.hUniverse.getSnippetReflection().forObject(StaticFieldsSupport.getCurrentLayerStaticPrimitiveFields());
        ImageHeapConstant staticObjectFields = (ImageHeapConstant)this.hUniverse.getSnippetReflection().forObject(StaticFieldsSupport.getCurrentLayerStaticObjectFields());
        this.snapshotBuilder.setStaticPrimitiveFieldsConstantId(ImageHeapConstant.getConstantID((ImageHeapConstant)staticPrimitiveFields));
        this.snapshotBuilder.setStaticObjectFieldsConstantId(ImageHeapConstant.getConstantID((ImageHeapConstant)staticObjectFields));
        ArrayList constantsToScan = new ArrayList();
        this.imageHeap.getReachableObjects().values().forEach(constantsToScan::addAll);
        this.constantsMap = HashMap.newHashMap(constantsToScan.size());
        constantsToScan.forEach(c -> this.constantsMap.put((ImageHeapConstant)c, ConstantParent.NONE));
        while (!constantsToScan.isEmpty()) {
            ArrayList discoveredConstants = new ArrayList();
            constantsToScan.forEach(con -> this.scanConstantReferencedObjects((ImageHeapConstant)con, discoveredConstants));
            constantsToScan = discoveredConstants;
        }
        this.snapshotBuilder.setNextTypeId(this.aUniverse.getNextTypeId());
        this.snapshotBuilder.setNextMethodId(this.aUniverse.getNextMethodId());
        this.snapshotBuilder.setNextFieldId(this.aUniverse.getNextFieldId());
        this.snapshotBuilder.setNextConstantId(ImageHeapConstant.getCurrentId());
        this.polymorphicSignatureSealed = true;
        AnalysisType[] typesToPersist = (AnalysisType[])this.aUniverse.getTypes().stream().filter(AnalysisElement::isTrackedAcrossLayers).sorted(Comparator.comparingInt(AnalysisType::getId)).toArray(AnalysisType[]::new);
        SVMImageLayerWriter.initSortedArray(this.snapshotBuilder::initTypes, typesToPersist, this::persistType);
        LayeredDispatchTableFeature dispatchTableSingleton = LayeredDispatchTableFeature.singleton();
        SVMImageLayerWriter.initSortedArray(this.snapshotBuilder::initDynamicHubInfos, typesToPersist, (aType, builderSupplier) -> dispatchTableSingleton.persistDynamicHubInfo(this.hUniverse.lookup((JavaType)aType), (Supplier<SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Builder>)builderSupplier));
        AnalysisMethod[] methodsToPersist = (AnalysisMethod[])this.aUniverse.getMethods().stream().filter(AnalysisElement::isTrackedAcrossLayers).sorted(Comparator.comparingInt(AnalysisMethod::getId)).toArray(AnalysisMethod[]::new);
        SVMImageLayerWriter.initSortedArray(this.snapshotBuilder::initMethods, methodsToPersist, this::persistMethod);
        AnalysisField[] fieldsToPersist = (AnalysisField[])this.aUniverse.getFields().stream().filter(AnalysisElement::isTrackedAcrossLayers).sorted(Comparator.comparingInt(AnalysisField::getId)).toArray(AnalysisField[]::new);
        SVMImageLayerWriter.initSortedArray(this.snapshotBuilder::initFields, fieldsToPersist, this::persistField);
        HostedMethod[] hMethodsToPersist = dispatchTableSingleton.acquireHostedMethodArray();
        SVMImageLayerWriter.initSortedArray(this.snapshotBuilder::initHostedMethods, hMethodsToPersist, dispatchTableSingleton::persistHostedMethod);
        dispatchTableSingleton.releaseHostedMethodArray();
        Map.Entry[] constantsToPersist = (Map.Entry[])this.constantsMap.entrySet().stream().sorted(Comparator.comparingInt(a -> ImageHeapConstant.getConstantID((ImageHeapConstant)((ImageHeapConstant)a.getKey())))).toArray(Map.Entry[]::new);
        HashSet constantsToRelink = new HashSet();
        SVMImageLayerWriter.initSortedArray(this.snapshotBuilder::initConstants, constantsToPersist, (entry, bsupplier) -> this.persistConstant((ImageHeapConstant)entry.getKey(), (ConstantParent)entry.getValue(), (SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Builder)((Object)((Object)bsupplier.get())), constantsToRelink));
        SVMImageLayerWriter.initInts(this.snapshotBuilder::initConstantsToRelink, constantsToRelink.stream().mapToInt(i -> i).sorted());
    }

    public static void initInts(IntFunction<PrimitiveList.Int.Builder> builderSupplier, IntStream ids) {
        int[] values = ids.toArray();
        PrimitiveList.Int.Builder builder = builderSupplier.apply(values.length);
        for (int i = 0; i < values.length; ++i) {
            builder.set(i, values[i]);
        }
    }

    public static void initStringList(IntFunction<TextList.Builder> builderSupplier, Stream<String> strings) {
        Object[] array = strings.toArray();
        TextList.Builder builder = builderSupplier.apply(array.length);
        for (int i = 0; i < array.length; ++i) {
            builder.set(i, new Text.Reader(array[i].toString()));
        }
    }

    public static <S extends StructBuilder, T> void initSortedArray(IntFunction<StructList.Builder<S>> init, T[] sortedArray, BiConsumer<T, Supplier<S>> action) {
        StructList.Builder<S> builder = init.apply(sortedArray.length);
        Iterator iterator = builder.iterator();
        for (T t : sortedArray) {
            action.accept(t, iterator::next);
        }
        AnalysisError.guarantee((!iterator.hasNext() ? 1 : 0) != 0, (String)"all created struct builders must have been used", (Object[])new Object[0]);
    }

    private void persistType(AnalysisType type, Supplier<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Builder> builderSupplier) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Builder builder = builderSupplier.get();
        HostVM hostVM = this.aUniverse.hostVM();
        SVMHost svmHost = (SVMHost)hostVM;
        DynamicHub hub = svmHost.dynamicHub((ResolvedJavaType)type);
        builder.setHubIdentityHashCode(System.identityHashCode(hub));
        builder.setHasArrayType(hub.getArrayHub() != null);
        ClassInitializationInfo info = hub.getClassInitializationInfo();
        if (info != null) {
            SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.Builder b = builder.initClassInitializationInfo();
            b.setIsNoInitializerNoTracking(info == ClassInitializationInfo.forNoInitializerInfo(false));
            b.setIsInitializedNoTracking(info == ClassInitializationInfo.forInitializedInfo(false));
            b.setIsFailedNoTracking(info == ClassInitializationInfo.forFailedInfo(false));
            b.setIsInitialized(info.isInitialized());
            b.setIsInErrorState(info.isInErrorState());
            b.setIsLinked(info.isLinked());
            b.setHasInitializer(info.hasInitializer());
            b.setIsBuildTimeInitialized(info.isBuildTimeInitialized());
            b.setIsTracked(info.isTracked());
            FunctionPointerHolder classInitializer = info.getClassInitializer();
            if (classInitializer != null) {
                MethodPointer methodPointer = (MethodPointer)classInitializer.functionPointer;
                AnalysisMethod classInitializerMethod = (AnalysisMethod)methodPointer.getMethod();
                b.setInitializerMethodId(classInitializerMethod.getId());
            }
        }
        builder.setId(type.getId());
        builder.setDescriptor(this.imageLayerSnapshotUtil.getTypeDescriptor(type));
        SVMImageLayerWriter.initInts(builder::initFields, Arrays.stream(type.getInstanceFields(true)).mapToInt(f -> ((AnalysisField)f).getId()));
        builder.setClassJavaName(type.toJavaName());
        builder.setClassName(type.getName());
        builder.setModifiers(type.getModifiers());
        builder.setIsInterface(type.isInterface());
        builder.setIsEnum(type.isEnum());
        builder.setIsInitialized(type.isInitialized());
        builder.setIsFailedInitialization(this.classInitializationSupport.isFailedInitialization(type.getJavaClass()));
        builder.setIsLinked(type.isLinked());
        if (type.getSourceFileName() != null) {
            builder.setSourceFileName(type.getSourceFileName());
        }
        try {
            AnalysisType enclosingType = type.getEnclosingType();
            if (enclosingType != null) {
                builder.setEnclosingTypeId(enclosingType.getId());
            }
        }
        catch (InternalError | LinkageError | TypeNotPresentException enclosingType) {
            // empty catch block
        }
        if (type.isArray()) {
            builder.setComponentTypeId(type.getComponentType().getId());
        }
        if (type.getSuperclass() != null) {
            builder.setSuperClassTypeId(type.getSuperclass().getId());
        }
        SVMImageLayerWriter.initInts(builder::initInterfaces, Arrays.stream(type.getInterfaces()).mapToInt(AnalysisType::getId));
        SVMImageLayerWriter.initInts(builder::initInstanceFieldIds, Arrays.stream(type.getInstanceFields(false)).mapToInt(f -> ((AnalysisField)f).getId()));
        SVMImageLayerWriter.initInts(builder::initInstanceFieldIdsWithSuper, Arrays.stream(type.getInstanceFields(true)).mapToInt(f -> ((AnalysisField)f).getId()));
        SVMImageLayerWriter.initInts(builder::initStaticFieldIds, Arrays.stream(type.getStaticFields()).mapToInt(f -> ((AnalysisField)f).getId()));
        this.persistAnnotations((AnnotatedElement)type, builder::initAnnotationList);
        builder.setIsInstantiated(type.isInstantiated());
        builder.setIsUnsafeAllocated(type.isUnsafeAllocated());
        builder.setIsReachable(type.isReachable());
        this.delegatePersistType(type, builder);
        Set subTypes = type.getSubTypes().stream().filter(AnalysisElement::isTrackedAcrossLayers).collect(Collectors.toSet());
        PrimitiveList.Int.Builder subTypesBuilder = builder.initSubTypes(subTypes.size());
        int i = 0;
        for (AnalysisType subType : subTypes) {
            subTypesBuilder.set(i, subType.getId());
            ++i;
        }
        builder.setIsAnySubtypeInstantiated(type.isAnySubtypeInstantiated());
        SVMImageLayerWriter.afterTypeAdded(type);
    }

    protected void delegatePersistType(AnalysisType type, SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Builder builder) {
        if (type.toJavaName(true).contains("jdk.internal.reflect.GeneratedSerializationConstructorAccessor")) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.WrappedType.SerializationGenerated.Builder b = builder.getWrappedType().initSerializationGenerated();
            SerializationSupport.SerializationLookupKey key = SerializationSupport.currentLayer().getKeyFromConstructorAccessorClass(type.getJavaClass());
            b.setRawDeclaringClass(key.getDeclaringClass().getName());
            b.setRawTargetConstructor(key.getTargetConstructorClass().getName());
        } else if (LambdaUtils.isLambdaType((ResolvedJavaType)type)) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.WrappedType.Lambda.Builder b = builder.getWrappedType().initLambda();
            b.setCapturingClass(LambdaUtils.capturingClass((String)type.toJavaName()));
        } else if (ProxyRenamingSubstitutionProcessor.isProxyType((ResolvedJavaType)type)) {
            builder.getWrappedType().setProxyType(Void.VOID);
        }
    }

    private static void afterTypeAdded(AnalysisType type) {
        ProxySubstitutionType proxySubstitutionType;
        Object methodHandleFeature;
        String message;
        Object stableLambdaProxyNameFeature;
        ResolvedJavaType resolvedJavaType = type.getWrapped();
        if (resolvedJavaType instanceof LambdaSubstitutionType) {
            LambdaSubstitutionType lambdaSubstitutionType = (LambdaSubstitutionType)resolvedJavaType;
            stableLambdaProxyNameFeature = (StableLambdaProxyNameFeature)ImageSingletons.lookup(StableLambdaProxyNameFeature.class);
            if (!((StableLambdaProxyNameFeature)stableLambdaProxyNameFeature).getLambdaSubstitutionProcessor().isNameAlwaysStable(lambdaSubstitutionType.getName())) {
                message = "The lambda method " + lambdaSubstitutionType.getName() + " might not have a stable name in the extension image.";
                SVMImageLayerWriter.handleNameConflict(message);
            }
        }
        if ((stableLambdaProxyNameFeature = type.getWrapped()) instanceof MethodHandleInvokerSubstitutionType) {
            MethodHandleInvokerSubstitutionType methodHandleSubstitutionType = (MethodHandleInvokerSubstitutionType)stableLambdaProxyNameFeature;
            methodHandleFeature = (MethodHandleFeature)ImageSingletons.lookup(MethodHandleFeature.class);
            if (!((MethodHandleFeature)methodHandleFeature).getMethodHandleSubstitutionProcessor().isNameAlwaysStable(methodHandleSubstitutionType.getName())) {
                message = "The method handle " + methodHandleSubstitutionType.getName() + " might not have a stable name in the extension image.";
                SVMImageLayerWriter.handleNameConflict(message);
            }
        }
        if ((methodHandleFeature = type.getWrapped()) instanceof ProxySubstitutionType && !ProxyRenamingSubstitutionProcessor.isNameAlwaysStable((proxySubstitutionType = (ProxySubstitutionType)methodHandleFeature).getName())) {
            String message2 = "The Proxy type " + proxySubstitutionType.getName() + " might not have a stable name in the extension image.";
            SVMImageLayerWriter.handleNameConflict(message2);
        }
    }

    private static void handleNameConflict(String message) {
        if (SubstrateOptions.AbortOnNameConflict.getValue().booleanValue()) {
            throw VMError.shouldNotReachHere(message);
        }
        LogUtils.warning((String)message);
    }

    private void persistMethod(AnalysisMethod method, Supplier<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Builder> builderSupplier) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Builder builder = builderSupplier.get();
        MethodGraphsInfo graphsInfo = this.methodsMap.putIfAbsent(this.imageLayerSnapshotUtil.getMethodDescriptor(method), MethodGraphsInfo.NO_GRAPHS);
        Executable executable = method.getJavaMethod();
        if (builder.getId() != 0) {
            throw GraalError.shouldNotReachHere((String)("The method descriptor should be unique, but " + this.imageLayerSnapshotUtil.getMethodDescriptor(method) + " got added twice."));
        }
        if (executable != null) {
            SVMImageLayerWriter.initStringList(builder::initArgumentClassNames, Arrays.stream(executable.getParameterTypes()).map(Class::getName));
            builder.setClassName(executable.getDeclaringClass().getName());
        }
        builder.setDescriptor(this.imageLayerSnapshotUtil.getMethodDescriptor(method));
        builder.setDeclaringTypeId(method.getDeclaringClass().getId());
        SVMImageLayerWriter.initInts(builder::initArgumentTypeIds, method.getSignature().toParameterList(null).stream().mapToInt(AnalysisType::getId));
        builder.setId(method.getId());
        builder.setName(method.getName());
        builder.setReturnTypeId(((AnalysisType)method.getSignature().getReturnType()).getId());
        builder.setIsVarArgs(method.isVarArgs());
        builder.setIsBridge(method.isBridge());
        builder.setCanBeStaticallyBound(method.canBeStaticallyBound());
        builder.setModifiers(method.getModifiers());
        builder.setIsConstructor(method.isConstructor());
        builder.setIsSynthetic(method.isSynthetic());
        byte[] code = method.getCode();
        if (code != null) {
            builder.setBytecode(code);
        }
        builder.setBytecodeSize(method.getCodeSize());
        MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod = this.aUniverse.getBigbang().getConstantReflectionProvider().getMethodHandleAccess().lookupMethodHandleIntrinsic((ResolvedJavaMethod)method);
        if (intrinsicMethod != null) {
            builder.setMethodHandleIntrinsicName(intrinsicMethod.name());
        }
        this.persistAnnotations((AnnotatedElement)method, builder::initAnnotationList);
        builder.setIsVirtualRootMethod(method.isVirtualRootMethod());
        builder.setIsDirectRootMethod(method.isDirectRootMethod());
        builder.setIsInvoked(method.isSimplyInvoked());
        builder.setIsImplementationInvoked(method.isSimplyImplementationInvoked());
        builder.setIsIntrinsicMethod(method.isIntrinsicMethod());
        if (graphsInfo != null && graphsInfo.analysisGraphLocation != null) {
            builder.setAnalysisGraphLocation(graphsInfo.analysisGraphLocation);
            builder.setAnalysisGraphIsIntrinsic(graphsInfo.analysisGraphIsIntrinsic);
        }
        if (graphsInfo != null && graphsInfo.strengthenedGraphLocation != null) {
            builder.setStrengthenedGraphLocation(graphsInfo.strengthenedGraphLocation);
        }
        this.delegatePersistMethod(method, builder);
        HostedMethod hMethod = this.hUniverse.lookup((JavaMethod)method);
        builder.setHostedMethodIndex(LayeredDispatchTableFeature.singleton().getPersistedHostedMethodIndex(hMethod));
    }

    protected void delegatePersistMethod(AnalysisMethod method, SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Builder builder) {
        ResolvedJavaMethod resolvedJavaMethod = method.wrapped;
        if (resolvedJavaMethod instanceof FactoryMethod) {
            FactoryMethod factoryMethod = (FactoryMethod)resolvedJavaMethod;
            b = builder.getWrappedMethod().initFactoryMethod();
            AnalysisMethod targetConstructor = method.getUniverse().lookup((JavaMethod)factoryMethod.getTargetConstructor());
            ((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.FactoryMethod.Builder)((Object)b)).setTargetConstructorId(targetConstructor.getId());
            ((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.FactoryMethod.Builder)((Object)b)).setThrowAllocatedObject(factoryMethod.throwAllocatedObject());
            AnalysisType instantiatedType = method.getUniverse().lookup((JavaType)factoryMethod.getInstantiatedType());
            ((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.FactoryMethod.Builder)((Object)b)).setInstantiatedTypeId(instantiatedType.getId());
        } else {
            b = method.wrapped;
            if (b instanceof CEntryPointCallStubMethod) {
                CEntryPointCallStubMethod cEntryPointCallStubMethod = (CEntryPointCallStubMethod)b;
                b = builder.getWrappedMethod().initCEntryPointCallStub();
                AnalysisMethod originalMethod = CEntryPointCallStubSupport.singleton().getMethodForStub(cEntryPointCallStubMethod);
                ((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.CEntryPointCallStub.Builder)((Object)b)).setOriginalMethodId(originalMethod.getId());
                ((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.CEntryPointCallStub.Builder)((Object)b)).setNotPublished(cEntryPointCallStubMethod.isNotPublished());
            } else {
                b = method.wrapped;
                if (b instanceof ReflectionExpandSignatureMethod) {
                    ReflectionExpandSignatureMethod reflectionExpandSignatureMethod = (ReflectionExpandSignatureMethod)b;
                    b = builder.getWrappedMethod().initWrappedMember();
                    ((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.WrappedMember.Builder)((Object)b)).setReflectionExpandSignature(Void.VOID);
                    Executable member = reflectionExpandSignatureMethod.getMember();
                    SVMImageLayerWriter.persistMethodWrappedMember((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.WrappedMember.Builder)((Object)b), member);
                } else {
                    b = method.wrapped;
                    if (b instanceof JNIJavaCallVariantWrapperMethod) {
                        JNIJavaCallVariantWrapperMethod jniJavaCallVariantWrapperMethod = (JNIJavaCallVariantWrapperMethod)b;
                        b = builder.getWrappedMethod().initWrappedMember();
                        ((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.WrappedMember.Builder)((Object)b)).setJavaCallVariantWrapper(Void.VOID);
                        Executable executable = jniJavaCallVariantWrapperMethod.getMember();
                        SVMImageLayerWriter.persistMethodWrappedMember((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.WrappedMember.Builder)((Object)b), executable);
                    } else {
                        SubstitutionMethod substitutionMethod;
                        b = method.wrapped;
                        if (b instanceof SubstitutionMethod && (substitutionMethod = (SubstitutionMethod)b).getAnnotated() instanceof PolymorphicSignatureWrapperMethod) {
                            b = builder.getWrappedMethod().initPolymorphicSignature();
                            Set<AnalysisMethod> callers = this.polymorphicSignatureCallers.get(method);
                            PrimitiveList.Int.Builder callersBuilder = ((SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.PolymorphicSignature.Builder)((Object)b)).initCallers(callers.size());
                            int i = 0;
                            for (AnalysisMethod caller : callers) {
                                callersBuilder.set(i, caller.getId());
                                ++i;
                            }
                        }
                    }
                }
            }
        }
    }

    private static void persistMethodWrappedMember(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.WrappedMember.Builder b, Executable member) {
        b.setName(member instanceof Constructor ? "<init>" : member.getName());
        b.setDeclaringClassName(member.getDeclaringClass().getName());
        Parameter[] params = member.getParameters();
        TextList.Builder atb = b.initArgumentTypeNames(params.length);
        for (int i = 0; i < params.length; ++i) {
            atb.set(i, new Text.Reader(params[i].getType().getName()));
        }
    }

    private void persistField(AnalysisField field, Supplier<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Builder> fieldBuilderSupplier) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Builder builder = fieldBuilderSupplier.get();
        builder.setId(field.getId());
        builder.setDeclaringTypeId(field.getDeclaringClass().getId());
        builder.setName(field.getName());
        builder.setIsAccessed(field.getAccessedReason() != null);
        builder.setIsRead(field.getReadReason() != null);
        builder.setIsWritten(field.getWrittenReason() != null);
        builder.setIsFolded(field.getFoldedReason() != null);
        builder.setIsUnsafeAccessed(field.isUnsafeAccessed());
        Field originalField = OriginalFieldProvider.getJavaField((ResolvedJavaField)field);
        if (originalField != null && !originalField.getDeclaringClass().equals(field.getDeclaringClass().getJavaClass())) {
            builder.setClassName(originalField.getDeclaringClass().getName());
        }
        builder.setIsStatic(field.isStatic());
        builder.setIsInternal(field.isInternal());
        builder.setIsSynthetic(field.isSynthetic());
        builder.setTypeId(field.getType().getId());
        builder.setModifiers(field.getModifiers());
        builder.setPosition(field.getPosition());
        HostedField hostedField = this.hUniverse.lookup((JavaField)field);
        builder.setLocation(hostedField.getLocation());
        int fieldInstalledNum = -3;
        LayeredStaticFieldSupport.LayerAssignmentStatus assignmentStatus = LayeredStaticFieldSupport.singleton().getAssignmentStatus(field);
        if (hostedField.hasInstalledLayerNum()) {
            fieldInstalledNum = hostedField.getInstalledLayerNum();
            if (assignmentStatus == LayeredStaticFieldSupport.LayerAssignmentStatus.UNDECIDED) {
                assignmentStatus = LayeredStaticFieldSupport.LayerAssignmentStatus.PRIOR_LAYER;
            } else assert (assignmentStatus == LayeredStaticFieldSupport.LayerAssignmentStatus.APP_LAYER_REQUESTED || assignmentStatus == LayeredStaticFieldSupport.LayerAssignmentStatus.APP_LAYER_DEFERRED) : assignmentStatus;
        }
        builder.setPriorInstalledLayerNum(fieldInstalledNum);
        builder.setAssignmentStatus(assignmentStatus.ordinal());
        this.persistAnnotations((AnnotatedElement)field, builder::initAnnotationList);
    }

    private void persistAnnotations(AnnotatedElement annotatedElement, IntFunction<StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder>> builder) {
        Class[] annotationTypes = AnnotationAccess.getAnnotationTypes((AnnotatedElement)annotatedElement);
        this.persistAnnotations(annotatedElement, annotationTypes, builder);
    }

    private void persistAnnotations(AnnotatedElement annotatedElement, Class<? extends Annotation>[] annotationTypes, IntFunction<StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder>> builder) {
        StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder> b = builder.apply(annotationTypes.length);
        for (int i = 0; i < annotationTypes.length; ++i) {
            Class<? extends Annotation> annotationClass = annotationTypes[i];
            SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder annotationBuilder = (SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Builder)b.get(i);
            annotationBuilder.setTypeName(annotationClass.getName());
            Annotation annotation = AnnotationAccess.getAnnotation((AnnotatedElement)annotatedElement, annotationClass);
            this.persistAnnotationValues(annotation, annotationClass, annotationBuilder::initValues);
        }
    }

    private void persistAnnotationValues(Annotation annotation, Class<? extends Annotation> annotationClass, IntFunction<StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder>> builder) {
        AnnotationType annotationType = AnnotationType.getInstance(annotationClass);
        EconomicMap members = EconomicMap.create();
        annotationType.members().forEach((memberName, memberAccessor) -> {
            try {
                String moduleName = memberAccessor.getDeclaringClass().getModule().getName();
                if (moduleName != null) {
                    ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, SVMImageLayerWriter.class, (boolean)false, (String)moduleName, (String[])new String[0]);
                }
                AnnotationMemberValue memberValue = AnnotationMemberValue.getMemberValue(annotation, memberName, memberAccessor, annotationType);
                Object value = memberValue.get(annotationType.memberTypes().get(memberName));
                members.put(memberName, value);
            }
            catch (AnnotationMetadata.AnnotationExtractionError annotationExtractionError) {
                // empty catch block
            }
        });
        if (!members.isEmpty()) {
            StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder> list = builder.apply(members.size());
            MapCursor cursor = members.getEntries();
            int i = 0;
            while (cursor.advance()) {
                SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder b = (SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder)list.get(i);
                b.setName((String)cursor.getKey());
                Object v = cursor.getValue();
                this.persistAnnotationValue(v, b);
                ++i;
            }
        }
    }

    private void persistAnnotationValue(Object v, SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder b) {
        if (v.getClass().isArray()) {
            if (v instanceof Object[]) {
                Object[] array = (Object[])v;
                SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Members.Builder ba = b.initMembers();
                ba.setClassName(v.getClass().getComponentType().getName());
                StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder> bav = ba.initMemberValues(array.length);
                for (int i = 0; i < array.length; ++i) {
                    this.persistAnnotationValue(array[i], (SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder)bav.get(i));
                }
            } else {
                Class<?> componentType = v.getClass().getComponentType();
                assert (componentType.isPrimitive()) : String.valueOf(v) + " should be a primitive array";
                SVMImageLayerWriter.persistConstantPrimitiveArray(b.initPrimitiveArray(), JavaKind.fromJavaClass(componentType), v);
            }
        } else {
            Object object = v;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Float.class, Long.class, Double.class, Class.class, Annotation.class, String.class, Enum.class}, (Object)object2, n)) {
                case 0: {
                    Boolean z = (Boolean)object2;
                    SVMImageLayerWriter.setAnnotationPrimitiveValue(b, JavaKind.Boolean, z != false ? 1L : 0L);
                    break;
                }
                case 1: {
                    Byte z = (Byte)object2;
                    SVMImageLayerWriter.setAnnotationPrimitiveValue(b, JavaKind.Byte, z.byteValue());
                    break;
                }
                case 2: {
                    Short s = (Short)object2;
                    SVMImageLayerWriter.setAnnotationPrimitiveValue(b, JavaKind.Short, s.shortValue());
                    break;
                }
                case 3: {
                    Character c = (Character)object2;
                    SVMImageLayerWriter.setAnnotationPrimitiveValue(b, JavaKind.Char, c.charValue());
                    break;
                }
                case 4: {
                    Integer i = (Integer)object2;
                    SVMImageLayerWriter.setAnnotationPrimitiveValue(b, JavaKind.Int, i.intValue());
                    break;
                }
                case 5: {
                    Float f = (Float)object2;
                    SVMImageLayerWriter.setAnnotationPrimitiveValue(b, JavaKind.Float, Float.floatToRawIntBits(f.floatValue()));
                    break;
                }
                case 6: {
                    Long j = (Long)object2;
                    SVMImageLayerWriter.setAnnotationPrimitiveValue(b, JavaKind.Long, j);
                    break;
                }
                case 7: {
                    Double d = (Double)object2;
                    SVMImageLayerWriter.setAnnotationPrimitiveValue(b, JavaKind.Double, Double.doubleToRawLongBits(d));
                    break;
                }
                case 8: {
                    Class clazz = (Class)object2;
                    b.setClassName(clazz.getName());
                    break;
                }
                case 9: {
                    Annotation innerAnnotation = (Annotation)object2;
                    this.persistAnnotationValues(innerAnnotation, innerAnnotation.annotationType(), b.initAnnotation()::initValues);
                    break;
                }
                case 10: {
                    String s = (String)object2;
                    b.setString(s);
                    break;
                }
                case 11: {
                    Enum e = (Enum)object2;
                    SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Enum.Builder ba = b.initEnum();
                    ba.setClassName(e.getDeclaringClass().getName());
                    ba.setName(e.name());
                    break;
                }
                default: {
                    throw AnalysisError.shouldNotReachHere((String)("Unknown annotation value: " + String.valueOf(v)));
                }
            }
        }
    }

    private static void setAnnotationPrimitiveValue(SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Builder b, JavaKind kind, long rawValue) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Builder pv = b.initPrimitive();
        pv.setTypeChar(NumUtil.safeToUByte((int)kind.getTypeChar()));
        pv.setRawValue(rawValue);
    }

    private void persistConstant(ImageHeapConstant imageHeapConstant, ConstantParent parent, SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Builder builder, Set<Integer> constantsToRelink) {
        InitialLayerOnlyImageSingleton singleton;
        NativeImageHeap.ObjectInfo objectInfo = this.nativeImageHeap.getConstantInfo((JavaConstant)imageHeapConstant);
        builder.setObjectOffset(objectInfo == null ? -1L : objectInfo.getOffset());
        int id = ImageHeapConstant.getConstantID((ImageHeapConstant)imageHeapConstant);
        builder.setId(id);
        AnalysisType type = imageHeapConstant.getType();
        AnalysisError.guarantee((boolean)type.isTrackedAcrossLayers(), (String)"Type %s from constant %s should have been marked as trackedAcrossLayers, but was not", (Object[])new Object[]{type, imageHeapConstant});
        builder.setTypeId(type.getId());
        IdentityHashCodeProvider identityHashCodeProvider = (IdentityHashCodeProvider)this.aUniverse.getBigbang().getConstantReflectionProvider();
        int identityHashCode = identityHashCodeProvider.identityHashCode((JavaConstant)imageHeapConstant);
        builder.setIdentityHashCode(identityHashCode);
        if (imageHeapConstant.isBackedByHostedObject() && InitialLayerOnlyImageSingleton.class.isAssignableFrom(type.getJavaClass()) && (singleton = (InitialLayerOnlyImageSingleton)this.aUniverse.getBigbang().getSnippetReflectionProvider().asObject(InitialLayerOnlyImageSingleton.class, imageHeapConstant.getHostedObject())).accessibleInFutureLayers()) {
            this.initialLayerOnlySingletonMap.put(singleton, id);
        }
        ImageHeapConstant imageHeapConstant2 = imageHeapConstant;
        Objects.requireNonNull(imageHeapConstant2);
        ImageHeapConstant imageHeapConstant3 = imageHeapConstant2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImageHeapInstance.class, ImageHeapObjectArray.class, ImageHeapPrimitiveArray.class, ImageHeapRelocatableConstant.class}, (Object)imageHeapConstant3, n)) {
            case 0: {
                ImageHeapInstance imageHeapInstance = (ImageHeapInstance)imageHeapConstant3;
                builder.initObject().setInstance(Void.VOID);
                this.persistConstantObjectData(builder.getObject(), arg_0 -> ((ImageHeapInstance)imageHeapInstance).getFieldValue(arg_0), imageHeapInstance.getFieldValuesSize());
                this.persistConstantRelinkingInfo(builder, imageHeapConstant, constantsToRelink, this.aUniverse.getBigbang());
                break;
            }
            case 1: {
                ImageHeapObjectArray imageHeapObjectArray = (ImageHeapObjectArray)imageHeapConstant3;
                builder.initObject().setObjectArray(Void.VOID);
                this.persistConstantObjectData(builder.getObject(), arg_0 -> ((ImageHeapObjectArray)imageHeapObjectArray).getElement(arg_0), imageHeapObjectArray.getLength());
                break;
            }
            case 2: {
                ImageHeapPrimitiveArray imageHeapPrimitiveArray = (ImageHeapPrimitiveArray)imageHeapConstant3;
                SVMImageLayerWriter.persistConstantPrimitiveArray(builder.initPrimitiveData(), imageHeapPrimitiveArray.getType().getComponentType().getJavaKind(), imageHeapPrimitiveArray.getArray());
                break;
            }
            case 3: {
                ImageHeapRelocatableConstant relocatableConstant = (ImageHeapRelocatableConstant)imageHeapConstant3;
                builder.initRelocatable().setKey(relocatableConstant.getConstantData().key);
                break;
            }
            default: {
                throw AnalysisError.shouldNotReachHere((String)("Unexpected constant type " + String.valueOf(imageHeapConstant)));
            }
        }
        if (!constantsToRelink.contains(id) && parent != ConstantParent.NONE) {
            builder.setParentConstantId(parent.constantId);
            assert (parent.index != -1) : "Tried to persist child constant %s from parent constant %d, but got index %d".formatted(imageHeapConstant, parent.constantId, parent.index);
            builder.setParentIndex(parent.index);
        }
    }

    private void persistConstantRelinkingInfo(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Builder builder, ImageHeapConstant imageHeapConstant, Set<Integer> constantsToRelink, BigBang bb) {
        Class clazz = imageHeapConstant.getType().getJavaClass();
        JavaConstant hostedObject = imageHeapConstant.getHostedObject();
        boolean simulated = hostedObject == null;
        builder.setIsSimulated(simulated);
        if (!simulated) {
            AnalysisField field;
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.Builder relinkingBuilder = builder.getObject().getRelinking();
            int id = ImageHeapConstant.getConstantID((ImageHeapConstant)imageHeapConstant);
            ResolvedJavaType type = bb.getConstantReflectionProvider().asJavaType((Constant)hostedObject);
            boolean tryStaticFinalFieldRelink = true;
            if (type instanceof AnalysisType) {
                AnalysisType analysisType = (AnalysisType)type;
                relinkingBuilder.initClassConstant().setTypeId(analysisType.getId());
                constantsToRelink.add(id);
                tryStaticFinalFieldRelink = false;
            } else if (clazz.equals(String.class)) {
                SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.StringConstant.Builder stringConstantBuilder = relinkingBuilder.initStringConstant();
                String value = (String)bb.getSnippetReflectionProvider().asObject(String.class, hostedObject);
                if (this.internedStringsIdentityMap.containsKey(value)) {
                    stringConstantBuilder.setValue(value);
                    constantsToRelink.add(id);
                    tryStaticFinalFieldRelink = false;
                }
            } else if (Enum.class.isAssignableFrom(clazz)) {
                SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.EnumConstant.Builder enumBuilder = relinkingBuilder.initEnumConstant();
                Enum value = (Enum)bb.getSnippetReflectionProvider().asObject(Enum.class, hostedObject);
                enumBuilder.setEnumClass(value.getDeclaringClass().getName());
                enumBuilder.setEnumName(value.name());
                constantsToRelink.add(id);
                tryStaticFinalFieldRelink = false;
            }
            if (tryStaticFinalFieldRelink && this.shouldRelinkConstant(imageHeapConstant) && imageHeapConstant.getOrigin() != null && SVMImageLayerWriter.shouldRelinkField(field = imageHeapConstant.getOrigin())) {
                SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.FieldConstant.Builder fieldConstantBuilder = relinkingBuilder.initFieldConstant();
                fieldConstantBuilder.setOriginFieldId(field.getId());
                fieldConstantBuilder.setRequiresLateLoading(SVMImageLayerWriter.requiresLateLoading(imageHeapConstant, field));
            }
        }
    }

    private boolean shouldRelinkConstant(ImageHeapConstant heapConstant) {
        Object o = this.aUniverse.getHostedValuesProvider().asObject(Object.class, heapConstant.getHostedObject());
        return !(o instanceof FastThreadLocal) && !CrossLayerConstantRegistryFeature.singleton().isConstantRegistered(o);
    }

    private static boolean shouldRelinkField(AnalysisField field) {
        return !AnnotationAccess.isAnnotationPresent((AnnotatedElement)field, Delete.class) && ClassInitializationSupport.singleton().maybeInitializeAtBuildTime((ResolvedJavaType)field.getDeclaringClass()) && field.isStatic() && field.isFinal() && field.isTrackedAcrossLayers() && field.installableInLayer();
    }

    private static boolean requiresLateLoading(ImageHeapConstant imageHeapConstant, AnalysisField field) {
        return imageHeapConstant.getType().getWrapped() instanceof CustomSubstitutionType || FieldValueInterceptionSupport.hasFieldValueInterceptor(field);
    }

    private static void persistConstantPrimitiveArray(SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Builder builder, JavaKind componentKind, Object array) {
        assert (componentKind.toJavaClass().equals(array.getClass().getComponentType()));
        Object object = array;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{boolean[].class, byte[].class, short[].class, char[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object2, n)) {
            case 0: {
                boolean[] a = (boolean[])object2;
                SVMImageLayerWriter.persistArray(a, builder::initZ, (b, i) -> b.set(i, a[i]));
                break;
            }
            case 1: {
                byte[] a = (byte[])object2;
                SVMImageLayerWriter.persistArray(a, builder::initB, (b, i) -> b.set(i, a[i]));
                break;
            }
            case 2: {
                short[] a = (short[])object2;
                SVMImageLayerWriter.persistArray(a, builder::initS, (b, i) -> b.set(i, a[i]));
                break;
            }
            case 3: {
                char[] a = (char[])object2;
                SVMImageLayerWriter.persistArray(a, builder::initC, (b, i) -> b.set(i, (short)a[i]));
                break;
            }
            case 4: {
                int[] a = (int[])object2;
                SVMImageLayerWriter.persistArray(a, builder::initI, (b, i) -> b.set(i, a[i]));
                break;
            }
            case 5: {
                long[] a = (long[])object2;
                SVMImageLayerWriter.persistArray(a, builder::initJ, (b, i) -> b.set(i, a[i]));
                break;
            }
            case 6: {
                float[] a = (float[])object2;
                SVMImageLayerWriter.persistArray(a, builder::initF, (b, i) -> b.set(i, a[i]));
                break;
            }
            case 7: {
                double[] a = (double[])object2;
                SVMImageLayerWriter.persistArray(a, builder::initD, (b, i) -> b.set(i, a[i]));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported kind: " + String.valueOf(componentKind));
            }
        }
    }

    private static <A, T extends ListBuilder> void persistArray(A array, IntFunction<T> init, ObjIntConsumer<T> setter) {
        int length = Array.getLength(array);
        ListBuilder builder = (ListBuilder)init.apply(length);
        for (int i = 0; i < length; ++i) {
            setter.accept(builder, i);
        }
    }

    private void persistConstantObjectData(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Builder builder, IntFunction<Object> valuesFunction, int size) {
        StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder> refsBuilder = builder.initData(size);
        for (int i = 0; i < size; ++i) {
            JavaConstant javaConstant;
            Object object = valuesFunction.apply(i);
            SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder b = (SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder)refsBuilder.get(i);
            if (SVMImageLayerWriter.delegateProcessing(b, object) || object instanceof JavaConstant && this.maybeWriteConstant(javaConstant = (JavaConstant)object, b)) continue;
            AnalysisError.guarantee((boolean)(object instanceof AnalysisFuture), (String)"Unexpected constant %s", (Object[])new Object[]{object});
            b.setNotMaterialized(Void.VOID);
        }
    }

    private boolean maybeWriteConstant(JavaConstant constant, SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder builder) {
        if (constant instanceof ImageHeapConstant) {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)constant;
            assert (this.constantsMap.containsKey(imageHeapConstant));
            SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.ObjectConstant.Builder ocb = builder.initObjectConstant();
            ocb.setConstantId(ImageHeapConstant.getConstantID((ImageHeapConstant)imageHeapConstant));
        } else if (constant instanceof PrimitiveConstant) {
            PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
            SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Builder pb = builder.initPrimitiveValue();
            pb.setTypeChar(NumUtil.safeToUByte((int)primitiveConstant.getJavaKind().getTypeChar()));
            pb.setRawValue(primitiveConstant.getRawValue());
        } else if (constant == JavaConstant.NULL_POINTER) {
            builder.setNullPointer(Void.VOID);
        } else {
            return false;
        }
        return true;
    }

    private static boolean delegateProcessing(SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder builder, Object constant) {
        if (constant instanceof PatchedWordConstant) {
            PatchedWordConstant patchedWordConstant = (PatchedWordConstant)constant;
            WordBase word = patchedWordConstant.getWord();
            if (word instanceof MethodPointer) {
                MethodPointer methodPointer = (MethodPointer)word;
                AnalysisMethod method = SVMImageLayerWriter.getRelocatableConstantMethod(methodPointer);
                builder.initMethodPointer().setMethodId(method.getId());
                return true;
            }
            if (word instanceof CEntryPointLiteralCodePointer) {
                CEntryPointLiteralCodePointer cp = (CEntryPointLiteralCodePointer)word;
                SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.Builder b = builder.initCEntryPointLiteralCodePointer();
                b.setMethodName(cp.methodName);
                b.setDefiningClass(cp.definingClass.getName());
                b.initParameterNames(cp.parameterTypes.length);
                for (int i = 0; i < cp.parameterTypes.length; ++i) {
                    b.getParameterNames().set(i, new Text.Reader(cp.parameterTypes[i].getName()));
                }
                return true;
            }
            if (word instanceof CGlobalDataBasePointer) {
                builder.setCGlobalDataBasePointer(Void.VOID);
                return true;
            }
        }
        return false;
    }

    private void scanConstantReferencedObjects(ImageHeapConstant constant, Collection<ImageHeapConstant> discoveredConstants) {
        ImageHeapConstant imageHeapConstant = Objects.requireNonNull(constant);
        if (imageHeapConstant instanceof ImageHeapInstance) {
            ImageHeapInstance instance = (ImageHeapInstance)imageHeapConstant;
            this.scanConstantReferencedObjects(constant, arg_0 -> ((ImageHeapInstance)instance).getFieldValue(arg_0), instance.getFieldValuesSize(), discoveredConstants);
        } else if (constant instanceof ImageHeapObjectArray) {
            ImageHeapObjectArray objArray = (ImageHeapObjectArray)constant;
            this.scanConstantReferencedObjects(constant, arg_0 -> ((ImageHeapObjectArray)objArray).getElement(arg_0), objArray.getLength(), discoveredConstants);
        }
    }

    private void scanConstantReferencedObjects(ImageHeapConstant constant, IntFunction<Object> referencedObjectFunction, int size, Collection<ImageHeapConstant> discoveredConstants) {
        for (int i = 0; i < size; ++i) {
            ImageHeapConstant con;
            AnalysisType parentType = constant.getType();
            Object obj = referencedObjectFunction.apply(i);
            if (obj instanceof ImageHeapConstant && !this.constantsMap.containsKey(con = (ImageHeapConstant)obj)) {
                Set<Integer> relinkedFields = this.imageLayerSnapshotUtil.getRelinkedFields(parentType, this.aUniverse.getBigbang().getMetaAccess());
                ConstantParent parent = relinkedFields.contains(i) ? new ConstantParent(ImageHeapConstant.getConstantID((ImageHeapConstant)constant), i) : ConstantParent.NONE;
                discoveredConstants.add(con);
                this.constantsMap.put(con, parent);
                continue;
            }
            if (!(obj instanceof MethodPointer)) continue;
            MethodPointer mp = (MethodPointer)obj;
            SVMImageLayerWriter.getRelocatableConstantMethod(mp).registerAsTrackedAcrossLayers((Object)"In method pointer");
        }
    }

    private static AnalysisMethod getRelocatableConstantMethod(MethodPointer methodPointer) {
        ResolvedJavaMethod method = methodPointer.getMethod();
        if (method instanceof HostedMethod) {
            HostedMethod hostedMethod = (HostedMethod)method;
            return hostedMethod.wrapped;
        }
        return (AnalysisMethod)method;
    }

    public void persistAnalysisParsedGraph(AnalysisMethod method, AnalysisParsedGraph analysisParsedGraph) {
        String location;
        String name = this.imageLayerSnapshotUtil.getMethodDescriptor(method);
        MethodGraphsInfo graphsInfo = this.methodsMap.get(name);
        if ((graphsInfo == null || graphsInfo.analysisGraphLocation == null) && (location = this.persistGraph(method, new EncodedGraph(analysisParsedGraph.getEncodedGraph()))) != null) {
            this.methodsMap.compute(name, (n, mgi) -> (mgi != null ? mgi : MethodGraphsInfo.NO_GRAPHS).withAnalysisGraph(location, analysisParsedGraph.isIntrinsic()));
        }
    }

    public void persistMethodStrengthenedGraph(AnalysisMethod method) {
        if (!this.useSharedLayerStrengthenedGraphs) {
            return;
        }
        String name = this.imageLayerSnapshotUtil.getMethodDescriptor(method);
        MethodGraphsInfo graphsInfo = this.methodsMap.get(name);
        if (graphsInfo == null || graphsInfo.strengthenedGraphLocation == null) {
            EncodedGraph analyzedGraph = method.getAnalyzedGraph();
            String location = this.persistGraph(method, analyzedGraph);
            this.methodsMap.compute(name, (n, mgi) -> (mgi != null ? mgi : MethodGraphsInfo.NO_GRAPHS).withStrengthenedGraph(location));
        }
    }

    private String persistGraph(AnalysisMethod method, EncodedGraph analyzedGraph) {
        if (!this.useSharedLayerGraphs) {
            return null;
        }
        if (Arrays.stream(analyzedGraph.getObjects()).anyMatch(o -> o instanceof AnalysisFuture)) {
            return null;
        }
        byte[] encodedGraph = ObjectCopier.encode((ObjectCopier.Encoder)this.imageLayerSnapshotUtil.getGraphEncoder(this.nodeClassMap), (Object)analyzedGraph);
        if (SVMImageLayerWriter.contains(encodedGraph, "$$Lambda".getBytes(StandardCharsets.UTF_8))) {
            throw AnalysisError.shouldNotReachHere((String)"The graph for the method %s contains a reference to a lambda type, which cannot be decoded: %s".formatted(method, encodedGraph));
        }
        return this.graphsOutput.add(encodedGraph);
    }

    private static boolean contains(byte[] data, byte[] seq) {
        block0: for (int i = 0; i <= data.length - seq.length; ++i) {
            for (int j = 0; j < seq.length; ++j) {
                if (data[i + j] != seq[j]) continue block0;
            }
            return true;
        }
        return false;
    }

    public void addPolymorphicSignatureCaller(AnalysisMethod polymorphicSignature, AnalysisMethod caller) {
        AnalysisError.guarantee((!this.polymorphicSignatureSealed ? 1 : 0) != 0, (String)"The caller %s for method %s was added after the methods were persisted", (Object[])new Object[]{caller, polymorphicSignature});
        this.polymorphicSignatureCallers.computeIfAbsent(polymorphicSignature, m -> ConcurrentHashMap.newKeySet()).add(caller);
    }

    public void writeImageSingletonInfo(List<Map.Entry<Class<?>, Object>> layeredImageSingletons) {
        SingletonPersistInfo info;
        StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.Builder> singletonsBuilder = this.snapshotBuilder.initSingletonKeys(layeredImageSingletons.size());
        HashMap<LayeredImageSingleton, SingletonPersistInfo> singletonInfoMap = new HashMap<LayeredImageSingleton, SingletonPersistInfo>();
        int nextID = 1;
        for (int i = 0; i < layeredImageSingletons.size(); ++i) {
            InitialLayerOnlyImageSingleton initialLayerOnlyImageSingleton;
            LayeredImageSingleton singleton;
            Map.Entry<Class<?>, Object> singletonInfo = layeredImageSingletons.get(i);
            Object object = singletonInfo.getValue();
            if (object instanceof RuntimeOnlyWrapper) {
                RuntimeOnlyWrapper wrapper = (RuntimeOnlyWrapper)object;
                singleton = wrapper.wrappedObject();
            } else {
                singleton = (LayeredImageSingleton)singletonInfo.getValue();
            }
            String key = singletonInfo.getKey().getName();
            if (!singletonInfoMap.containsKey(singleton)) {
                ImageSingletonWriterImpl writer = new ImageSingletonWriterImpl(this.snapshotBuilder, this.hUniverse);
                LayeredImageSingleton.PersistFlags flags = singleton.preparePersist(writer);
                boolean persistData = flags == LayeredImageSingleton.PersistFlags.CREATE;
                SingletonPersistInfo info2 = new SingletonPersistInfo(flags, persistData ? nextID++ : -1, persistData ? writer.getKeyValueStore() : null);
                singletonInfoMap.put(singleton, info2);
            }
            info = (SingletonPersistInfo)singletonInfoMap.get(singleton);
            SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.Builder sb = (SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonKey.Builder)singletonsBuilder.get(i);
            sb.setKeyClassName(key);
            sb.setObjectId(info.id);
            sb.setPersistFlag(info.flags.ordinal());
            int constantId = -1;
            if (singleton instanceof InitialLayerOnlyImageSingleton && (initialLayerOnlyImageSingleton = (InitialLayerOnlyImageSingleton)singleton).accessibleInFutureLayers()) {
                constantId = this.initialLayerOnlySingletonMap.getOrDefault(initialLayerOnlyImageSingleton, -1);
            }
            sb.setConstantId(constantId);
        }
        List<Map.Entry> sortedByIDs = singletonInfoMap.entrySet().stream().filter(e -> ((SingletonPersistInfo)e.getValue()).flags == LayeredImageSingleton.PersistFlags.CREATE).sorted(Comparator.comparingInt(e -> ((SingletonPersistInfo)e.getValue()).id)).toList();
        StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.Builder> objectsBuilder = this.snapshotBuilder.initSingletonObjects(sortedByIDs.size());
        for (int i = 0; i < sortedByIDs.size(); ++i) {
            Map.Entry entry = sortedByIDs.get(i);
            info = (SingletonPersistInfo)entry.getValue();
            SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.Builder ob = (SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.Builder)objectsBuilder.get(i);
            ob.setId(info.id);
            ob.setClassName(((LayeredImageSingleton)entry.getKey()).getClass().getName());
            SVMImageLayerWriter.writeImageSingletonKeyStore(ob, info.keyStore);
        }
    }

    private static void writeImageSingletonKeyStore(SharedLayerSnapshotCapnProtoSchemaHolder.ImageSingletonObject.Builder objectData, EconomicMap<String, Object> keyStore) {
        StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Builder> lb = objectData.initStore(keyStore.size());
        MapCursor cursor = keyStore.getEntries();
        int i = 0;
        while (cursor.advance()) {
            Object object;
            SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Builder b = (SharedLayerSnapshotCapnProtoSchemaHolder.KeyStoreEntry.Builder)lb.get(i);
            b.setKey((String)cursor.getKey());
            Objects.requireNonNull(cursor.getValue());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, String.class, int[].class, String[].class, boolean[].class}, (Object)object, n)) {
                case 0: {
                    Integer iv = (Integer)object;
                    b.getValue().setI(iv);
                    break;
                }
                case 1: {
                    Long jv = (Long)object;
                    b.getValue().setJ(jv);
                    break;
                }
                case 2: {
                    String str = (String)object;
                    b.getValue().setStr(str);
                    break;
                }
                case 3: {
                    int[] il = (int[])object;
                    PrimitiveList.Int.Builder ilb = b.getValue().initIl(il.length);
                    for (int j = 0; j < il.length; ++j) {
                        ilb.set(j, il[j]);
                    }
                    break;
                }
                case 4: {
                    String[] strl = (String[])object;
                    TextList.Builder strlb = b.getValue().initStrl(strl.length);
                    for (int j = 0; j < strl.length; ++j) {
                        strlb.set(j, new Text.Reader(strl[j]));
                    }
                    break;
                }
                case 5: {
                    boolean[] zl = (boolean[])object;
                    PrimitiveList.Boolean.Builder zlb = b.getValue().initZl(zl.length);
                    for (int j = 0; j < zl.length; ++j) {
                        zlb.set(j, zl[j]);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected type: " + String.valueOf(cursor.getValue()));
                }
            }
            ++i;
        }
    }

    public void writeConstant(JavaConstant constant, SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder builder) {
        if (constant == null) {
            return;
        }
        if (!this.maybeWriteConstant(constant, builder)) {
            throw VMError.shouldNotReachHere("Unexpected constant: " + String.valueOf(constant));
        }
    }

    private static class GraphsOutput {
        private final FileChannel channel;
        private final AtomicLong currentOffset = new AtomicLong(0L);

        GraphsOutput() {
            Path snapshotGraphsPath = HostedImageLayerBuildingSupport.singleton().getWriteLayerArchiveSupport().getSnapshotGraphsPath();
            try {
                Files.createFile(snapshotGraphsPath, new FileAttribute[0]);
                this.channel = FileChannel.open(snapshotGraphsPath, EnumSet.of(StandardOpenOption.WRITE), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Error opening temporary graphs file " + String.valueOf(snapshotGraphsPath), e);
            }
        }

        String add(byte[] encodedGraph) {
            long offset = this.currentOffset.getAndAdd(encodedGraph.length);
            try {
                this.channel.write(ByteBuffer.wrap(encodedGraph), offset);
            }
            catch (Exception e) {
                throw GraalError.shouldNotReachHere((Throwable)e, (String)"Error during graphs file dumping.");
            }
            return "@" + offset + "[" + encodedGraph.length + "]";
        }

        void finish() {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                throw VMError.shouldNotReachHere("Error during graphs file dumping.", e);
            }
        }
    }

    private record MethodGraphsInfo(String analysisGraphLocation, boolean analysisGraphIsIntrinsic, String strengthenedGraphLocation) {
        static final MethodGraphsInfo NO_GRAPHS = new MethodGraphsInfo(null, false, null);

        MethodGraphsInfo withAnalysisGraph(String location, boolean isIntrinsic) {
            assert (this.analysisGraphLocation == null && !this.analysisGraphIsIntrinsic);
            return new MethodGraphsInfo(location, isIntrinsic, this.strengthenedGraphLocation);
        }

        MethodGraphsInfo withStrengthenedGraph(String location) {
            assert (this.strengthenedGraphLocation == null);
            return new MethodGraphsInfo(this.analysisGraphLocation, this.analysisGraphIsIntrinsic, location);
        }
    }

    private record ConstantParent(int constantId, int index) {
        static ConstantParent NONE = new ConstantParent(-1, -1);
    }

    public static class ImageSingletonWriterImpl
    implements ImageSingletonWriter {
        private final EconomicMap<String, Object> keyValueStore = EconomicMap.create();
        private final SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Builder snapshotBuilder;
        private final HostedUniverse hUniverse;

        ImageSingletonWriterImpl(SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Builder snapshotBuilder, HostedUniverse hUniverse) {
            this.snapshotBuilder = snapshotBuilder;
            this.hUniverse = hUniverse;
        }

        EconomicMap<String, Object> getKeyValueStore() {
            return this.keyValueStore;
        }

        public HostedUniverse getHostedUniverse() {
            return this.hUniverse;
        }

        private static boolean nonNullEntries(List<?> list) {
            return list.stream().filter(Objects::isNull).findAny().isEmpty();
        }

        @Override
        public void writeBoolList(String keyName, List<Boolean> value) {
            assert (ImageSingletonWriterImpl.nonNullEntries(value));
            boolean[] b = new boolean[value.size()];
            for (int i = 0; i < value.size(); ++i) {
                b[i] = value.get(i);
            }
            Object previous = this.keyValueStore.put((Object)keyName, (Object)b);
            assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{keyName, previous});
        }

        @Override
        public void writeInt(String keyName, int value) {
            Object previous = this.keyValueStore.put((Object)keyName, (Object)value);
            assert (previous == null) : previous;
        }

        @Override
        public void writeIntList(String keyName, List<Integer> value) {
            assert (ImageSingletonWriterImpl.nonNullEntries(value));
            Object previous = this.keyValueStore.put((Object)keyName, (Object)value.stream().mapToInt(i -> i).toArray());
            assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{keyName, previous});
        }

        @Override
        public void writeLong(String keyName, long value) {
            Object previous = this.keyValueStore.put((Object)keyName, (Object)value);
            assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{keyName, previous});
        }

        @Override
        public void writeString(String keyName, String value) {
            Object previous = this.keyValueStore.put((Object)keyName, (Object)value);
            assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{keyName, previous});
        }

        @Override
        public void writeStringList(String keyName, List<String> value) {
            assert (ImageSingletonWriterImpl.nonNullEntries(value));
            Object previous = this.keyValueStore.put((Object)keyName, value.toArray(String[]::new));
            assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{keyName, previous});
        }

        public SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Builder getSnapshotBuilder() {
            return this.snapshotBuilder;
        }
    }

    record SingletonPersistInfo(LayeredImageSingleton.PersistFlags flags, int id, EconomicMap<String, Object> keyStore) {
    }
}

