/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.shaded.org.capnproto.PrimitiveList;
import com.oracle.svm.shaded.org.capnproto.StructList;
import com.oracle.svm.shaded.org.capnproto.StructReader;
import com.oracle.svm.shaded.org.capnproto.TextList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public class CapnProtoAdapters {
    static void forEach(PrimitiveList.Int.Reader reader, IntConsumer action) {
        for (int i = 0; i < reader.size(); ++i) {
            action.accept(reader.get(i));
        }
    }

    public static void forEach(TextList.Reader reader, Consumer<String> action) {
        for (int i = 0; i < reader.size(); ++i) {
            action.accept(reader.get(i).toString());
        }
    }

    static <T> T[] toArray(PrimitiveList.Int.Reader reader, IntFunction<? extends T> mapper, IntFunction<T[]> arrayGenerator) {
        T[] array = arrayGenerator.apply(reader.size());
        for (int i = 0; i < reader.size(); ++i) {
            array[i] = mapper.apply(reader.get(i));
        }
        return array;
    }

    static <R, T> T[] toArray(StructList.Reader<R> reader, Function<? super R, ? extends T> mapper, IntFunction<T[]> arrayGenerator) {
        T[] array = arrayGenerator.apply(reader.size());
        for (int i = 0; i < reader.size(); ++i) {
            array[i] = mapper.apply(reader.get(i));
        }
        return array;
    }

    static <T> T[] toArray(TextList.Reader reader, Function<String, ? extends T> mapper, IntFunction<T[]> arrayGenerator) {
        T[] array = arrayGenerator.apply(reader.size());
        for (int i = 0; i < reader.size(); ++i) {
            array[i] = mapper.apply(reader.get(i).toString());
        }
        return array;
    }

    public static <T, U extends Collection<T>> U toCollection(PrimitiveList.Int.Reader reader, IntFunction<? extends T> mapper, Supplier<U> collectionFactory) {
        Collection collection = (Collection)collectionFactory.get();
        for (int i = 0; i < reader.size(); ++i) {
            collection.add(mapper.apply(reader.get(i)));
        }
        return (U)collection;
    }

    public static <U extends Collection<String>> U toCollection(TextList.Reader reader, Supplier<U> collectionFactory) {
        return CapnProtoAdapters.toCollection(reader, (String s) -> s, collectionFactory);
    }

    public static <T, U extends Collection<T>> U toCollection(TextList.Reader reader, Function<String, ? extends T> mapper, Supplier<U> collectionFactory) {
        Collection collection = (Collection)collectionFactory.get();
        for (int i = 0; i < reader.size(); ++i) {
            collection.add(mapper.apply(reader.get(i).toString()));
        }
        return (U)collection;
    }

    static Object toArray(SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Reader reader) {
        return switch (reader.which()) {
            default -> throw new MatchException(null, null);
            case SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Which.Z -> CapnProtoAdapters.toBooleanArray(reader.getZ());
            case SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Which.B -> (Object[])CapnProtoAdapters.toByteArray(reader.getB());
            case SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Which.S -> (Object[])CapnProtoAdapters.toShortArray(reader.getS());
            case SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Which.C -> (Object[])CapnProtoAdapters.toCharArray(reader.getC());
            case SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Which.I -> (Object[])CapnProtoAdapters.toIntArray(reader.getI());
            case SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Which.F -> (Object[])CapnProtoAdapters.toFloatArray(reader.getF());
            case SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Which.J -> (Object[])CapnProtoAdapters.toLongArray(reader.getJ());
            case SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Which.D -> (Object[])CapnProtoAdapters.toDoubleArray(reader.getD());
            case SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveArray.Which._NOT_IN_SCHEMA -> throw new IllegalArgumentException("Unsupported kind: " + String.valueOf((Object)reader.which()));
        };
    }

    protected static boolean[] toBooleanArray(PrimitiveList.Boolean.Reader booleanReader) {
        boolean[] booleanArray = new boolean[booleanReader.size()];
        for (int i = 0; i < booleanReader.size(); ++i) {
            booleanArray[i] = booleanReader.get(i);
        }
        return booleanArray;
    }

    static byte[] toByteArray(PrimitiveList.Byte.Reader byteReader) {
        byte[] byteArray = new byte[byteReader.size()];
        for (int i = 0; i < byteReader.size(); ++i) {
            byteArray[i] = byteReader.get(i);
        }
        return byteArray;
    }

    static short[] toShortArray(PrimitiveList.Short.Reader shortReader) {
        short[] shortArray = new short[shortReader.size()];
        for (int i = 0; i < shortReader.size(); ++i) {
            shortArray[i] = shortReader.get(i);
        }
        return shortArray;
    }

    static char[] toCharArray(PrimitiveList.Short.Reader charReader) {
        char[] charArray = new char[charReader.size()];
        for (int i = 0; i < charReader.size(); ++i) {
            charArray[i] = (char)charReader.get(i);
        }
        return charArray;
    }

    public static int[] toIntArray(PrimitiveList.Int.Reader intReader) {
        int[] intArray = new int[intReader.size()];
        for (int i = 0; i < intReader.size(); ++i) {
            intArray[i] = intReader.get(i);
        }
        return intArray;
    }

    static float[] toFloatArray(PrimitiveList.Float.Reader floatReader) {
        float[] floatArray = new float[floatReader.size()];
        for (int i = 0; i < floatReader.size(); ++i) {
            floatArray[i] = floatReader.get(i);
        }
        return floatArray;
    }

    static long[] toLongArray(PrimitiveList.Long.Reader longReader) {
        long[] longArray = new long[longReader.size()];
        for (int i = 0; i < longReader.size(); ++i) {
            longArray[i] = longReader.get(i);
        }
        return longArray;
    }

    static double[] toDoubleArray(PrimitiveList.Double.Reader doubleReader) {
        double[] doubleArray = new double[doubleReader.size()];
        for (int i = 0; i < doubleReader.size(); ++i) {
            doubleArray[i] = doubleReader.get(i);
        }
        return doubleArray;
    }

    public static String[] toStringArray(TextList.Reader reader) {
        return CapnProtoAdapters.toArray(reader, (String s) -> s, String[]::new);
    }

    static <T extends StructReader> T binarySearchUnique(int key, StructList.Reader<T> sortedList, ToIntFunction<T> keyExtractor) {
        int low = 0;
        int high = sortedList.size() - 1;
        int prevMid = -1;
        int prevKey = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            StructReader midStruct = (StructReader)sortedList.get(mid);
            int midKey = keyExtractor.applyAsInt(midStruct);
            assert (prevMid == -1 || mid < prevMid && midKey < prevKey || mid > prevMid && midKey > prevKey) : "unsorted or contains duplicates";
            if (midKey < key) {
                low = mid + 1;
            } else if (midKey > key) {
                high = mid - 1;
            } else {
                return (T)midStruct;
            }
            prevMid = mid;
            prevKey = midKey;
        }
        return null;
    }
}

