/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.RegistryAdapter;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.List;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;

public class JNIRegistryAdapter
extends RegistryAdapter {
    public JNIRegistryAdapter(ReflectionRegistry registry, ImageClassLoader classLoader) {
        super(registry, classLoader);
    }

    @Override
    public void registerPublicClasses(ConfigurationCondition condition, Class<?> type) {
        this.registry.register(condition, (Class[])type.getClasses());
    }

    @Override
    public void registerDeclaredClasses(ConfigurationCondition condition, Class<?> type) {
        this.registry.register(condition, (Class[])type.getDeclaredClasses());
    }

    @Override
    public void registerRecordComponents(ConfigurationCondition condition, Class<?> type) {
        VMError.shouldNotReachHere("Record components cannot be accessed through JNI registrations");
    }

    @Override
    public void registerPermittedSubclasses(ConfigurationCondition condition, Class<?> type) {
        VMError.shouldNotReachHere("Permitted subclasses cannot be accessed through JNI registrations");
    }

    @Override
    public void registerNestMembers(ConfigurationCondition condition, Class<?> type) {
        VMError.shouldNotReachHere("Nest members cannot be accessed through JNI registrations");
    }

    @Override
    public void registerSigners(ConfigurationCondition condition, Class<?> type) {
        VMError.shouldNotReachHere("Signers cannot be accessed through JNI registrations");
    }

    @Override
    public void registerPublicFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerPublicFields(condition, queriedOnly, false, type);
    }

    @Override
    public void registerDeclaredFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerDeclaredFields(condition, queriedOnly, false, type);
    }

    @Override
    public void registerPublicMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerPublicMethods(condition, queriedOnly, false, type);
    }

    @Override
    public void registerDeclaredMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerDeclaredMethods(condition, queriedOnly, false, type);
    }

    @Override
    public void registerPublicConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerPublicConstructors(condition, queriedOnly, false, type);
    }

    @Override
    public void registerDeclaredConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerDeclaredConstructors(condition, queriedOnly, false, type);
    }

    @Override
    protected void registerField(ConfigurationCondition condition, boolean allowWrite, boolean jniAccessible, Field field) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerField(condition, allowWrite, true, field);
    }

    @Override
    protected void registerFieldNegativeQuery(ConfigurationCondition condition, boolean jniAccessible, Class<?> type, String fieldName) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerFieldNegativeQuery(condition, true, type, fieldName);
    }

    @Override
    protected void registerExecutable(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Executable ... executable) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerExecutable(condition, queriedOnly, true, executable);
    }

    @Override
    protected void registerMethodNegativeQuery(ConfigurationCondition condition, boolean jniAccessible, Class<?> type, String methodName, List<Class<?>> methodParameterTypes) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerMethodNegativeQuery(condition, true, type, methodName, methodParameterTypes);
    }

    @Override
    protected void registerConstructorNegativeQuery(ConfigurationCondition condition, boolean jniAccessible, Class<?> type, List<Class<?>> constructorParameterTypes) {
        JNIRegistryAdapter.ensureJniAccessible(jniAccessible);
        super.registerConstructorNegativeQuery(condition, true, type, constructorParameterTypes);
    }

    @Override
    public void registerAsSerializable(ConfigurationCondition condition, Class<?> clazz) {
        VMError.shouldNotReachHere("serializable cannot be set on JNI registrations");
    }

    private static void ensureJniAccessible(boolean jniAccessible) {
        VMError.guarantee(jniAccessible, "JNIRegistryAdapter can only be used for JNI queries");
    }
}

