/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ameta.CustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.FieldValueComputer;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.FieldValueTransformation;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

public final class FieldValueInterceptionSupport {
    private static final Object INTERCEPTOR_ACCESSED_MARKER = new Object();
    private final AnnotationSubstitutionProcessor annotationSubstitutions;
    private final Map<ResolvedJavaField, Object> fieldValueInterceptors = new ConcurrentHashMap<ResolvedJavaField, Object>();

    public static FieldValueInterceptionSupport singleton() {
        return (FieldValueInterceptionSupport)ImageSingletons.lookup(FieldValueInterceptionSupport.class);
    }

    public FieldValueInterceptionSupport(AnnotationSubstitutionProcessor annotationSubstitutions) {
        this.annotationSubstitutions = annotationSubstitutions;
    }

    public FieldValueTransformer lookupAlreadyRegisteredTransformer(ResolvedJavaField oField) {
        assert (!(oField instanceof OriginalFieldProvider)) : oField;
        Object existingInterceptor = this.fieldValueInterceptors.get(oField);
        if (existingInterceptor instanceof FieldValueTransformation) {
            FieldValueTransformation fieldValueTransformation = (FieldValueTransformation)existingInterceptor;
            return fieldValueTransformation.getFieldValueTransformer();
        }
        return null;
    }

    public void registerFieldValueTransformer(Field reflectionField, FieldValueTransformer transformer) {
        this.registerFieldValueTransformer(GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaField(reflectionField), transformer);
    }

    public void registerFieldValueTransformer(ResolvedJavaField oField, FieldValueTransformer transformer) {
        if (this.annotationSubstitutions.isDeleted(oField)) {
            throw UserError.abort("Cannot register a field value transformer for field %s: %s", oField.format("%H.%n"), "The field is marked as deleted, i.e., the field is not available on this platform");
        }
        this.registerFieldValueTransformer(oField, OriginalClassProvider.getJavaClass((JavaType)oField.getType()), transformer);
    }

    public void registerFieldValueTransformer(ResolvedJavaField oField, Class<?> transformedValueAllowedType, FieldValueTransformer transformer) {
        assert (oField != null && !(oField instanceof OriginalFieldProvider)) : oField;
        FieldValueTransformation transformation = new FieldValueTransformation(transformedValueAllowedType, Objects.requireNonNull(transformer));
        Object existingInterceptor = this.fieldValueInterceptors.putIfAbsent(oField, transformation);
        if (existingInterceptor == INTERCEPTOR_ACCESSED_MARKER) {
            throw UserError.abort("Cannot register a field value transformer for field %s: %s", oField.format("%H.%n"), "The field was already accessed by the static analysis. The transformer must be registered earlier, before the static analysis sees a reference to the field for the first time.");
        }
        if (existingInterceptor != null) {
            throw UserError.abort("Cannot register a field value transformer for field %s: %s", oField.format("%H.%n"), "A field value transformer is already registered for this field, or the field value is transformed via an @Alias annotation.");
        }
    }

    Object lookupFieldValueInterceptor(AnalysisField field) {
        Object result = field.getFieldValueInterceptor();
        if (result == null) {
            result = this.computeAndCacheFieldValueInterceptor(field);
        }
        return result == INTERCEPTOR_ACCESSED_MARKER ? null : result;
    }

    private Object computeAndCacheFieldValueInterceptor(AnalysisField field) {
        Object result;
        field.beforeFieldValueAccess();
        ResolvedJavaField oField = OriginalFieldProvider.getOriginalField((ResolvedJavaField)field);
        FieldValueComputer computer = FieldValueInterceptionSupport.createFieldValueComputer(field);
        if (computer != null) {
            VMError.guarantee(oField != null, "Cannot have a @UnknownObjectField or @UnknownPrimitiveField annotation on synthetic field %s", field);
            Object interceptor = this.fieldValueInterceptors.computeIfAbsent(oField, k -> computer);
            if (!(interceptor instanceof FieldValueComputer)) {
                throw UserError.abort("Cannot register a field value transformer for field %s: %s", field.format("%H.%n"), "The field is annotated with @UnknownObjectField or @UnknownPrimitiveField.");
            }
            result = interceptor;
        } else {
            result = oField != null ? this.fieldValueInterceptors.computeIfAbsent(oField, k -> INTERCEPTOR_ACCESSED_MARKER) : INTERCEPTOR_ACCESSED_MARKER;
        }
        Objects.requireNonNull(result, "Must have a non-null value now to avoid repeated invocation of this method");
        field.setFieldValueInterceptor(result);
        return result;
    }

    public boolean isValueAvailable(AnalysisField field) {
        FieldValueComputer computer;
        FieldValueTransformation transformation;
        Object interceptor = this.lookupFieldValueInterceptor(field);
        return !(interceptor instanceof FieldValueTransformation ? !(transformation = (FieldValueTransformation)interceptor).getFieldValueTransformer().isAvailable() : interceptor instanceof FieldValueComputer && !(computer = (FieldValueComputer)interceptor).isAvailable());
    }

    public static boolean hasFieldValueInterceptor(AnalysisField field) {
        Object interceptor = field.getFieldValueInterceptor();
        if (interceptor != null && interceptor != INTERCEPTOR_ACCESSED_MARKER) {
            VMError.guarantee(interceptor instanceof FieldValueTransformation || interceptor instanceof FieldValueComputer);
            return true;
        }
        return false;
    }

    public boolean hasFieldValueTransformer(AnalysisField field) {
        return this.lookupFieldValueInterceptor(field) instanceof FieldValueTransformation;
    }

    public ValueNode tryIntrinsifyFieldLoad(CoreProviders providers, LoadFieldNode node) {
        JavaConstant receiver;
        FieldValueTransformerWithAvailability transformerWithAvailability;
        block6: {
            block7: {
                AnalysisField field;
                block5: {
                    field = (AnalysisField)node.field();
                    Object interceptor = this.lookupFieldValueInterceptor(field);
                    if (!(interceptor instanceof FieldValueTransformation)) {
                        return null;
                    }
                    FieldValueTransformation transformation = (FieldValueTransformation)interceptor;
                    FieldValueTransformer transformer = transformation.getFieldValueTransformer();
                    if (!(transformer instanceof FieldValueTransformerWithAvailability)) {
                        return null;
                    }
                    transformerWithAvailability = (FieldValueTransformerWithAvailability)transformer;
                    if (!field.isStatic()) break block5;
                    receiver = null;
                    break block6;
                }
                receiver = node.object().asJavaConstant();
                if (!(receiver instanceof ImageHeapConstant)) break block7;
                ImageHeapConstant imageHeapConstant = (ImageHeapConstant)receiver;
                if (field.getDeclaringClass().isAssignableFrom((ResolvedJavaType)imageHeapConstant.getType())) break block6;
            }
            return null;
        }
        return transformerWithAvailability.intrinsify(providers, receiver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JavaConstant readFieldValue(AnalysisField field, JavaConstant receiver) {
        JavaConstant value;
        assert (this.isValueAvailable(field)) : field;
        Object interceptor = this.lookupFieldValueInterceptor(field);
        if (interceptor instanceof FieldValueTransformation) {
            FieldValueTransformation transformation = (FieldValueTransformation)interceptor;
            value = transformation.readValue(field, receiver);
            return FieldValueInterceptionSupport.interceptValue(field, value);
        } else if (!field.getDeclaringClass().isInitialized()) {
            if (!field.isStatic()) throw VMError.shouldNotReachHere("Cannot read instance field of a class that is initialized at run time: " + field.format("%H.%n"));
            JavaConstant constantValue = field.getConstantValue();
            value = constantValue != null ? constantValue : JavaConstant.defaultForKind((JavaKind)field.getJavaKind());
            return FieldValueInterceptionSupport.interceptValue(field, value);
        } else {
            ResolvedJavaField oField = OriginalFieldProvider.getOriginalField((ResolvedJavaField)field);
            if (oField == null) {
                throw VMError.shouldNotReachHere("Cannot read value of field that has no host value: " + field.format("%H.%n"));
            }
            value = GraalAccess.getOriginalProviders().getConstantReflection().readFieldValue(oField, receiver);
        }
        return FieldValueInterceptionSupport.interceptValue(field, value);
    }

    private static JavaConstant interceptValue(AnalysisField field, JavaConstant value) {
        JavaConstant result = value;
        if (result != null) {
            result = FieldValueInterceptionSupport.filterInjectedAccessor(field, result);
            result = FieldValueInterceptionSupport.interceptAssertionStatus(field, result);
            result = FieldValueInterceptionSupport.interceptWordField(field, result);
        }
        return result;
    }

    private static JavaConstant filterInjectedAccessor(AnalysisField field, JavaConstant value) {
        if (field.getAnnotation(InjectAccessors.class) != null) {
            assert (!field.isAccessed());
            return JavaConstant.defaultForKind((JavaKind)value.getJavaKind());
        }
        return value;
    }

    private static JavaConstant interceptAssertionStatus(AnalysisField field, JavaConstant value) {
        if (field.isStatic() && field.isSynthetic() && field.getName().startsWith("$assertionsDisabled")) {
            Class clazz = field.getDeclaringClass().getJavaClass();
            boolean assertionsEnabled = RuntimeAssertionsSupport.singleton().desiredAssertionStatus(clazz);
            return JavaConstant.forBoolean((!assertionsEnabled ? 1 : 0) != 0);
        }
        return value;
    }

    private static JavaConstant interceptWordField(AnalysisField field, JavaConstant value) {
        if (value.getJavaKind() == JavaKind.Object && value.isNull() && field.getType().isWordType()) {
            return JavaConstant.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)0L);
        }
        return value;
    }

    private static FieldValueComputer createFieldValueComputer(AnalysisField field) {
        UnknownObjectField unknownObjectField = (UnknownObjectField)field.getAnnotation(UnknownObjectField.class);
        if (unknownObjectField != null) {
            return new FieldValueComputer((BooleanSupplier)ReflectionUtil.newInstance(unknownObjectField.availability()), FieldValueInterceptionSupport.extractAnnotationTypes(field, unknownObjectField.types(), unknownObjectField.fullyQualifiedTypes()), unknownObjectField.canBeNull());
        }
        UnknownPrimitiveField unknownPrimitiveField = (UnknownPrimitiveField)field.getAnnotation(UnknownPrimitiveField.class);
        if (unknownPrimitiveField != null) {
            return new FieldValueComputer((BooleanSupplier)ReflectionUtil.newInstance(unknownPrimitiveField.availability()), List.of(field.getType().getJavaClass()), false);
        }
        return null;
    }

    private static List<Class<?>> extractAnnotationTypes(AnalysisField field, Class<?>[] types, String[] fullyQualifiedTypes) {
        ArrayList annotationTypes = new ArrayList(Arrays.asList(types));
        for (String annotationTypeName : fullyQualifiedTypes) {
            try {
                Class<?> annotationType = Class.forName(annotationTypeName);
                annotationTypes.add(annotationType);
            }
            catch (ClassNotFoundException e) {
                throw UserError.abort("Specified computed value type not found: " + annotationTypeName, new Object[0]);
            }
        }
        if (annotationTypes.isEmpty()) {
            AnalysisType fieldType = field.getType();
            UserError.guarantee(CustomTypeFieldHandler.isConcreteType(fieldType), "Illegal use of @UnknownObjectField annotation on field %s. The field type must be concrete or the annotation must declare a concrete type.", field);
            annotationTypes.add(fieldType.getJavaClass());
        }
        return annotationTypes;
    }
}

