/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public abstract class ConditionalConfigurationRegistry {
    private Feature.BeforeAnalysisAccess beforeAnalysisAccess;
    private SVMHost hostVM;
    private final Map<Class<?>, Collection<Runnable>> pendingReachabilityHandlers = new ConcurrentHashMap();

    protected void registerConditionalConfiguration(ConfigurationCondition condition, Consumer<ConfigurationCondition> consumer) {
        Objects.requireNonNull(condition, "Cannot use null value as condition for conditional configuration. Please ensure that you register a non-null condition.");
        Objects.requireNonNull(consumer, "Cannot use null value as runnable for conditional configuration. Please ensure that you register a non-null runnable.");
        if (condition.isRuntimeChecked() && !condition.isAlwaysTrue()) {
            ClassInitializationSupport.singleton().addForTypeReachedTracking(condition.getType());
        }
        if (ConfigurationCondition.alwaysTrue().equals((Object)condition)) {
            consumer.accept(ConfigurationCondition.alwaysTrue());
        } else {
            ConfigurationCondition runtimeCondition = condition.isRuntimeChecked() ? condition : ConfigurationCondition.alwaysTrue();
            if (this.beforeAnalysisAccess == null) {
                Collection handlers = this.pendingReachabilityHandlers.computeIfAbsent(condition.getType(), key -> new ConcurrentLinkedQueue());
                handlers.add(() -> consumer.accept(runtimeCondition));
            } else {
                this.beforeAnalysisAccess.registerReachabilityHandler(access -> consumer.accept(runtimeCondition), new Object[]{condition.getType()});
            }
        }
    }

    public void setAnalysisAccess(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        VMError.guarantee(this.beforeAnalysisAccess == null, "Analysis access can be set only once.");
        this.beforeAnalysisAccess = Objects.requireNonNull(beforeAnalysisAccess);
        for (Map.Entry<Class<?>, Collection<Runnable>> reachabilityEntry : this.pendingReachabilityHandlers.entrySet()) {
            this.beforeAnalysisAccess.registerReachabilityHandler(access -> ((Collection)reachabilityEntry.getValue()).forEach(Runnable::run), new Object[]{reachabilityEntry.getKey()});
        }
        this.pendingReachabilityHandlers.clear();
    }

    public void setHostVM(SVMHost hostVM) {
        this.hostVM = hostVM;
    }

    public SVMHost getHostVM() {
        return this.hostVM;
    }
}

