/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.windows.WindowsVMCondition;
import com.oracle.svm.core.windows.WindowsVMMutex;
import com.oracle.svm.core.windows.WindowsVMSemaphore;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton(value={VMLockSupport.class})
public final class WindowsVMLockSupport
extends VMLockSupport {
    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected VMMutex replaceVMMutex(VMMutex source) {
        return new WindowsVMMutex(source.getName());
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected VMCondition replaceVMCondition(VMCondition source) {
        return new WindowsVMCondition((WindowsVMMutex)this.mutexReplacer.apply(source.getMutex()));
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected VMSemaphore replaceSemaphore(VMSemaphore source) {
        return new WindowsVMSemaphore(source.getName());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void checkResult(int result, String functionName) {
        if (result == 0) {
            WindowsVMLockSupport.fatalError(functionName);
        }
    }

    @Uninterruptible(reason="Error handling is interruptible.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    static void fatalError(String functionName) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        int lastError = WinBase.GetLastError();
        Log.log().string(functionName).string(" failed with error ").hex(lastError).newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }
}

