/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.util.ConcurrentIdentityHashMap;
import com.oracle.svm.core.util.LayeredHostedImageHeapMapCollector;
import com.oracle.svm.core.util.LayeredImageHeapMap;
import com.oracle.svm.core.util.LayeredImageHeapMapStore;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicMapWrap;
import org.graalvm.collections.Equivalence;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class ImageHeapMap {
    private ImageHeapMap() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <K, V> EconomicMap<K, V> create(String key) {
        return ImageHeapMap.create(Equivalence.DEFAULT, key);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <K, V> EconomicMap<K, V> createNonLayeredMap() {
        return ImageHeapMap.createNonLayeredMap(Equivalence.DEFAULT);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <K, V> EconomicMap<K, V> create(Equivalence strategy, String key) {
        assert (key != null) : "The key should not be null if the map needs to be automatically layered";
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished(), "Trying to create an ImageHeapMap after analysis.");
        return HostedImageHeapMap.create(strategy, key, true);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <K, V> EconomicMap<K, V> createNonLayeredMap(Equivalence strategy) {
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished(), "Trying to create an ImageHeapMap after analysis.");
        return HostedImageHeapMap.create(strategy, null, false);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class HostedImageHeapMap<K, V>
    extends EconomicMapWrap<K, V> {
        private final EconomicMap<Object, Object> currentLayerMap;
        private final EconomicMap<Object, Object> runtimeMap;

        public HostedImageHeapMap(Map<K, V> hostedMap, EconomicMap<Object, Object> currentLayerMap, EconomicMap<Object, Object> runtimeMap) {
            super(hostedMap);
            this.currentLayerMap = currentLayerMap;
            this.runtimeMap = runtimeMap;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public EconomicMap<Object, Object> getCurrentLayerMap() {
            return this.currentLayerMap;
        }

        public EconomicMap<Object, Object> getRuntimeMap() {
            return this.runtimeMap;
        }

        public static <K, V> HostedImageHeapMap<K, V> create(Equivalence strategy, String key, boolean needLayeredMap) {
            ConcurrentMap hostedMap = strategy == Equivalence.IDENTITY ? new ConcurrentIdentityHashMap() : new ConcurrentHashMap();
            EconomicMap currentLayerMap = EconomicMap.create((Equivalence)strategy);
            if (!needLayeredMap || !ImageLayerBuildingSupport.buildingImageLayer()) {
                return new HostedImageHeapMap(hostedMap, (EconomicMap<Object, Object>)currentLayerMap, (EconomicMap<Object, Object>)currentLayerMap);
            }
            LayeredImageHeapMap<Object, Object> runtimeMap = new LayeredImageHeapMap<Object, Object>(strategy, key);
            EconomicMap<Object, Object> previousMap = LayeredImageHeapMapStore.currentLayer().getImageHeapMapStore().put(key, (EconomicMap<Object, Object>)currentLayerMap);
            if (previousMap != null) {
                throw VMError.shouldNotReachHere("The LayeredImageHeapMap with key %s was added twice", key);
            }
            HostedImageHeapMap hostedImageHeapMap = new HostedImageHeapMap(hostedMap, (EconomicMap<Object, Object>)currentLayerMap, runtimeMap);
            LayeredHostedImageHeapMapCollector singleton = LayeredHostedImageHeapMapCollector.singleton();
            if (ImageLayerBuildingSupport.buildingExtensionLayer() && singleton.isMapKeyReachableInPreviousLayer(key)) {
                singleton.registerPreviousLayerHostedImageHeapMap(hostedImageHeapMap);
            }
            return hostedImageHeapMap;
        }
    }
}

