/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.RecurringCallbackSupport;
import com.oracle.svm.core.thread.SafepointSlowpath;
import com.oracle.svm.core.thread.VMThreads;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import org.graalvm.word.LocationIdentity;

public class ThreadStatusTransition {
    public static void fromJavaToNative() {
        ReplacementsUtil.dynamicAssert((boolean)VMThreads.StatusSupport.isStatusJava(), (String)"Thread status must be 'Java'.");
        VMThreads.StatusSupport.setStatusNative();
    }

    public static void fromNativeToJava(boolean popFrameAnchor) {
        VMThreads.StatusSupport.assertStatusNativeOrSafepoint();
        int newStatus = 1;
        if (BranchProbabilityNode.probability((double)0.999, (!VMThreads.ActionOnTransitionToJavaSupport.isActionPending() ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999, (!RecurringCallbackSupport.needsNativeToJavaSlowpath() ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999, (boolean)VMThreads.StatusSupport.compareAndSetNativeToNewStatus(newStatus))) {
            if (popFrameAnchor) {
                JavaFrameAnchors.popFrameAnchor();
            }
        } else {
            ThreadStatusTransition.callSlowPathNativeToNewStatus(SafepointSlowpath.ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS, newStatus, popFrameAnchor);
        }
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.NONE, (LocationIdentity)LocationIdentity.ANY_LOCATION);
    }

    @Uninterruptible(reason="Must not contain safepoint checks")
    public static boolean tryFromNativeToVM() {
        VMThreads.StatusSupport.assertStatusNativeOrSafepoint();
        return VMThreads.StatusSupport.compareAndSetNativeToNewStatus(4);
    }

    @Uninterruptible(reason="Must not contain safepoint checks")
    public static void fromNativeToVM() {
        boolean needSlowPath;
        VMThreads.StatusSupport.assertStatusNativeOrSafepoint();
        int newStatus = 4;
        boolean bl = needSlowPath = !VMThreads.StatusSupport.compareAndSetNativeToNewStatus(newStatus);
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)needSlowPath)) {
            ThreadStatusTransition.callSlowPathNativeToNewStatus(SafepointSlowpath.ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS, newStatus, false);
        }
    }

    @Uninterruptible(reason="Must not contain safepoint checks")
    public static void fromVMToJava(boolean popFrameAnchor) {
        boolean needSlowPath;
        VMThreads.StatusSupport.assertStatusVM();
        VMThreads.StatusSupport.setStatusJavaUnguarded();
        if (popFrameAnchor) {
            JavaFrameAnchors.popFrameAnchor();
        }
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)(needSlowPath = VMThreads.ActionOnTransitionToJavaSupport.isActionPending()))) {
            ThreadStatusTransition.callRunPendingActions(SafepointSlowpath.SLOW_PATH_RUN_PENDING_ACTIONS);
        }
    }

    @Uninterruptible(reason="Must not contain safepoint checks")
    public static void fromJavaToVM() {
        VMThreads.StatusSupport.assertStatusJava();
        VMThreads.StatusSupport.setStatusVM();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void fromVMToNative() {
        VMThreads.StatusSupport.assertStatusVM();
        VMThreads.StatusSupport.setStatusNative();
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callRunPendingActions(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPathNativeToNewStatus(@Node.ConstantNodeParameter ForeignCallDescriptor var0, int var1, boolean var2);
}

