/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.imagelayer.LastImageBuildPredicate;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.layeredimagesingleton.ApplicationLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_ThreadGroup;
import com.oracle.svm.core.thread.Target_java_lang_ThreadLocal;
import com.oracle.svm.core.thread.Target_java_lang_ThreadLocal_ThreadLocalMap;
import com.oracle.svm.core.thread.Target_java_lang_Thread_FieldHolder;
import com.oracle.svm.core.thread.Target_java_lang_VirtualThread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.util.ReflectionUtil;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.Pointer;

public final class JavaThreads {
    static final FastThreadLocalLong currentVThreadId = (FastThreadLocalLong)FastThreadLocalFactory.createLong("JavaThreads.currentVThreadId").setMaxOffset(127);

    private JavaThreads() {
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Thread fromTarget(Target_java_lang_Thread thread) {
        return (Thread)Thread.class.cast(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Target_java_lang_Thread toTarget(Thread thread) {
        return (Target_java_lang_Thread)Target_java_lang_Thread.class.cast(thread);
    }

    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    static long nextThreadID() {
        return JavaThreadNumberSingleton.singleton().threadSeqNumber.incrementAndGet();
    }

    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    static int nextThreadNum() {
        return JavaThreadNumberSingleton.singleton().threadInitNumber.incrementAndGet();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getThreadId(Thread thread) {
        if (SubstrateUtil.HOSTED) {
            return (Long)ReflectionUtil.readField(Thread.class, (String)"tid", (Object)thread);
        }
        return JavaThreads.toTarget((Thread)thread).tid;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static ThreadGroup getRawThreadGroup(Thread thread) {
        Target_java_lang_Thread t = SubstrateUtil.cast(thread, Target_java_lang_Thread.class);
        Target_java_lang_Thread_FieldHolder holder = t.holder;
        if (holder != null) {
            return holder.group;
        }
        return null;
    }

    public static boolean isInterrupted(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).interrupted;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getParentThreadId(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).parentThreadId;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isVirtual(Thread thread) {
        return Target_java_lang_VirtualThread.class.isInstance(thread);
    }

    public static boolean isCurrentThreadVirtual() {
        Thread thread = PlatformThreads.currentThread.get();
        return thread != null && JavaThreads.toTarget((Thread)thread).vthread != null;
    }

    @NeverInline(value="Prevent a reference to the current carrier thread from leaking into the caller frame.")
    public static boolean isCurrentThreadVirtualAndPinned() {
        Target_java_lang_Thread carrier = JavaThreads.toTarget(Target_java_lang_Thread.currentCarrierThread());
        return carrier != null && carrier.vthread != null && Target_jdk_internal_vm_Continuation.isPinned(carrier.cont.getScope());
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Target_java_lang_ThreadGroup toTarget(ThreadGroup threadGroup) {
        return (Target_java_lang_ThreadGroup)Target_java_lang_ThreadGroup.class.cast(threadGroup);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    public static Target_java_lang_VirtualThread toVirtualTarget(Thread thread) {
        return (Target_java_lang_VirtualThread)Target_java_lang_VirtualThread.class.cast(thread);
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    public static StackTraceElement[] getStackTrace(boolean filterExceptions, Thread thread) {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        if (JavaThreads.isVirtual(thread)) {
            if (thread == Thread.currentThread()) {
                return JavaThreads.getMountedVirtualThreadStackTrace(filterExceptions, thread, callerSP);
            }
            assert (!filterExceptions) : "exception stack traces can be taken only for the current thread";
            return JavaThreads.asyncGetVirtualThreadStackTrace(JavaThreads.toVirtualTarget(thread));
        }
        return PlatformThreads.getStackTrace(filterExceptions, thread, callerSP);
    }

    private static StackTraceElement[] getMountedVirtualThreadStackTrace(boolean filterExceptions, Thread thread, Pointer callerSP) {
        Thread carrier = JavaThreads.toVirtualTarget((Thread)thread).carrierThread;
        if (carrier == null) {
            return null;
        }
        Pointer endSP = PlatformThreads.getCarrierSPOrElse(carrier, (Pointer)Word.nullPointer());
        if (endSP.isNull()) {
            return null;
        }
        if (carrier == PlatformThreads.currentThread.get()) {
            return StackTraceUtils.getCurrentThreadStackTrace(filterExceptions, callerSP, endSP);
        }
        assert (VMOperation.isInProgressAtSafepoint());
        return StackTraceUtils.getStackTraceAtSafepoint(PlatformThreads.getIsolateThread(carrier), endSP);
    }

    public static StackTraceElement[] getStackTraceAtSafepoint(Thread thread, Pointer callerSP) {
        if (JavaThreads.isVirtual(thread)) {
            return JavaThreads.getMountedVirtualThreadStackTrace(false, thread, callerSP);
        }
        return PlatformThreads.getStackTraceAtSafepoint(thread, callerSP);
    }

    private static StackTraceElement[] asyncGetVirtualThreadStackTrace(Target_java_lang_VirtualThread thread) {
        StackTraceElement[] stackTrace;
        do {
            if ((stackTrace = thread.carrierThread != null ? StackTraceUtils.asyncGetStackTrace(SubstrateUtil.cast(thread, Thread.class)) : thread.tryGetStackTrace()) != null) continue;
            Thread.yield();
        } while (stackTrace == null);
        return stackTrace;
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    public static void visitCurrentStackFrames(StackFrameVisitor visitor) {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        if (JavaThreads.isVirtual(Thread.currentThread())) {
            JavaThreads.visitCurrentVirtualThreadStackFrames(callerSP, visitor);
        } else {
            PlatformThreads.visitCurrentStackFrames(callerSP, visitor);
        }
    }

    private static void visitCurrentVirtualThreadStackFrames(Pointer callerSP, StackFrameVisitor visitor) {
        Pointer endSP;
        Thread carrier = JavaThreads.toVirtualTarget((Thread)Thread.currentThread()).carrierThread;
        if (carrier != null && (endSP = PlatformThreads.getCarrierSPOrElse(carrier, (Pointer)Word.nullPointer())).isNonNull()) {
            StackTraceUtils.visitCurrentThreadStackFrames(callerSP, endSP, visitor);
        }
    }

    public static void dispatchUncaughtException(Thread thread, Throwable throwable) {
        try {
            Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
            if (handler == null) {
                handler = Thread.getDefaultUncaughtExceptionHandler();
            }
            if (handler != null) {
                handler.uncaughtException(thread, throwable);
            } else {
                System.err.print("Exception in thread \"" + thread.getName() + "\" ");
                throwable.printStackTrace(System.err);
            }
        }
        catch (Throwable e) {
            Log.log().newline().string("Exception: ").string(e.getClass().getName()).string(" thrown from the UncaughtExceptionHandler in thread \"").string(thread.getName()).string("\"").newline();
        }
    }

    static void initThreadFields(Target_java_lang_Thread tjlt, ThreadGroup group, Runnable target, long stackSize, int priority, boolean daemon) {
        assert (tjlt.holder == null);
        tjlt.holder = new Target_java_lang_Thread_FieldHolder(group, target, stackSize, priority, daemon);
    }

    static void initNewThreadLocalsAndLoader(Target_java_lang_Thread tjlt, boolean inheritThreadLocals, Thread parent) {
        if (inheritThreadLocals) {
            Target_java_lang_ThreadLocal_ThreadLocalMap parentMap = JavaThreads.toTarget((Thread)parent).inheritableThreadLocals;
            if (parentMap != null && parentMap.size() > 0) {
                tjlt.inheritableThreadLocals = Target_java_lang_ThreadLocal.createInheritedMap(parentMap);
            }
            tjlt.contextClassLoader = parent.getContextClassLoader();
        } else {
            tjlt.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setCurrentThreadLockHelper(Object helper) {
        JavaThreads.toTarget((Thread)Thread.currentThread()).lockHelper = helper;
    }

    @AlwaysInline(value="Locking fast path.")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Object getCurrentThreadLockHelper() {
        return JavaThreads.toTarget((Thread)Thread.currentThread()).lockHelper;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getCurrentThreadId() {
        long id = currentVThreadId.get();
        if (GraalDirectives.inIntrinsic()) {
            if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
                ReplacementsUtil.dynamicAssert((id != 0L && id == JavaThreads.getThreadId(Thread.currentThread()) ? 1 : 0) != 0, (String)"ids must match");
            }
        } else assert (id != 0L && id == JavaThreads.getThreadId(Thread.currentThread()));
        return id;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getCurrentThreadIdOrZero() {
        if (CurrentIsolate.getCurrentThread().isNonNull()) {
            return currentVThreadId.get();
        }
        return 0L;
    }

    @Uninterruptible(reason="Ensure consistency of vthread and cached vthread id.")
    static void setCurrentThread(Thread carrier, Thread thread) {
        assert (carrier == PlatformThreads.currentThread.get());
        assert (thread == carrier || JavaThreads.isVirtual(thread));
        JavaThreads.toTarget((Thread)carrier).vthread = thread != carrier ? thread : null;
        currentVThreadId.set(JavaThreads.getThreadId(thread));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Thread getCurrentThreadOrNull() {
        Thread thread = PlatformThreads.currentThread.get();
        if (thread == null) {
            return null;
        }
        Target_java_lang_Thread tjlt = SubstrateUtil.cast(thread, Target_java_lang_Thread.class);
        return tjlt.vthread != null ? tjlt.vthread : thread;
    }

    @AutomaticallyRegisteredImageSingleton(onlyWith={LastImageBuildPredicate.class})
    public static class JavaThreadNumberSingleton
    implements ApplicationLayerOnlyImageSingleton,
    UnsavedSingleton {
        final AtomicLong threadSeqNumber = new AtomicLong();
        final AtomicInteger threadInitNumber = new AtomicInteger();

        public static JavaThreadNumberSingleton singleton() {
            return (JavaThreadNumberSingleton)ImageSingletons.lookup(JavaThreadNumberSingleton.class);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public void setThreadNumberInfo(long seqNumber, int initNumber) {
            this.threadSeqNumber.set(seqNumber);
            this.threadInitNumber.set(initNumber);
        }

        @Override
        public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
            return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
        }
    }
}

