/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.stack.InspectedFrame;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

class SubstrateInspectedFrame
implements InspectedFrame {
    private final Pointer sp;
    private final CodePointer ip;
    protected DeoptimizedFrame.VirtualFrame virtualFrame;
    private final CodeInfoQueryResult codeInfo;
    private FrameInfoQueryResult frameInfo;
    private final int virtualFrameIndex;
    private final JavaConstant[] locals;
    private Deoptimizer deoptimizer;

    SubstrateInspectedFrame(Pointer sp, CodePointer ip, DeoptimizedFrame.VirtualFrame virtualFrame, CodeInfoQueryResult codeInfo, FrameInfoQueryResult frameInfo, int virtualFrameIndex) {
        this.sp = sp;
        this.ip = ip;
        this.virtualFrame = virtualFrame;
        this.codeInfo = codeInfo;
        this.frameInfo = virtualFrame != null ? virtualFrame.getFrameInfo() : frameInfo;
        this.virtualFrameIndex = virtualFrameIndex;
        this.locals = new JavaConstant[this.frameInfo.getNumLocals()];
    }

    private Deoptimizer getDeoptimizer() {
        assert (this.virtualFrame == null);
        if (this.deoptimizer == null) {
            this.deoptimizer = new Deoptimizer(this.sp, this.codeInfo, CurrentIsolate.getCurrentThread(), CurrentIsolate.getCurrentThread());
        }
        return this.deoptimizer;
    }

    private void checkLocalIndex(int index) {
        if (index < 0 || index >= this.frameInfo.getNumLocals()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public Object getLocal(int index) {
        JavaConstant result = this.getLocalConstant(index);
        if (result.getJavaKind() != JavaKind.Object) {
            throw new IllegalArgumentException("Can only access Object local variables for now: " + String.valueOf(result.getJavaKind()));
        }
        return SubstrateObjectConstant.asObject(Object.class, result);
    }

    private JavaConstant getLocalConstant(int index) {
        JavaConstant result;
        this.checkDeoptimized();
        this.checkLocalIndex(index);
        if (this.virtualFrame != null) {
            result = this.virtualFrame.getConstant(index);
            assert (this.locals[index] == null || this.locals[index].equals((Object)result)) : "value before and after deoptimization must be equal";
        } else {
            result = this.locals[index];
            if (result == null) {
                this.locals[index] = result = this.getDeoptimizer().getDeoptState().readLocalVariable(index, this.frameInfo);
            }
        }
        return result;
    }

    public boolean isVirtual(int index) {
        this.checkDeoptimized();
        this.checkLocalIndex(index);
        if (this.virtualFrame == null) {
            FrameInfoQueryResult.ValueInfo[] valueInfos = this.frameInfo.getValueInfos();
            if (index >= valueInfos.length) {
                return false;
            }
            if (valueInfos[index].getType() == FrameInfoQueryResult.ValueType.VirtualObject) {
                return true;
            }
        }
        return false;
    }

    public boolean hasVirtualObjects() {
        this.checkDeoptimized();
        if (this.virtualFrame == null) {
            FrameInfoQueryResult.ValueInfo[] valueInfos = this.frameInfo.getValueInfos();
            for (int i = 0; i < valueInfos.length; ++i) {
                if (valueInfos[i].getType() != FrameInfoQueryResult.ValueType.VirtualObject) continue;
                return true;
            }
        }
        return false;
    }

    private void checkDeoptimized() {
        if (this.virtualFrame == null) {
            this.virtualFrame = this.lookupVirtualFrame();
            if (this.virtualFrame != null) {
                this.frameInfo = this.virtualFrame.getFrameInfo();
                this.deoptimizer = null;
            }
        } else assert (this.virtualFrame == this.lookupVirtualFrame());
    }

    private DeoptimizedFrame.VirtualFrame lookupVirtualFrame() {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkEagerDeoptimized(thread, this.sp);
        if (deoptimizedFrame != null) {
            DeoptimizedFrame.VirtualFrame cur = deoptimizedFrame.getTopFrame();
            for (int i = 0; i < this.virtualFrameIndex; ++i) {
                cur = cur.getCaller();
            }
            return cur;
        }
        return null;
    }

    public void materializeVirtualObjects(boolean invalidateCode) {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        if (this.virtualFrame == null) {
            DeoptimizedFrame deoptimizedFrame = this.getDeoptimizer().deoptimizeEagerly();
            assert (deoptimizedFrame == Deoptimizer.checkEagerDeoptimized(thread, this.sp));
        }
        if (invalidateCode) {
            Deoptimizer.invalidateMethodOfFrame(thread, this.sp, null);
        }
        assert (this.lookupVirtualFrame() != null) : "must be deoptimized now";
        this.checkDeoptimized();
    }

    public int getBytecodeIndex() {
        this.checkDeoptimized();
        return this.frameInfo.getBci();
    }

    public ResolvedJavaMethod getMethod() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isMethod(ResolvedJavaMethod method) {
        this.checkDeoptimized();
        return ((SharedMethod)method).getImageCodeDeoptOffset() == this.frameInfo.getDeoptMethodOffset();
    }

    public String toString() {
        this.checkDeoptimized();
        StringBuilder result = new StringBuilder();
        StackTraceElement sourceReference = this.frameInfo.getSourceReference();
        result.append(sourceReference != null ? sourceReference.toString() : "[method name not available]");
        result.append("  bci: ").append(this.frameInfo.getBci());
        if (this.virtualFrame != null) {
            result.append("  [deoptimized]");
        }
        result.append("  sp: 0x").append(Long.toHexString(this.sp.rawValue()));
        result.append("  ip: 0x").append(Long.toHexString(this.ip.rawValue()));
        if (this.frameInfo.getDeoptMethodOffset() != 0) {
            result.append("  deoptTarget: 0x").append(Long.toHexString(this.frameInfo.getDeoptMethodAddress().rawValue()));
        }
        for (int i = 0; i < this.frameInfo.getNumLocals(); ++i) {
            JavaConstant con = this.getLocalConstant(i);
            if (con.getJavaKind() == JavaKind.Illegal) continue;
            result.append(System.lineSeparator()).append("    local ").append(i);
            if (con.getJavaKind() == JavaKind.Object) {
                Object val;
                if (this.isVirtual(i)) {
                    result.append("  [virtual object]");
                }
                if ((val = SubstrateObjectConstant.asObject((Constant)con)) == null) {
                    result.append("  null");
                    continue;
                }
                result.append("  class: ").append(val.getClass().getName());
                result.append("  address: 0x").append(Long.toHexString(Word.objectToUntrackedPointer((Object)val).rawValue()));
                continue;
            }
            result.append("  kind: ").append(con.getJavaKind().toString());
            if (!con.getJavaKind().isNumericInteger()) continue;
            result.append("  value: ").append(con.asLong());
        }
        return result.toString();
    }
}

