/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class JavaFrameAnchors {
    static final SnippetRuntime.SubstrateForeignCallDescriptor VERIFY_FRAME_ANCHOR_STUB = SnippetRuntime.findForeignCall(JavaFrameAnchors.class, "verifyFrameAnchorStub", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    private static final FastThreadLocalWord<JavaFrameAnchor> lastAnchorTL = (FastThreadLocalWord)FastThreadLocalFactory.createWord("JavaFrameAnchors.lastAnchor").setMaxOffset(127);
    private static final FastThreadLocalInt verificationInProgressTL = FastThreadLocalFactory.createInt("JavaFrameAnchors.verificationInProgress");

    public static void pushFrameAnchor(JavaFrameAnchor newAnchor) {
        if (SubstrateOptions.VerifyFrameAnchors.getValue().booleanValue()) {
            newAnchor.setMagicBefore(-81985529216486896L);
            newAnchor.setMagicAfter(-81985529216486896L);
        }
        newAnchor.setLastJavaIP((CodePointer)Word.nullPointer());
        newAnchor.setLastJavaSP((Pointer)Word.nullPointer());
        JavaFrameAnchor prev = lastAnchorTL.get();
        newAnchor.setPreviousAnchor(prev);
        lastAnchorTL.set(newAnchor);
        JavaFrameAnchors.verifyFrameAnchor(true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void popFrameAnchor() {
        JavaFrameAnchors.verifyFrameAnchor(false);
        JavaFrameAnchor cur = lastAnchorTL.get();
        JavaFrameAnchor prev = cur.getPreviousAnchor();
        lastAnchorTL.set(prev);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor getFrameAnchor() {
        return lastAnchorTL.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor getFrameAnchor(IsolateThread thread) {
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
        return lastAnchorTL.get(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void verifyFrameAnchor(boolean newAnchor) {
        if (SubstrateOptions.VerifyFrameAnchors.getValue().booleanValue()) {
            JavaFrameAnchors.call(VERIFY_FRAME_ANCHOR_STUB, newAnchor);
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void verifyFrameAnchorStub(boolean newAnchor) {
        if (verificationInProgressTL.get() != 0 || SubstrateDiagnostics.isFatalErrorHandlingThread()) {
            return;
        }
        verificationInProgressTL.set(verificationInProgressTL.get() + 1);
        try {
            JavaFrameAnchor cur = lastAnchorTL.get();
            JavaFrameAnchors.verifyFrameAnchor(cur, newAnchor);
            JavaFrameAnchor prev = cur.getPreviousAnchor();
            if (prev.isNonNull()) {
                JavaFrameAnchors.verifyFrameAnchor(prev, false);
            }
        }
        finally {
            verificationInProgressTL.set(verificationInProgressTL.get() - 1);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void verifyTopFrameAnchor(Pointer safeStackBegin) {
        Pointer anchor = (Pointer)JavaFrameAnchors.getFrameAnchor();
        if (anchor.isNonNull()) {
            VMError.guarantee(anchor.aboveOrEqual((UnsignedWord)safeStackBegin), "The frame anchor struct is outside of the stack that is safe to use.");
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void verifyFrameAnchor(JavaFrameAnchor cur, boolean newAnchor) {
        VMError.guarantee(VMThreads.StatusSupport.getStatusVolatile() == 1, "Invalid thread status.");
        if (((Pointer)cur).belowThan((UnsignedWord)KnownIntrinsics.readStackPointer())) {
            throw JavaFrameAnchors.verificationFailed(cur, "The frame anchor struct is outside of the used stack.");
        }
        if (cur.getMagicBefore() != -81985529216486896L) {
            throw JavaFrameAnchors.verificationFailed(cur, "Magic number at the start of the frame anchor is corrupt.");
        }
        if (cur.getMagicAfter() != -81985529216486896L) {
            throw JavaFrameAnchors.verificationFailed(cur, "Magic number at the end of the frame anchor is corrupt.");
        }
        if (newAnchor != cur.getLastJavaIP().isNull()) {
            throw JavaFrameAnchors.verificationFailed(cur, "Invalid IP");
        }
        if (newAnchor != cur.getLastJavaSP().isNull()) {
            throw JavaFrameAnchors.verificationFailed(cur, "Invalid SP");
        }
    }

    @Uninterruptible(reason="No need to be uninterruptible because we are terminating with a fatal error.", calleeMustBe=false)
    private static RuntimeException verificationFailed(JavaFrameAnchor cur, String msg) {
        Log log = Log.log();
        log.string("Frame anchor verification failed: ").string(msg).newline();
        log.string("Anchor ").zhex((WordBase)cur).string(" MagicBefore ").zhex(cur.getMagicBefore()).string(" LastJavaSP ").zhex((WordBase)cur.getLastJavaSP()).string(" LastJavaIP ").zhex((WordBase)cur.getLastJavaIP()).string(" Previous ").zhex((WordBase)cur.getPreviousAnchor()).string(" MagicAfter ").zhex(cur.getMagicAfter()).newline();
        throw VMError.shouldNotReachHere(msg);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void call(@Node.ConstantNodeParameter ForeignCallDescriptor var0, boolean var1);
}

