/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.sampler.AbstractJfrExecutionSampler;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

public abstract class SubstrateSigprofHandler
extends AbstractJfrExecutionSampler
implements IsolateListenerSupport.IsolateListener {
    private static final CGlobalData<Pointer> SIGNAL_HANDLER_ISOLATE = CGlobalDataFactory.createWord();
    private PlatformThreads.ThreadLocalKey keyForNativeThreadLocal;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SubstrateSigprofHandler() {
    }

    @Fold
    public static SubstrateSigprofHandler singleton() {
        return (SubstrateSigprofHandler)ImageSingletons.lookup(SubstrateSigprofHandler.class);
    }

    @Override
    @Uninterruptible(reason="Thread state not set up yet.")
    public void afterCreateIsolate(Isolate isolate) {
        this.keyForNativeThreadLocal = PlatformThreads.singleton().createUnmanagedThreadLocal();
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public void onIsolateTeardown() {
        PlatformThreads.ThreadLocalKey oldKey = this.keyForNativeThreadLocal;
        this.keyForNativeThreadLocal = (PlatformThreads.ThreadLocalKey)Word.nullPointer();
        PlatformThreads.singleton().deleteUnmanagedThreadLocal(oldKey);
    }

    @Override
    protected void startSampling() {
        assert (VMOperation.isInProgressAtSafepoint());
        assert (SubstrateSigprofHandler.getSignalHandlerIsolate().isNull());
        SubstrateJVM.getSamplerBufferPool().adjustBufferCount();
        SubstrateSigprofHandler.setSignalHandlerIsolate(CurrentIsolate.getIsolate());
        this.installSignalHandler();
        IsolateThread thread = VMThreads.firstThread();
        while (thread.isNonNull()) {
            SubstrateSigprofHandler.install(thread);
            thread = VMThreads.nextThread(thread);
        }
    }

    @Override
    protected void stopSampling() {
        assert (VMOperation.isInProgressAtSafepoint());
        assert (SubstrateSigprofHandler.getSignalHandlerIsolate().isNonNull());
        IsolateThread thread = VMThreads.firstThread();
        while (thread.isNonNull()) {
            this.uninstall(thread);
            thread = VMThreads.nextThread(thread);
        }
        this.uninstallSignalHandler();
        this.disallowThreadsInSamplerCode();
        try {
            SubstrateSigprofHandler.setSignalHandlerIsolate((Isolate)Word.nullPointer());
        }
        finally {
            this.allowThreadsInSamplerCode();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Isolate getSignalHandlerIsolate() {
        return (Isolate)SIGNAL_HANDLER_ISOLATE.get().readWord(0);
    }

    private static void setSignalHandlerIsolate(Isolate isolate) {
        assert (SubstrateSigprofHandler.getSignalHandlerIsolate().isNull() || isolate.isNull());
        SIGNAL_HANDLER_ISOLATE.get().writeWord(0, (WordBase)isolate);
    }

    @Override
    public void beforeThreadRun() {
        this.beforeThreadRun0();
    }

    @Uninterruptible(reason="Prevent VM operations that modify the global or thread-local execution sampler state.")
    private void beforeThreadRun0() {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        if (this.isSampling()) {
            SubstrateJVM.getSamplerBufferPool().adjustBufferCount();
            SubstrateSigprofHandler.install(thread);
        }
        this.storeIsolateThreadInNativeThreadLocal(thread);
    }

    protected abstract void installSignalHandler();

    protected void uninstallSignalHandler() {
    }

    protected abstract void install0(IsolateThread var1);

    protected abstract void uninstall0(IsolateThread var1);

    @Uninterruptible(reason="Prevent VM operations that modify thread-local execution sampler state.")
    private static void install(IsolateThread thread) {
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
        if (AbstractJfrExecutionSampler.ExecutionSamplerInstallation.isAllowed(thread)) {
            AbstractJfrExecutionSampler.ExecutionSamplerInstallation.installed(thread);
            SubstrateSigprofHandler.singleton().install0(thread);
        }
    }

    @Override
    @Uninterruptible(reason="Prevent VM operations that modify thread-local execution sampler state.")
    protected void uninstall(IsolateThread thread) {
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
        if (AbstractJfrExecutionSampler.ExecutionSamplerInstallation.isInstalled(thread)) {
            this.storeIsolateThreadInNativeThreadLocal((IsolateThread)Word.nullPointer());
            AbstractJfrExecutionSampler.ExecutionSamplerInstallation.uninstalled(thread);
            this.uninstall0(thread);
        }
    }

    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    protected static boolean tryEnterIsolate() {
        Isolate isolate = SubstrateSigprofHandler.getSignalHandlerIsolate();
        if (isolate.isNull()) {
            return false;
        }
        CEntryPointSnippets.initBaseRegisters(Isolates.getHeapBase(isolate));
        PlatformThreads.ThreadLocalKey key = SubstrateSigprofHandler.singleton().keyForNativeThreadLocal;
        IsolateThread thread = (IsolateThread)PlatformThreads.singleton().getUnmanagedThreadLocalValue(key);
        if (thread.isNull()) {
            return false;
        }
        WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void storeIsolateThreadInNativeThreadLocal(IsolateThread isolateThread) {
        PlatformThreads.singleton().setUnmanagedThreadLocalValue(this.keyForNativeThreadLocal, (WordBase)isolateThread);
    }

    public static class Options {
        public static final RuntimeOptionKey<Boolean> JfrBasedExecutionSamplerStatistics = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }
}

