/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.nodes.LoadMethodByIndexNode;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.reflect.MethodAccessorJDK19;
import com.oracle.svm.core.reflect.ReflectionAccessorHolder;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import jdk.internal.reflect.MethodAccessor;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

@InternalVMMethod
public final class SubstrateMethodAccessor
extends SubstrateAccessor
implements MethodAccessor,
MethodAccessorJDK19 {
    public static final int VTABLE_INDEX_STATICALLY_BOUND = -1;
    public static final int VTABLE_INDEX_NOT_YET_COMPUTED = -2;
    public static final int INTERFACE_TYPEID_CLASS_TABLE = -1;
    public static final int INTERFACE_TYPEID_NOT_YET_COMPUTED = -559087615;
    public static final int INTERFACE_TYPEID_UNNEEDED = -3;
    private final Class<?> receiverType;
    private int vtableIndex;
    private int interfaceTypeID;
    private final boolean callerSensitiveAdapter;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateMethodAccessor(Executable member, Class<?> receiverType, CFunctionPointer expandSignature, CFunctionPointer directTarget, ResolvedJavaMethod targetMethod, int vtableIndex, DynamicHub initializeBeforeInvoke, boolean callerSensitiveAdapter) {
        super(member, expandSignature, directTarget, targetMethod, initializeBeforeInvoke);
        this.receiverType = receiverType;
        this.vtableIndex = vtableIndex;
        this.interfaceTypeID = -559087615;
        this.callerSensitiveAdapter = callerSensitiveAdapter;
    }

    public int getVTableIndex() {
        return this.vtableIndex;
    }

    public int getInterfaceTypeID() {
        return this.interfaceTypeID;
    }

    private void preInvoke(Object obj) {
        if (this.initializeBeforeInvoke != null) {
            EnsureClassInitializedNode.ensureClassInitialized(DynamicHub.toClass(this.initializeBeforeInvoke));
        }
        if (this.receiverType != null) {
            if (obj == null) {
                throw new NullPointerException();
            }
            if (!this.receiverType.isInstance(obj)) {
                throw new IllegalArgumentException("Receiver type " + obj.getClass().getTypeName() + " is not an instance of the declaring class " + this.receiverType.getTypeName());
            }
        }
    }

    private CFunctionPointer invokeTarget(Object obj) {
        VMError.guarantee(this.vtableIndex != -2 && this.interfaceTypeID != -559087615, "Missed recomputation at image build time");
        if (this.vtableIndex == -1) {
            return this.directTarget;
        }
        return (CFunctionPointer)LoadMethodByIndexNode.loadMethodByIndex(obj.getClass(), this.vtableIndex, this.interfaceTypeID);
    }

    @Override
    public Object invoke(Object obj, Object[] args) {
        if (this.callerSensitiveAdapter) {
            throw VMError.shouldNotReachHere("Cannot invoke method that has a @CallerSensitiveAdapter without an explicit caller");
        }
        this.preInvoke(obj);
        return ((ReflectionAccessorHolder.MethodInvokeFunctionPointer)this.expandSignature).invoke(obj, args, this.invokeTarget(obj));
    }

    @Override
    public Object invoke(Object obj, Object[] args, Class<?> caller) {
        if (this.callerSensitiveAdapter) {
            this.preInvoke(obj);
            return ((ReflectionAccessorHolder.MethodInvokeFunctionPointerForCallerSensitiveAdapter)this.expandSignature).invoke(obj, args, this.invokeTarget(obj), caller);
        }
        return this.invoke(obj, args);
    }

    @Override
    public Object invokeSpecial(Object obj, Object[] args) {
        if (this.callerSensitiveAdapter) {
            throw VMError.shouldNotReachHere("Cannot invoke method that has a @CallerSensitiveAdapter without an explicit caller");
        }
        this.preInvoke(obj);
        return super.invokeSpecial(obj, args);
    }
}

