/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.DynamicMethodAddressResolutionHeapSupport;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.os.AbstractImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public abstract class AbstractCopyingImageHeapProvider
extends AbstractImageHeapProvider {
    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    public int initialize(Pointer reservedAddressSpace, UnsignedWord reservedSize, WordPointer basePointer, WordPointer endPointer) {
        Pointer heapBase;
        Pointer selfReservedHeapBase;
        Pointer selfReservedMemory = (Pointer)Word.nullPointer();
        UnsignedWord requiredSize = this.getTotalRequiredAddressSpaceSize();
        if (reservedAddressSpace.isNull()) {
            UnsignedWord alignment = Word.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment());
            selfReservedMemory = VirtualMemoryProvider.get().reserve(requiredSize, alignment, false);
            if (selfReservedMemory.isNull()) {
                return 801;
            }
        } else if (reservedSize.belowThan(requiredSize)) {
            return 802;
        }
        if (DynamicMethodAddressResolutionHeapSupport.isEnabled()) {
            UnsignedWord preHeapRequiredBytes = AbstractCopyingImageHeapProvider.getPreHeapAlignedSizeForDynamicMethodAddressResolver();
            if (selfReservedMemory.isNonNull()) {
                heapBase = selfReservedHeapBase = selfReservedMemory.add(preHeapRequiredBytes);
            } else {
                heapBase = reservedAddressSpace.add(preHeapRequiredBytes);
                selfReservedHeapBase = (Pointer)Word.nullPointer();
            }
            int error = DynamicMethodAddressResolutionHeapSupport.get().initialize();
            if (error != 0) {
                this.freeImageHeap((PointerBase)selfReservedHeapBase);
                return error;
            }
            error = DynamicMethodAddressResolutionHeapSupport.get().install(heapBase);
            if (error != 0) {
                this.freeImageHeap((PointerBase)selfReservedHeapBase);
                return error;
            }
        } else {
            heapBase = selfReservedMemory.isNonNull() ? selfReservedMemory : reservedAddressSpace;
            selfReservedHeapBase = selfReservedMemory;
        }
        UnsignedWord imageHeapSizeInFile = AbstractCopyingImageHeapProvider.getImageHeapSizeInFile(Isolates.IMAGE_HEAP_BEGIN.get(), Isolates.IMAGE_HEAP_END.get());
        Pointer imageHeap = AbstractCopyingImageHeapProvider.getImageHeapBegin(heapBase);
        int result = this.commitAndCopyMemory((Pointer)Isolates.IMAGE_HEAP_BEGIN.get(), imageHeapSizeInFile, imageHeap);
        if (result != 0) {
            this.freeImageHeap((PointerBase)selfReservedHeapBase);
            return result;
        }
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        UnsignedWord writableBeginPageOffset = UnsignedUtils.roundDown((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get().subtract(Isolates.IMAGE_HEAP_BEGIN.get()), pageSize);
        if (writableBeginPageOffset.aboveThan(0) && VirtualMemoryProvider.get().protect((PointerBase)imageHeap, writableBeginPageOffset, 1) != 0) {
            this.freeImageHeap((PointerBase)selfReservedHeapBase);
            return 9;
        }
        UnsignedWord writableEndPageOffset = UnsignedUtils.roundUp((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_END.get().subtract(Isolates.IMAGE_HEAP_BEGIN.get()), pageSize);
        if (writableEndPageOffset.belowThan(imageHeapSizeInFile)) {
            Pointer afterWritableBoundary = imageHeap.add(writableEndPageOffset);
            UnsignedWord afterWritableSize = imageHeapSizeInFile.subtract(writableEndPageOffset);
            if (VirtualMemoryProvider.get().protect((PointerBase)afterWritableBoundary, afterWritableSize, 1) != 0) {
                this.freeImageHeap((PointerBase)selfReservedHeapBase);
                return 9;
            }
        }
        basePointer.write((WordBase)heapBase);
        if (endPointer.isNonNull()) {
            endPointer.write((WordBase)PointerUtils.roundUp((PointerBase)imageHeap.add(imageHeapSizeInFile), pageSize));
        }
        return 0;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    protected int commitAndCopyMemory(Pointer loadedImageHeap, UnsignedWord imageHeapSize, Pointer newImageHeap) {
        Pointer actualNewImageHeap = VirtualMemoryProvider.get().commit((PointerBase)newImageHeap, imageHeapSize, 3);
        if (actualNewImageHeap.isNull() || actualNewImageHeap.notEqual((UnsignedWord)newImageHeap)) {
            return 801;
        }
        return this.copyMemory(loadedImageHeap, imageHeapSize, newImageHeap);
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    protected abstract int copyMemory(Pointer var1, UnsignedWord var2, Pointer var3);

    @Override
    @Uninterruptible(reason="Called during isolate tear-down.")
    public int freeImageHeap(PointerBase heapBase) {
        if (heapBase.isNonNull()) {
            Pointer addressSpaceStart = (Pointer)heapBase;
            if (DynamicMethodAddressResolutionHeapSupport.isEnabled()) {
                addressSpaceStart = addressSpaceStart.subtract(AbstractCopyingImageHeapProvider.getPreHeapAlignedSizeForDynamicMethodAddressResolver());
            }
            if (VirtualMemoryProvider.get().free((PointerBase)addressSpaceStart, this.getTotalRequiredAddressSpaceSize()) != 0) {
                return 20;
            }
        }
        return 0;
    }
}

