/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jni.functions.JNIFunctionTables;
import com.oracle.svm.core.jvmti.JvmtiOnLoadFunctionPointer;
import com.oracle.svm.core.jvmti.JvmtiOnUnLoadFunctionPointer;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;

public class JvmtiAgents {
    private static final String AGENT_ON_LOAD = "Agent_OnLoad";
    private static final String AGENT_ON_UNLOAD = "Agent_OnUnload";
    private final ArrayList<PlatformNativeLibrarySupport.NativeLibrary> agents = new ArrayList();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JvmtiAgents() {
    }

    @Fold
    public static JvmtiAgents singleton() {
        return (JvmtiAgents)ImageSingletons.lookup(JvmtiAgents.class);
    }

    public void load() {
        String agentPath;
        String agentLib = SubstrateOptions.JVMTIAgentLib.getValue();
        if (agentLib != null) {
            this.loadAgent(agentLib, true);
        }
        if ((agentPath = SubstrateOptions.JVMTIAgentPath.getValue()) != null) {
            this.loadAgent(agentPath, false);
        }
    }

    public void unload() {
        for (PlatformNativeLibrarySupport.NativeLibrary lib : this.agents) {
            PointerBase function = lib.findSymbol(AGENT_ON_UNLOAD);
            if (!function.isNonNull()) continue;
            JvmtiAgents.callOnUnLoadFunction(function);
        }
        this.agents.clear();
    }

    private void loadAgent(String agentAndOptions, boolean relative) {
        block3: {
            if (!this.agents.isEmpty()) {
                throw new AgentInitException("Only a single agent is supported at the moment.");
            }
            try {
                this.loadAgent0(agentAndOptions, relative);
            }
            catch (AgentInitException e) {
                Log.log().string(e.getMessage()).newline();
                if (SubstrateOptions.SharedLibrary.getValue().booleanValue()) break block3;
                System.exit(1);
            }
        }
    }

    private void loadAgent0(String agentAndOptions, boolean relative) {
        String[] values = StringUtil.split((String)agentAndOptions, (String)"=", (int)2);
        String agent = values[0];
        String options = values.length > 1 ? values[1] : null;
        String agentFile = JvmtiAgents.getAgentFile(agent, relative);
        PlatformNativeLibrarySupport.NativeLibrary lib = PlatformNativeLibrarySupport.singleton().createLibrary(agentFile, false);
        if (!lib.load()) {
            throw new AgentInitException("Could not load agent library '" + agentFile + "'.");
        }
        PointerBase function = lib.findSymbol(AGENT_ON_LOAD);
        if (function.isNull()) {
            throw new AgentInitException("Could not find Agent_OnLoad function in agent library '" + agentFile + "'.");
        }
        if (!JvmtiAgents.callOnLoadFunction(function, options)) {
            throw new AgentInitException("Initialization of agent library '" + agentFile + "' failed.");
        }
        this.agents.add(lib);
    }

    private static String getAgentFile(String agent, boolean relative) {
        File file;
        if (relative) {
            String libname;
            String sysPath = NativeLibrarySupport.getImageDirectory();
            file = new File(sysPath, libname = System.mapLibraryName(agent));
            if (!file.exists()) {
                throw new AgentInitException("Could not find agent library '" + agent + "' on the library path.");
            }
        } else {
            file = new File(agent);
            if (!file.exists()) {
                throw new AgentInitException("Could not find agent library '" + agent + "'.");
            }
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new AgentInitException("Path of agent library '" + agent + "' is invalid: " + e.getMessage());
        }
    }

    private static boolean callOnLoadFunction(PointerBase function, String options) {
        JvmtiOnLoadFunctionPointer onLoad = (JvmtiOnLoadFunctionPointer)function;
        try (CTypeConversion.CCharPointerHolder holder = CTypeConversion.toCString((CharSequence)options);){
            int result = onLoad.invoke(JNIFunctionTables.singleton().getGlobalJavaVM(), holder.get(), (VoidPointer)Word.nullPointer());
            boolean bl = result == 0;
            return bl;
        }
    }

    private static void callOnUnLoadFunction(PointerBase function) {
        JvmtiOnUnLoadFunctionPointer onLoad = (JvmtiOnUnLoadFunctionPointer)function;
        onLoad.invoke(JNIFunctionTables.singleton().getGlobalJavaVM(), (VoidPointer)Word.nullPointer());
    }

    private static class AgentInitException
    extends RuntimeException {
        private static final long serialVersionUID = 3111979452718981714L;

        AgentInitException(String message) {
            super(message);
        }
    }
}

