/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.functions;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.c.CIsolateDataFactory;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jni.headers.JNIInvokeInterface;
import com.oracle.svm.core.jni.headers.JNIJavaVM;
import com.oracle.svm.core.jni.headers.JNINativeInterface;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class JNIFunctionTables {
    private final CFunctionPointer[] invokeInterfaceDataPrototype;
    private final CFunctionPointer[] functionTableData;
    private final CIsolateData<JNIInvokeInterface> jniInvokeInterface = CIsolateDataFactory.createStruct("jniInvokeInterface", JNIInvokeInterface.class);
    private final CIsolateData<JNIJavaVM> jniJavaVM = CIsolateDataFactory.createStruct("jniJavaVM", JNIJavaVM.class);
    private JNIJavaVM globalJavaVM;
    private JNINativeInterface globalFunctionTable;

    public static void create() {
        ImageSingletons.add(JNIFunctionTables.class, (Object)new JNIFunctionTables());
    }

    public static JNIFunctionTables singleton() {
        return (JNIFunctionTables)ImageSingletons.lookup(JNIFunctionTables.class);
    }

    private static int getFunctionTableSize() {
        return SizeOf.get(JNINativeInterface.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JNIFunctionTables() {
        this.invokeInterfaceDataPrototype = new CFunctionPointer[JNIFunctionTables.wordArrayLength(SizeOf.get(JNIInvokeInterface.class))];
        this.functionTableData = new CFunctionPointer[JNIFunctionTables.wordArrayLength(JNIFunctionTables.getFunctionTableSize())];
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int wordArrayLength(int sizeInBytes) {
        int wordSize = FrameAccess.wordSize();
        VMError.guarantee(sizeInBytes % wordSize == 0);
        return sizeInBytes / wordSize;
    }

    public JNIJavaVM getGlobalJavaVM() {
        JNIJavaVM javaVM = this.globalJavaVM;
        if (javaVM.isNull()) {
            JNIInvokeInterface invokeInterface = this.jniInvokeInterface.get();
            for (int i = 0; i < this.invokeInterfaceDataPrototype.length; ++i) {
                ((WordPointer)invokeInterface).write(i, (WordBase)this.invokeInterfaceDataPrototype[i]);
            }
            javaVM = this.jniJavaVM.get();
            invokeInterface.setIsolate(CurrentIsolate.getIsolate());
            javaVM.setFunctions(invokeInterface);
            Unsafe.getUnsafe().storeFence();
            this.globalJavaVM = javaVM;
        }
        return javaVM;
    }

    public JNINativeInterface getGlobalFunctionTable() {
        JNINativeInterface functionTable = this.globalFunctionTable;
        if (functionTable.isNull()) {
            this.globalFunctionTable = functionTable = (JNINativeInterface)JNIFunctionTables.dataAddress((WordBase[])this.functionTableData);
        }
        return functionTable;
    }

    private static Pointer dataAddress(WordBase[] dataArray) {
        DynamicHub hub = DynamicHub.fromClass(dataArray.getClass());
        UnsignedWord offsetOfFirstArrayElement = LayoutEncoding.getArrayElementOffset(hub.getLayoutEncoding(), 0);
        return Word.objectToUntrackedPointer((Object)dataArray).add(offsetOfFirstArrayElement);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initInvokeInterfaceTable(CFunctionPointer defaultValue, Feature.CompilationAccess access) {
        JNIFunctionTables.initTable(this.invokeInterfaceDataPrototype, defaultValue, access);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initInvokeInterfaceEntry(int offsetInBytes, CFunctionPointer value) {
        int wordSize = FrameAccess.wordSize();
        VMError.guarantee(offsetInBytes % wordSize == 0);
        this.invokeInterfaceDataPrototype[offsetInBytes / wordSize] = value;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initFunctionTable(CFunctionPointer defaultValue, Feature.CompilationAccess access) {
        JNIFunctionTables.initTable(this.functionTableData, defaultValue, access);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initFunctionEntry(int offsetInBytes, CFunctionPointer value) {
        int wordSize = FrameAccess.wordSize();
        VMError.guarantee(offsetInBytes % wordSize == 0);
        this.functionTableData[offsetInBytes / wordSize] = value;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void initTable(CFunctionPointer[] table, CFunctionPointer defaultValue, Feature.CompilationAccess access) {
        for (int i = 0; i < table.length; ++i) {
            table[i] = defaultValue;
        }
        access.registerAsImmutable((Object)table);
    }
}

