/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.core.MissingRegistrationUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jdk.graal.compiler.util.json.JsonPrintable;
import org.graalvm.nativeimage.MissingJNIRegistrationError;

public final class MissingJNIRegistrationUtils
extends MissingRegistrationUtils {
    public static void reportClassAccess(String className) {
        ConfigurationType type = MissingJNIRegistrationUtils.namedConfigurationType(className);
        type.setJniAccessible();
        MissingJNIRegistrationError exception = new MissingJNIRegistrationError(MissingJNIRegistrationUtils.jniMessage("access class", className, MissingJNIRegistrationUtils.elementToJSON((JsonPrintable)type)), Class.class, null, className, null);
        MissingJNIRegistrationUtils.report(exception);
    }

    public static void reportFieldAccess(Class<?> declaringClass, String fieldName) {
        ConfigurationType type = MissingJNIRegistrationUtils.getConfigurationType(declaringClass);
        type.setJniAccessible();
        MissingJNIRegistrationUtils.addField(type, fieldName);
        MissingJNIRegistrationError exception = new MissingJNIRegistrationError(MissingJNIRegistrationUtils.jniMessage("access field", declaringClass.getTypeName() + "." + fieldName, MissingJNIRegistrationUtils.elementToJSON((JsonPrintable)type)), Field.class, declaringClass, fieldName, null);
        MissingJNIRegistrationUtils.report(exception);
    }

    public static void reportMethodAccess(Class<?> declaringClass, String methodName, String signature) {
        ConfigurationType type = MissingJNIRegistrationUtils.getConfigurationType(declaringClass);
        type.setJniAccessible();
        type.addMethod(methodName, signature, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT);
        String json = MissingJNIRegistrationUtils.elementToJSON((JsonPrintable)type);
        MissingJNIRegistrationError exception = new MissingJNIRegistrationError(MissingJNIRegistrationUtils.jniMessage("access method", declaringClass.getTypeName() + "." + methodName + signature, json), Method.class, declaringClass, methodName, signature);
        MissingJNIRegistrationUtils.report(exception);
    }

    private static String jniMessage(String failedAction, String elementDescriptor, String json) {
        return MissingJNIRegistrationUtils.registrationMessage(failedAction, elementDescriptor, json, "reflectively", "reflection", "reflection");
    }

    private static void report(MissingJNIRegistrationError exception) {
        MissingRegistrationUtils.report((Error)exception, null);
    }
}

