/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_management_HiddenWait;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;

public class JavaMonitorWaitEvent {
    public static void emit(long startTicks, Object obj, long notifierTid, long timeout, boolean timedOut) {
        if (HasJfrSupport.get() && obj != null && !Target_jdk_jfr_internal_management_HiddenWait.class.equals(obj.getClass())) {
            JavaMonitorWaitEvent.emit0(startTicks, obj, notifierTid, timeout, timedOut);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emit0(long startTicks, Object obj, long notifierTid, long timeout, boolean timedOut) {
        long duration = JfrTicks.duration(startTicks);
        if (JfrEvent.JavaMonitorWait.shouldEmit(duration)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.JavaMonitorWait);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putLong(data, duration);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, SubstrateJVM.get().getStackTraceId(JfrEvent.JavaMonitorWait));
            JfrNativeEventWriter.putClass(data, obj.getClass());
            JfrNativeEventWriter.putThread(data, notifierTid);
            JfrNativeEventWriter.putLong(data, timeout);
            JfrNativeEventWriter.putBoolean(data, timedOut);
            JfrNativeEventWriter.putLong(data, Word.objectToUntrackedPointer((Object)obj).rawValue());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

