/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.fieldvaluetransformer.ObjectToConstantFieldValueTransformer;
import com.oracle.svm.core.jdk.VarHandleSupport;
import java.util.function.Function;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;

class VarHandleStaticBaseComputer
implements ObjectToConstantFieldValueTransformer {
    VarHandleStaticBaseComputer() {
    }

    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    @Override
    public JavaConstant transformToConstant(ResolvedJavaField field, Object receiver, Object originalValue, Function<Object, JavaConstant> toConstant) {
        ResolvedJavaField varHandleField = VarHandleSupport.singleton().findVarHandleField(receiver, false);
        StaticFieldsSupport.StaticFieldValidator.checkFieldOffsetAllowed(varHandleField);
        return StaticFieldsSupport.getStaticFieldsConstant(varHandleField, toConstant);
    }

    @Override
    public ValueNode intrinsify(CoreProviders providers, JavaConstant receiver) {
        Object varHandle = providers.getSnippetReflection().asObject(Object.class, receiver);
        if (varHandle != null) {
            ResolvedJavaField field = VarHandleSupport.singleton().findVarHandleField(varHandle, false);
            StaticFieldsSupport.StaticFieldValidator.checkFieldOffsetAllowed(field);
            return StaticFieldsSupport.createStaticFieldBaseNode(field);
        }
        return null;
    }
}

