/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.hub.registry.AbstractClassRegistry;
import com.oracle.svm.core.hub.registry.ClassRegistries;
import com.oracle.svm.core.jdk.AssertionLockComputer;
import com.oracle.svm.core.jdk.ClassLoaderHelper;
import com.oracle.svm.core.jdk.ClassLoaderValueMapFieldValueTransformer;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.ResourcesHelper;
import com.oracle.svm.core.jdk.Target_java_lang_AssertionStatusDirectives;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.util.Digest;
import jdk.internal.loader.NativeLibrary;

@TargetClass(value=ClassLoader.class)
public final class Target_java_lang_ClassLoader {
    @Alias
    private Target_java_lang_ClassLoader parent;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private ArrayList<Class<?>> classes;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset, isFinal=true)
    public ConcurrentHashMap<String, Object> parallelLockMap;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AssertionLockComputer.class, isFinal=true)
    private Object assertionLock;
    @Alias
    private static ClassLoader scl;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassRegistries.ClassRegistryComputer.class)
    @TargetElement(onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    public volatile AbstractClassRegistry classRegistry;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClassLoaderValueMapFieldValueTransformer.class)
    volatile ConcurrentHashMap<?, ?> classLoaderValueMap;

    @Substitute
    public static ClassLoader getSystemClassLoader() {
        VMError.guarantee(scl != null);
        return scl;
    }

    @Delete
    private static native ClassLoader initSystemClassLoader();

    @Alias
    public native Enumeration<URL> findResources(String var1);

    @Substitute
    private Enumeration<URL> getResources(String name) {
        Enumeration<URL> urls = ResourcesHelper.nameToResourceEnumerationURLs(name);
        return urls.hasMoreElements() ? urls : this.findResources(name);
    }

    @Substitute
    static NativeLibrary loadLibrary(Class<?> fromClass, String name) {
        NativeLibrarySupport.singleton().loadLibraryRelative(name);
        return null;
    }

    @Substitute
    static NativeLibrary loadLibrary(Class<?> fromClass, File file) {
        NativeLibrarySupport.singleton().loadLibraryAbsolute(file);
        return null;
    }

    @Alias
    public native String nameAndId();

    @Alias
    protected native Class<?> findLoadedClass(String var1);

    @Alias
    protected native Class<?> findClass(String var1);

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        if (!PredefinedClassesSupport.hasBytecodeClasses()) {
            throw new ClassNotFoundException(name);
        }
        if (this.parent != null) {
            try {
                clazz = this.parent.loadClass(name, resolve);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.findClass(name);
    }

    @Delete
    @TargetElement(name="findBootstrapClassOrNull", onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    static native Class<?> findBootstrapClassOrNullDeleted(String var0);

    @Substitute
    Class<?> loadClass(Module module, String name) {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Substitute
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/java.base/share/native/libjava/ClassLoader.c#L320-L329"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L1056-L1096")})
    private Class<?> findLoadedClass0(String name) {
        assert (!name.contains("/") && !name.startsWith("["));
        if (ClassForNameSupport.respectClassLoader()) {
            return ClassRegistries.findLoadedClass(name, SubstrateUtil.cast(this, ClassLoader.class));
        }
        return ClassForNameSupport.forNameOrNull(name, SubstrateUtil.cast(this, ClassLoader.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    ConcurrentHashMap<?, ?> createOrGetClassLoaderValueMap() {
        ConcurrentHashMap<Object, Object> result = this.classLoaderValueMap;
        if (result == null) {
            Target_java_lang_ClassLoader target_java_lang_ClassLoader = this;
            synchronized (target_java_lang_ClassLoader) {
                result = this.classLoaderValueMap;
                if (result == null) {
                    this.classLoaderValueMap = result = new ConcurrentHashMap();
                }
            }
        }
        return result;
    }

    @Alias
    native Stream<Package> packages();

    @Substitute
    private void setDefaultAssertionStatus(boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setPackageAssertionStatus(String packageName, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setClassAssertionStatus(String className, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void clearAssertionStatus() {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Delete
    private native void initializeJavaAssertionMaps();

    @Delete
    private static native void registerNatives();

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private Class<?> defineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        return RuntimeClassLoading.defineClass(SubstrateUtil.cast(this, ClassLoader.class), name, b, off, len, new RuntimeClassLoading.ClassDefinitionInfo(protectionDomain));
    }

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private Class<?> defineClass(String name, ByteBuffer b, ProtectionDomain protectionDomain) {
        return Target_java_lang_ClassLoader.defineClass2(SubstrateUtil.cast(this, ClassLoader.class), name, b, b.position(), b.remaining(), protectionDomain, null);
    }

    @Delete
    @TargetElement(name="defineClass1", onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private static native Class<?> defineClass1Deleted(ClassLoader var0, String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(name="defineClass2", onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private static native Class<?> defineClass2Deleted(ClassLoader var0, String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/java.base/share/native/libjava/ClassLoader.c#L71-L151"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L1051-L1054"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L857-L896")})
    private static Class<?> defineClass1(ClassLoader loader, String name, byte[] b, int off, int len, ProtectionDomain pd, String source) {
        return RuntimeClassLoading.defineClass(loader, name, b, off, len, new RuntimeClassLoading.ClassDefinitionInfo(pd));
    }

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/java.base/share/native/libjava/ClassLoader.c#L153-L213"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L1051-L1054"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L857-L896")})
    private static Class<?> defineClass2(ClassLoader loader, String name, ByteBuffer b, int off, int len, ProtectionDomain pd, String source) {
        if (PredefinedClassesSupport.hasBytecodeClasses() || RuntimeClassLoading.isSupported()) {
            int offset;
            byte[] array;
            if (b.hasArray()) {
                array = b.array();
                offset = off + b.arrayOffset();
            } else {
                array = new byte[len];
                b.get(off, array);
                offset = 0;
            }
            return RuntimeClassLoading.defineClass(loader, name, array, offset, len, new RuntimeClassLoading.ClassDefinitionInfo(pd));
        }
        throw RuntimeClassLoading.throwNoBytecodeClasses(name);
    }

    @Substitute
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/java.base/share/native/libjava/ClassLoader.c#L215-L283"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L1039-L1049"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L909-L1022")})
    private static Class<?> defineClass0(ClassLoader loader, Class<?> lookup, String name, byte[] b, int off, int len, ProtectionDomain pd, boolean initialize, int flags, Object classData) {
        RuntimeClassLoading.ClassDefinitionInfo info;
        Object actualName = name;
        if (LambdaUtils.isLambdaClassName((String)name)) {
            actualName = (String)actualName + Digest.digest((byte[])b);
        }
        boolean isNestMate = (flags & ClassLoaderHelper.NESTMATE_CLASS) != 0;
        boolean isHidden = (flags & ClassLoaderHelper.HIDDEN_CLASS) != 0;
        boolean isStrong = (flags & ClassLoaderHelper.STRONG_LOADER_LINK) != 0;
        boolean vmAnnotations = (flags & ClassLoaderHelper.ACCESS_VM_ANNOTATIONS) != 0;
        Class<?> nest = null;
        if (isNestMate) {
            nest = lookup.getNestHost();
        }
        if (isHidden) {
            info = new RuntimeClassLoading.ClassDefinitionInfo(pd, nest, classData, isStrong, vmAnnotations);
        } else {
            if (classData != null) {
                throw new IllegalArgumentException("Class data is only applicable for hidden classes");
            }
            if (isNestMate) {
                throw new IllegalArgumentException("Dynamic nestmate is only applicable for hidden classes");
            }
            if (!isStrong) {
                throw new IllegalArgumentException("An ordinary class must be strongly referenced by its defining loader");
            }
            if (vmAnnotations) {
                throw new IllegalArgumentException("VM annotations only allowed for hidden classes");
            }
            if (flags != ClassLoaderHelper.STRONG_LOADER_LINK) {
                throw new IllegalArgumentException(String.format("invalid flags 0x%x", flags));
            }
            info = new RuntimeClassLoading.ClassDefinitionInfo(pd);
        }
        return RuntimeClassLoading.defineClass(loader, (String)actualName, b, off, len, info);
    }

    @Delete
    @TargetElement(name="findBootstrapClass", onlyWith={ClassForNameSupport.IgnoresClassLoader.class})
    private static native Class<?> findBootstrapClassDeleted(String var0);

    @Substitute
    @TargetElement(onlyWith={ClassForNameSupport.RespectsClassLoader.class})
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/java.base/share/native/libjava/ClassLoader.c#L288-L328"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+16/src/hotspot/share/prims/jvm.cpp#L780-L800")})
    static Class<?> findBootstrapClass(String name) {
        assert (!name.contains("/") && !name.startsWith("["));
        return ClassRegistries.findBootstrapClass(name);
    }

    @Delete
    private static native Target_java_lang_AssertionStatusDirectives retrieveDirectives();
}

