/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;

final class DirectMemoryAccessors {
    private static volatile boolean initialized;
    private static long directMemory;

    DirectMemoryAccessors() {
    }

    static long getDirectMemory() {
        if (!initialized) {
            return DirectMemoryAccessors.tryInitialize();
        }
        return directMemory;
    }

    private static long tryInitialize() {
        long newDirectMemory = SubstrateOptions.MaxDirectMemorySize.getValue();
        if (newDirectMemory == 0L) {
            newDirectMemory = Runtime.getRuntime().maxMemory();
        }
        directMemory = newDirectMemory;
        initialized = true;
        return newDirectMemory;
    }
}

