/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.InstanceReferenceMapDecoder;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import java.util.EnumSet;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public final class DynamicHubSupport
implements MultiLayeredImageSingleton,
UnsavedSingleton {
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private int maxTypeId;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private byte[] referenceMapEncoding;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static DynamicHubSupport currentLayer() {
        return LayeredImageSingletonSupport.singleton().lookup(DynamicHubSupport.class, false, true);
    }

    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static DynamicHubSupport forLayer(int layerId) {
        return MultiLayeredImageSingleton.getForLayer(DynamicHubSupport.class, layerId);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static InstanceReferenceMapDecoder.InstanceReferenceMap getInstanceReferenceMap(DynamicHub hub) {
        NonmovableArray<Byte> referenceMapEncoding = DynamicHubSupport.forLayer(hub.getLayerId()).getReferenceMapEncoding();
        return InstanceReferenceMapDecoder.getReferenceMap(referenceMapEncoding, hub.getReferenceMapIndex());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean hasEmptyReferenceMap(DynamicHub hub) {
        InstanceReferenceMapDecoder.InstanceReferenceMap referenceMap = DynamicHubSupport.getInstanceReferenceMap(hub);
        return InstanceReferenceMapDecoder.isEmpty(referenceMap);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DynamicHubSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setMaxTypeId(int maxTypeId) {
        this.maxTypeId = maxTypeId;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public int getMaxTypeId() {
        return this.maxTypeId;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setReferenceMapEncoding(NonmovableArray<Byte> referenceMapEncoding) {
        this.referenceMapEncoding = (byte[])NonmovableArrays.getHostedArray(referenceMapEncoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public NonmovableArray<Byte> getReferenceMapEncoding() {
        return NonmovableArrays.fromImageHeap((Object)this.referenceMapEncoding);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }
}

