/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceAccess;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class ReferenceAccessImpl
implements ReferenceAccess {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ReferenceAccessImpl() {
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word readObjectAsUntrackedPointer(Pointer p, boolean compressed) {
        Object obj = this.readObjectAt(p, compressed);
        return Word.objectToUntrackedPointer((Object)obj);
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Object readObjectAt(Pointer p, boolean compressed) {
        Word w = (Word)p;
        if (compressed) {
            return ObjectAccess.readObject((Object)Word.nullPointer(), (WordBase)p);
        }
        return w.readObject(0);
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeObjectAt(Pointer p, Object value, boolean compressed) {
        Word w = (Word)p;
        if (compressed) {
            ObjectAccess.writeObject((Object)Word.nullPointer(), (WordBase)p, (Object)value);
        } else {
            w.writeObject(0, value);
        }
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeObjectBarrieredAt(Object object, UnsignedWord offsetInObject, Object value, boolean compressed) {
        assert (compressed) : "Heap object must contain only compressed references";
        BarrieredAccess.writeObject((Object)object, (WordBase)offsetInObject, (Object)value);
    }

    @Override
    public native UnsignedWord getCompressedRepresentation(Object var1);

    @Override
    public native Object uncompressReference(UnsignedWord var1);

    @Override
    @Fold
    public boolean haveCompressedReferences() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CompressEncoding getCompressEncoding() {
        return (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
    }

    @Override
    @Fold
    public UnsignedWord getMaxAddressSpaceSize() {
        int compressionShift = ReferenceAccess.singleton().getCompressEncoding().getShift();
        if (compressionShift > 0) {
            int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
            return Word.unsigned((long)(1L << referenceSize * 8)).shiftLeft(compressionShift);
        }
        return Word.unsigned((long)0xFFFFFFFFFFFFL);
    }

    @Override
    @Fold
    public int getCompressionShift() {
        return this.getCompressEncoding().getShift();
    }
}

