/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.IsolateArguments;
import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.locale.LocaleSupport;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.container.Container;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CEntryPointUtilityNode;
import com.oracle.svm.core.graal.nodes.WriteCodeBaseNode;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.nodes.WriteHeapBaseNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceHandlerThread;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.imagelayer.ImageLayerSection;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.os.MemoryProtectionProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.RecurringCallbackSupport;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import com.oracle.svm.core.thread.ThreadStatusTransition;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.VMThreadLocalSupport;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PauseNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.Word;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class CEntryPointSnippets
extends SubstrateTemplates
implements Snippets {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "createIsolate", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor INITIALIZE_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "initializeIsolate", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ATTACH_THREAD = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "attachThread", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ENSURE_JAVA_THREAD = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "ensureJavaThread", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_BY_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "enterByIsolate", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor DETACH_CURRENT_THREAD = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "detachCurrentThread", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor REPORT_EXCEPTION = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "reportException", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor TEAR_DOWN_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "tearDownIsolate", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor IS_ATTACHED = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "isAttached", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor FAIL_FATALLY = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "failFatally", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor VERIFY_ISOLATE_THREAD = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "verifyIsolateThread", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CREATE_ISOLATE, INITIALIZE_ISOLATE, ATTACH_THREAD, ENSURE_JAVA_THREAD, ENTER_BY_ISOLATE, DETACH_CURRENT_THREAD, REPORT_EXCEPTION, TEAR_DOWN_ISOLATE, IS_ATTACHED, FAIL_FATALLY, VERIFY_ISOLATE_THREAD};
    private static final CGlobalData<Word> IMAGE_HEAP_PATCHING_STATE = CGlobalDataFactory.createWord();
    private static final CGlobalData<PointerBase> FIRST_ISOLATE_INIT_STATE = CGlobalDataFactory.createWord();
    private static boolean isolateInitialized;
    private final SnippetTemplate.SnippetInfo createIsolate;
    private final SnippetTemplate.SnippetInfo attachThread;
    private final SnippetTemplate.SnippetInfo enter;
    private final SnippetTemplate.SnippetInfo enterByIsolate;
    private final SnippetTemplate.SnippetInfo returnFromJavaToC;
    private final SnippetTemplate.SnippetInfo detachCurrentThread;
    private final SnippetTemplate.SnippetInfo reportException;
    private final SnippetTemplate.SnippetInfo tearDownIsolate;
    private final SnippetTemplate.SnippetInfo isAttached;
    private final SnippetTemplate.SnippetInfo failFatally;

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, CEntryPointCreateIsolateParameters var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Isolate var1, boolean var2, boolean var3);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Isolate var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, IsolateThread var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Throwable var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCallInitializeIsolate(@Node.ConstantNodeParameter ForeignCallDescriptor var0, CEntryPointCreateIsolateParameters var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCallTearDownIsolate(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native boolean runtimeCallIsAttached(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Isolate var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void runtimeCallFailFatally(@Node.ConstantNodeParameter ForeignCallDescriptor var0, int var1, CCharPointer var2);

    @Fold
    static boolean hasHeapBase() {
        return ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void setHeapBase(PointerBase heapBase) {
        WriteHeapBaseNode.writeCurrentVMHeapBase(heapBase);
        if (MemoryProtectionProvider.isAvailable()) {
            MemoryProtectionProvider.singleton().unlockCurrentIsolate();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    @NeverInline(value="Heap base register is set in caller, prevent reads from floating before that.")
    private static void initCodeBase() {
        ImageCodeInfo imageCodeInfo = MultiLayeredImageSingleton.getForLayer(ImageCodeInfo.class, 0);
        CodePointer codeBase = imageCodeInfo.getCodeStart();
        WriteCodeBaseNode.writeCurrentVMCodeBase((PointerBase)codeBase);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void earlyInitHeapBase(PointerBase heapBase) {
        CEntryPointSnippets.setHeapBase(heapBase);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initBaseRegisters(PointerBase heapBase) {
        CEntryPointSnippets.setHeapBase(heapBase);
        if (SubstrateOptions.useRelativeCodePointers()) {
            CEntryPointSnippets.initCodeBase();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initBaseRegisters(PointerBase heapBase, PointerBase codeBase) {
        CEntryPointSnippets.setHeapBase(heapBase);
        if (SubstrateOptions.useRelativeCodePointers()) {
            WriteCodeBaseNode.writeCurrentVMCodeBase(codeBase);
        }
    }

    @Snippet(allowMissingProbabilities=true)
    public static int createIsolateSnippet(CEntryPointCreateIsolateParameters parameters) {
        WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)Word.nullPointer());
        int result = CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)CREATE_ISOLATE, parameters);
        if (result != 0) {
            return result;
        }
        ThreadStatusTransition.fromNativeToJava(false);
        return CEntryPointSnippets.runtimeCallInitializeIsolate(INITIALIZE_ISOLATE, parameters);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    private static void layeredPatchHeapRelativeRelocations() {
        Word heapPatchStateAddr = IMAGE_HEAP_PATCHING_STATE.get();
        boolean firstIsolate = heapPatchStateAddr.logicCompareAndSwapWord(0, (WordBase)ImageHeapPatchingState.UNINITIALIZED, (WordBase)ImageHeapPatchingState.IN_PROGRESS, NamedLocationIdentity.OFF_HEAP_LOCATION);
        if (!firstIsolate) {
            Word state = (Word)heapPatchStateAddr.readWordVolatile(0, LocationIdentity.ANY_LOCATION);
            while (state.equal(ImageHeapPatchingState.IN_PROGRESS)) {
                PauseNode.pause();
                state = (Word)heapPatchStateAddr.readWordVolatile(0, LocationIdentity.ANY_LOCATION);
            }
            return;
        }
        Pointer currentSection = ImageLayerSection.getInitialLayerSection().get();
        Word heapBegin = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_BEGIN));
        Word patches = ImageLayerSection.getHeapRelativeRelocationsStart().get();
        int endOffset = 4 + patches.readInt(0) * 4;
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        for (int offset = 4; offset < endOffset; offset += 8) {
            int heapOffset = patches.readInt(offset);
            int referenceEncoding = patches.readInt(offset + 4);
            if (referenceSize == 4) {
                heapBegin.writeInt(heapOffset, referenceEncoding);
                continue;
            }
            heapBegin.writeLong(heapOffset, (long)referenceEncoding);
        }
        heapPatchStateAddr.writeWordVolatile(0, (WordBase)ImageHeapPatchingState.SUCCESSFUL);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int createIsolate(CEntryPointCreateIsolateParameters providedParameters) {
        CPUFeatureAccess cpuFeatureAccess = (CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class);
        if (cpuFeatureAccess.verifyHostSupportsArchitectureEarly() != 0) {
            return 23;
        }
        UnsignedWord runtimePageSize = VirtualMemoryProvider.get().getGranularity();
        UnsignedWord imagePageSize = Word.unsigned((int)SubstrateOptions.getPageSize());
        boolean validPageSize = UnsignedUtils.isAMultiple(imagePageSize, runtimePageSize);
        if (!validPageSize) {
            return 24;
        }
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            CEntryPointSnippets.layeredPatchHeapRelativeRelocations();
        }
        LocaleSupport.initialize();
        CEntryPointCreateIsolateParameters parameters = providedParameters;
        if (parameters.isNull() || parameters.version() < 1) {
            parameters = (CEntryPointCreateIsolateParameters)StackValue.get(CEntryPointCreateIsolateParameters.class);
            parameters.setReservedSpaceSize((UnsignedWord)Word.zero());
            parameters.setVersion(1);
        }
        IsolateArguments arguments = (IsolateArguments)StackValue.get(IsolateArguments.class);
        UnmanagedMemoryUtil.fill((Pointer)arguments, SizeOf.unsigned(IsolateArguments.class), (byte)0);
        CLongPointer parsedArgs = (CLongPointer)StackValue.get((int)IsolateArgumentParser.getParsedArgsSize());
        arguments.setParsedArgs(parsedArgs);
        IsolateArgumentParser.singleton().parse(parameters, arguments);
        Container.initialize();
        WordPointer isolatePtr = (WordPointer)StackValue.get(WordPointer.class);
        int error = Isolates.create(isolatePtr, arguments);
        if (error != 0) {
            IsolateArgumentParser.singleton().tearDown(arguments);
            return error;
        }
        Isolate isolate = (Isolate)isolatePtr.read();
        CEntryPointSnippets.initBaseRegisters(Isolates.getHeapBase(isolate));
        return CEntryPointSnippets.createIsolate0(isolate, arguments);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @NeverInline(value="Ensure this code cannot rise above where heap base is set.")
    private static int createIsolate0(Isolate isolate, IsolateArguments arguments) {
        assert (Heap.getHeap().verifyImageHeapMapping());
        IsolateArgumentParser.singleton().persistOptions(arguments);
        IsolateListenerSupport.singleton().afterCreateIsolate(isolate);
        CodeInfoTable.prepareImageCodeInfo();
        if (!VMThreads.ensureInitialized()) {
            return 11;
        }
        int error = CEntryPointSnippets.enterAttachThread0(isolate, false, true);
        if (error != 0) {
            return error;
        }
        PlatformThreads.singleton().assignMainThread();
        return 0;
    }

    public static boolean isIsolateInitialized() {
        return isolateInitialized;
    }

    @Uninterruptible(reason="Must be uninterruptible because thread state is not set up after leaveTearDownIsolate().")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int initializeIsolate(CEntryPointCreateIsolateParameters parameters) {
        int result = CEntryPointSnippets.initializeIsolateInterruptibly(parameters);
        if (result != 0) {
            CEntryPointActions.leaveTearDownIsolate();
            return result;
        }
        return result;
    }

    @Uninterruptible(reason="Used as a transition between uninterruptible and interruptible code", calleeMustBe=false)
    private static int initializeIsolateInterruptibly(CEntryPointCreateIsolateParameters parameters) {
        return CEntryPointSnippets.initializeIsolateInterruptibly0(parameters);
    }

    private static int initializeIsolateInterruptibly0(CEntryPointCreateIsolateParameters parameters) {
        try {
            return CEntryPointSnippets.initializeIsolateInterruptibly1(parameters);
        }
        catch (Throwable t) {
            Log.log().string("Uncaught exception while initializing isolate: ").exception(t).newline();
            return 13;
        }
    }

    @NeverInline(value="GR-24649")
    private static int initializeIsolateInterruptibly1(CEntryPointCreateIsolateParameters parameters) {
        int state;
        long initStateAddr = FIRST_ISOLATE_INIT_STATE.get().rawValue();
        boolean firstIsolate = Unsafe.getUnsafe().compareAndSetInt(null, initStateAddr, 0, 1);
        Isolates.assignIsolateId(firstIsolate);
        PhysicalMemory.initialize();
        if (VMOperationControl.useDedicatedVMOperationThread()) {
            VMOperationControl.startVMOperationThread();
        }
        Isolates.assignStartTime();
        LocaleSupport.checkForError();
        if (!firstIsolate && (state = Unsafe.getUnsafe().getInt(initStateAddr)) != 2) {
            while (state == 1) {
                PauseNode.pause();
                state = Unsafe.getUnsafe().getIntVolatile(null, initStateAddr);
            }
            if (state == -1) {
                return 13;
            }
        }
        if (ReferenceHandler.useDedicatedThread()) {
            ReferenceInternals.initializeLocking();
            ReferenceHandlerThread.start();
        }
        IsolateArgumentParser.singleton().copyToRuntimeOptions();
        if (parameters.isNonNull() && parameters.version() >= 3 && parameters.getArgv().isNonNull()) {
            boolean exitWhenArgumentParsingFails = true;
            boolean ignoreUnrecognized = false;
            if (parameters.version() >= 4) {
                ignoreUnrecognized = parameters.getIgnoreUnrecognizedArguments();
                exitWhenArgumentParsingFails = parameters.getExitWhenArgumentParsingFails();
            }
            String[] args = SubstrateUtil.convertCToJavaArgs(parameters.getArgc(), parameters.getArgv());
            try {
                args = RuntimeOptionParser.parseAndConsumeAllOptions(args, ignoreUnrecognized);
            }
            catch (IllegalArgumentException e) {
                if (exitWhenArgumentParsingFails) {
                    Log.logStream().println("error: " + e.getMessage());
                    System.exit(1);
                }
                return 22;
            }
            if (ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class)) {
                ((JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class)).mainArgs = args;
            }
        }
        boolean success = PlatformNativeLibrarySupport.singleton().initializeBuiltinLibraries();
        if (firstIsolate) {
            int state2 = success ? 2 : -1;
            Unsafe.getUnsafe().putIntVolatile(null, initStateAddr, state2);
        }
        if (!success) {
            return 13;
        }
        StackOverflowCheck.singleton().updateStackOverflowBoundary();
        assert (!isolateInitialized);
        isolateInitialized = true;
        try {
            RuntimeSupport.executeInitializationHooks();
        }
        catch (Throwable t) {
            System.err.println("Uncaught exception while running isolate initialization hooks:");
            t.printStackTrace();
            return 13;
        }
        try {
            ThreadListenerSupport.get().beforeThreadRun();
        }
        catch (Throwable t) {
            System.err.println("Uncaught exception in beforeThreadRun():");
            t.printStackTrace();
            return 13;
        }
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static int attachThreadSnippet(Isolate isolate, boolean startedByIsolate, boolean ensureJavaThread) {
        WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)Word.nullPointer());
        int error = CEntryPointSnippets.runtimeCall(ATTACH_THREAD, isolate, startedByIsolate, ensureJavaThread);
        if (error != 0) {
            return error;
        }
        ThreadStatusTransition.fromNativeToJava(false);
        if (ensureJavaThread) {
            return CEntryPointSnippets.runtimeCallEnsureJavaThread(ENSURE_JAVA_THREAD);
        }
        return 0;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int attachThread(Isolate isolate, boolean startedByIsolate, boolean ensureJavaThread) {
        return CEntryPointSnippets.enterAttachThread0(isolate, startedByIsolate, ensureJavaThread);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    private static int enterAttachThread0(Isolate isolate, boolean startedByIsolate, boolean ensureJavaThread) {
        return CEntryPointSnippets.enterAttachThread0(isolate, startedByIsolate, ensureJavaThread, true, false);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    private static int enterAttachThread0(Isolate isolate, boolean startedByIsolate, boolean ensureJavaThread, boolean allowAttach, boolean inCrashHandler) {
        int error = Isolates.checkIsolate(isolate);
        if (error != 0) {
            return error;
        }
        CEntryPointSnippets.initBaseRegisters(Isolates.getHeapBase(isolate));
        if (!VMThreads.isInitialized()) {
            return 5;
        }
        IsolateThread thread = (IsolateThread)Word.nullPointer();
        if (startedByIsolate) {
            assert (VMThreads.singleton().findIsolateThreadForCurrentOSThread(inCrashHandler).isNull());
        } else {
            thread = VMThreads.singleton().findIsolateThreadForCurrentOSThread(inCrashHandler);
        }
        if (thread.isNull()) {
            if (!allowAttach) {
                return 4;
            }
            return CEntryPointSnippets.attachUnattachedThread(isolate, startedByIsolate, inCrashHandler);
        }
        WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        if (ensureJavaThread && !PlatformThreads.isCurrentAssigned()) {
            throw VMError.shouldNotReachHere("thread was already attached but does not have a Thread object and we would assign one");
        }
        return 0;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    private static int attachUnattachedThread(Isolate isolate, boolean startedByIsolate, boolean inCrashHandler) {
        int isolateThreadSize = VMThreadLocalSupport.singleton().vmThreadSize;
        IsolateThread thread = VMThreads.singleton().allocateIsolateThread(isolateThreadSize);
        if (thread.isNull()) {
            return 3;
        }
        WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        if (!StackOverflowCheck.singleton().initialize()) {
            return 32;
        }
        if (inCrashHandler) {
            SubstrateDiagnostics.setOnlyAttachedForCrashHandler(thread);
        } else {
            int error = VMThreads.singleton().attachThread(thread, startedByIsolate);
            if (error != 0) {
                VMThreads.singleton().freeCurrentIsolateThread();
                return error;
            }
        }
        VMThreads.IsolateTL.set(thread, isolate);
        return 0;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public static int enterAttachFromCrashHandler(Isolate isolate) {
        return CEntryPointSnippets.enterAttachThread0(isolate, false, false, true, true);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public static int enterFromCrashHandler(Isolate isolate) {
        return CEntryPointSnippets.enterAttachThread0(isolate, false, false, false, true);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public static void initializeIsolateThreadForCrashHandler(Isolate isolate, IsolateThread thread) {
        CEntryPointSnippets.initBaseRegisters(Isolates.getHeapBase(isolate));
        WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        VMThreads.StatusSupport.setStatusNative();
        VMThreads.IsolateTL.set(thread, isolate);
        SubstrateDiagnostics.setOnlyAttachedForCrashHandler(thread);
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCallEnsureJavaThread(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @Uninterruptible(reason="Prevent stack overflow errors; thread is no longer attached in error case.", calleeMustBe=false)
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int ensureJavaThread() {
        try {
            PlatformThreads.ensureCurrentAssigned();
            return 0;
        }
        catch (Throwable e) {
            int result = 12;
            if (e instanceof OutOfMemoryError) {
                result = 3;
            }
            CEntryPointActions.leaveDetachThread();
            return result;
        }
    }

    @Snippet(allowMissingProbabilities=true)
    public static int detachCurrentThreadSnippet() {
        return CEntryPointSnippets.runtimeCall(DETACH_CURRENT_THREAD);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Thread state going away.")
    private static int detachCurrentThread() {
        try {
            VMThreads.singleton().detachCurrentThread();
        }
        catch (Throwable t) {
            return 12;
        }
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static int tearDownIsolateSnippet() {
        return CEntryPointSnippets.runtimeCallTearDownIsolate(TEAR_DOWN_ISOLATE);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Tear-down in progress - may still execute interruptible Java code in the beginning.")
    private static int tearDownIsolate() {
        try {
            if (!CEntryPointSnippets.initiateTearDownIsolateInterruptibly()) {
                return 1;
            }
            RecurringCallbackSupport.suspendCallbackTimer("Execution of arbitrary code is prohibited during the last teardown steps.");
            if (VMOperationControl.useDedicatedVMOperationThread()) {
                VMOperationControl.shutdownAndDetachVMOperationThread();
            }
            VMThreads.singleton().waitUntilDetachedThreadsExitedOnOSLevel();
            IsolateThread currentThread = CurrentIsolate.getCurrentThread();
            VMError.guarantee(VMThreads.firstThreadUnsafe().equal((ComparableWord)currentThread));
            VMError.guarantee(VMThreads.nextThread(VMThreads.firstThreadUnsafe()).isNull());
            IsolateListenerSupport.singleton().onIsolateTeardown();
            PlatformThreads.detach(currentThread);
            PlatformThreads.singleton().closeOSThreadHandle(VMThreads.getOSThreadHandle(currentThread));
            CodeInfoTable.tearDown();
            NonmovableArrays.tearDown();
            Heap.getHeap().tearDown();
            IsolateArgumentParser.singleton().tearDown();
            int code = CommittedMemoryProvider.get().tearDown();
            if (code != 0) {
                return code;
            }
            VMThreads.singleton().freeCurrentIsolateThread();
            return 0;
        }
        catch (Throwable t) {
            return 12;
        }
    }

    @Uninterruptible(reason="Tear-down in progress - still safe to execute interruptible Java code.", calleeMustBe=false)
    private static boolean initiateTearDownIsolateInterruptibly() {
        RuntimeSupport.executeTearDownHooks();
        if (!PlatformThreads.tearDownOtherThreads()) {
            return false;
        }
        VMThreads.singleton().threadExit();
        return true;
    }

    @Snippet(allowMissingProbabilities=true)
    public static int enterByIsolateSnippet(Isolate isolate) {
        WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)Word.nullPointer());
        int result = CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)ENTER_BY_ISOLATE, isolate);
        if (result == 0 && VMThreads.StatusSupport.isStatusNativeOrSafepoint()) {
            ThreadStatusTransition.fromNativeToJava(false);
        }
        return result;
    }

    @Uninterruptible(reason="Thread state not set up yet")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int enterByIsolate(Isolate isolate) {
        int error = Isolates.checkIsolate(isolate);
        if (error != 0) {
            return error;
        }
        CEntryPointSnippets.initBaseRegisters(Isolates.getHeapBase(isolate));
        if (!VMThreads.isInitialized()) {
            return 5;
        }
        IsolateThread thread = VMThreads.singleton().findIsolateThreadForCurrentOSThread(false);
        if (thread.isNull()) {
            return 4;
        }
        WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static int enterSnippet(IsolateThread thread) {
        if (thread.isNull()) {
            return 2;
        }
        WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        Isolate isolate = VMThreads.IsolateTL.get(thread);
        CEntryPointSnippets.initBaseRegisters(Isolates.getHeapBase(isolate));
        if (CEntryPointSnippets.runtimeAssertionsEnabled() || SubstrateOptions.CheckIsolateThreadAtEntry.getValue().booleanValue()) {
            CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)VERIFY_ISOLATE_THREAD, thread);
        }
        ThreadStatusTransition.fromNativeToJava(false);
        return 0;
    }

    @Fold
    static boolean runtimeAssertionsEnabled() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(CEntryPointSnippets.class);
    }

    @Uninterruptible(reason="Thread state not set up yet")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int verifyIsolateThread(IsolateThread thread) {
        VMError.guarantee(CurrentIsolate.getCurrentThread() == thread, "Threads must match for the call below");
        if (!VMThreads.singleton().verifyIsCurrentThread(thread) || !VMThreads.singleton().verifyThreadIsAttached(thread)) {
            throw VMError.shouldNotReachHere("A call from native code to Java code provided the wrong JNI environment or the wrong IsolateThread. The JNI environment / IsolateThread is a thread-local data structure and must not be shared between threads.");
        }
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static int reportExceptionSnippet(Throwable exception) {
        return CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)REPORT_EXCEPTION, exception);
    }

    @Uninterruptible(reason="Avoid StackOverflowError and safepoints until they are disabled permanently", calleeMustBe=false)
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    private static int reportException(Throwable exception) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        CEntryPointSnippets.reportExceptionInterruptibly(exception);
        return 1;
    }

    private static void reportExceptionInterruptibly(Throwable exception) {
        CEntryPointSnippets.logException(exception);
        VMError.shouldNotReachHere("Unhandled exception");
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    private static void logException(Throwable exception) {
        try {
            Log.log().string("Unhandled exception: ");
            Log.log().exception(exception).newline().newline();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Snippet(allowMissingProbabilities=true)
    public static int returnFromJavaToCSnippet() {
        ThreadStatusTransition.fromJavaToNative();
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static boolean isAttachedSnippet(Isolate isolate) {
        return Isolates.checkIsolate(isolate) == 0 && CEntryPointSnippets.runtimeCallIsAttached(IS_ATTACHED, isolate);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean isAttached(Isolate isolate) {
        CEntryPointSnippets.initBaseRegisters(Isolates.getHeapBase(isolate));
        return VMThreads.isInitialized() && VMThreads.singleton().findIsolateThreadForCurrentOSThread(false).isNonNull();
    }

    @Snippet(allowMissingProbabilities=true)
    public static void failFatallySnippet(int code, CCharPointer message) {
        CEntryPointSnippets.runtimeCallFailFatally(FAIL_FATALLY, code, message);
    }

    @Uninterruptible(reason="Unknown thread state.")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void failFatally(int code, CCharPointer message) {
        VMThreads.singleton().failFatally(code, message);
    }

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new CEntryPointSnippets(options, providers, lowerings);
    }

    private CEntryPointSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.createIsolate = this.snippet(providers, CEntryPointSnippets.class, "createIsolateSnippet", new LocationIdentity[0]);
        this.attachThread = this.snippet(providers, CEntryPointSnippets.class, "attachThreadSnippet", new LocationIdentity[0]);
        this.enter = this.snippet(providers, CEntryPointSnippets.class, "enterSnippet", new LocationIdentity[0]);
        this.enterByIsolate = this.snippet(providers, CEntryPointSnippets.class, "enterByIsolateSnippet", new LocationIdentity[0]);
        this.returnFromJavaToC = this.snippet(providers, CEntryPointSnippets.class, "returnFromJavaToCSnippet", new LocationIdentity[0]);
        this.detachCurrentThread = this.snippet(providers, CEntryPointSnippets.class, "detachCurrentThreadSnippet", new LocationIdentity[0]);
        this.reportException = this.snippet(providers, CEntryPointSnippets.class, "reportExceptionSnippet", new LocationIdentity[0]);
        this.tearDownIsolate = this.snippet(providers, CEntryPointSnippets.class, "tearDownIsolateSnippet", new LocationIdentity[0]);
        this.isAttached = this.snippet(providers, CEntryPointSnippets.class, "isAttachedSnippet", new LocationIdentity[0]);
        this.failFatally = this.snippet(providers, CEntryPointSnippets.class, "failFatallySnippet", new LocationIdentity[0]);
        lowerings.put(CEntryPointEnterNode.class, new EnterLowering());
        lowerings.put(CEntryPointLeaveNode.class, new LeaveLowering());
        lowerings.put(CEntryPointUtilityNode.class, new UtilityLowering());
    }

    private static final class ImageHeapPatchingState {
        static final Word UNINITIALIZED = (Word)Word.zero();
        static final Word IN_PROGRESS = (Word)Word.unsigned((int)1);
        static final Word SUCCESSFUL = (Word)Word.unsigned((int)2);

        private ImageHeapPatchingState() {
        }
    }

    private static final class FirstIsolateInitStates {
        static final int UNINITIALIZED = 0;
        static final int IN_PROGRESS = 1;
        static final int SUCCESSFUL = 2;
        static final int FAILED = -1;

        private FirstIsolateInitStates() {
        }
    }

    protected class EnterLowering
    implements NodeLoweringProvider<CEntryPointEnterNode> {
        protected EnterLowering() {
        }

        @Override
        public void lower(CEntryPointEnterNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            switch (node.getEnterAction()) {
                case CreateIsolate: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.createIsolate, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("parameters", (Object)node.getParameter());
                    break;
                }
                case AttachThread: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.attachThread, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("isolate", (Object)node.getParameter());
                    args.add("startedByIsolate", (Object)node.getStartedByIsolate());
                    args.add("ensureJavaThread", (Object)node.getEnsureJavaThread());
                    break;
                }
                case EnterByIsolate: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.enterByIsolate, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("isolate", (Object)node.getParameter());
                    break;
                }
                case Enter: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.enter, node.graph().getGuardsStage(), tool.getLoweringStage());
                    assert (node.getParameter() != null);
                    args.add("thread", (Object)node.getParameter());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereUnexpectedInput((Object)node.getEnterAction());
                }
            }
            SnippetTemplate template = CEntryPointSnippets.this.template((CoreProviders)tool, (ValueNode)node, args);
            template.setMayRemoveLocation(true);
            template.instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class LeaveLowering
    implements NodeLoweringProvider<CEntryPointLeaveNode> {
        protected LeaveLowering() {
        }

        @Override
        public void lower(CEntryPointLeaveNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            switch (node.getLeaveAction()) {
                case Leave: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.returnFromJavaToC, node.graph().getGuardsStage(), tool.getLoweringStage());
                    break;
                }
                case DetachThread: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.detachCurrentThread, node.graph().getGuardsStage(), tool.getLoweringStage());
                    break;
                }
                case TearDownIsolate: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.tearDownIsolate, node.graph().getGuardsStage(), tool.getLoweringStage());
                    break;
                }
                case ExceptionAbort: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.reportException, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("exception", (Object)node.getException());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereUnexpectedInput((Object)node.getLeaveAction());
                }
            }
            CEntryPointSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class UtilityLowering
    implements NodeLoweringProvider<CEntryPointUtilityNode> {
        protected UtilityLowering() {
        }

        @Override
        public void lower(CEntryPointUtilityNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            switch (node.getUtilityAction()) {
                case IsAttached: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.isAttached, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("isolate", (Object)node.getParameter0());
                    break;
                }
                case FailFatally: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.failFatally, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("code", (Object)node.getParameter0());
                    args.add("message", (Object)node.getParameter1());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereUnexpectedInput((Object)node.getUtilityAction());
                }
            }
            CEntryPointSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

