/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class DynamicHubOffsets {
    private static final int UNINITIALIZED = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int nameOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int hubTypeOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int referenceTypeOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int layoutEncodingOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int typeIDOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int typeIDDepthOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int numClassTypesOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int numInterfaceTypesOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int openTypeWorldTypeCheckSlotsOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int monitorOffsetOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int identityHashOffsetOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int flagsOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int componentTypeOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int referenceMapIndexOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int layerIdOffset = -1;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private int companionOffset = -1;
    private static final String[] SKIPPED_FIELDS = new String[]{"typeCheckStart", "typeCheckRange", "typeCheckSlot", "closedTypeWorldTypeCheckSlots", "vtable"};

    @Fold
    public static DynamicHubOffsets singleton() {
        return (DynamicHubOffsets)ImageSingletons.lookup(DynamicHubOffsets.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void initializeOffsets(MetaAccessProvider metaAccess) {
        for (ResolvedJavaField resolvedJavaField : metaAccess.lookupJavaType(DynamicHub.class).getInstanceFields(true)) {
            if (Arrays.stream(SKIPPED_FIELDS).anyMatch(resolvedJavaField.getName()::equals) || AnnotationAccess.isAnnotationPresent((AnnotatedElement)resolvedJavaField, InjectAccessors.class)) continue;
            try {
                Field offsetField = ReflectionUtil.lookupField(DynamicHubOffsets.class, (String)(resolvedJavaField.getName() + "Offset"));
                offsetField.setInt(DynamicHubOffsets.singleton(), resolvedJavaField.getOffset());
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        for (Field field : DynamicHubOffsets.class.getDeclaredFields()) {
            String name = field.getName();
            if (!name.endsWith("Offset")) continue;
            try {
                DynamicHub.class.getDeclaredField(name.substring(0, name.length() - "Offset".length()));
            }
            catch (NoSuchFieldException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public int getHubTypeOffset() {
        return this.hubTypeOffset;
    }

    public int getReferenceTypeOffset() {
        return this.referenceTypeOffset;
    }

    public int getLayoutEncodingOffset() {
        return this.layoutEncodingOffset;
    }

    public int getTypeIDOffset() {
        return this.typeIDOffset;
    }

    public int getTypeIDDepthOffset() {
        return this.typeIDDepthOffset;
    }

    public int getNumClassTypesOffset() {
        return this.numClassTypesOffset;
    }

    public int getNumInterfaceTypesOffset() {
        return this.numInterfaceTypesOffset;
    }

    public int getOpenTypeWorldTypeCheckSlotsOffset() {
        return this.openTypeWorldTypeCheckSlotsOffset;
    }

    public int getMonitorOffsetOffset() {
        return this.monitorOffsetOffset;
    }

    public int getIdentityHashOffsetOffset() {
        return this.identityHashOffsetOffset;
    }

    public int getFlagsOffset() {
        return this.flagsOffset;
    }

    public int getComponentTypeOffset() {
        return this.componentTypeOffset;
    }

    public int getReferenceMapIndexOffset() {
        return this.referenceMapIndexOffset;
    }

    public int getLayerIdOffset() {
        return this.layerIdOffset;
    }

    public int getCompanionOffset() {
        return this.companionOffset;
    }

    public static void writeObject(DynamicHub hub, int offset, Object value) {
        if (offset < 0) {
            return;
        }
        BarrieredAccess.writeObject((Object)hub, (int)offset, (Object)value);
    }

    public static void writeInt(DynamicHub hub, int offset, int value) {
        if (offset < 0) {
            return;
        }
        BarrieredAccess.writeInt((Object)hub, (int)offset, (int)value);
    }

    public static void writeShort(DynamicHub hub, int offset, short value) {
        if (offset < 0) {
            return;
        }
        BarrieredAccess.writeShort((Object)hub, (int)offset, (short)value);
    }

    public static void writeChar(DynamicHub hub, int offset, char value) {
        if (offset < 0) {
            return;
        }
        BarrieredAccess.writeChar((Object)hub, (int)offset, (char)value);
    }

    public static void writeByte(DynamicHub hub, int offset, byte value) {
        if (offset < 0) {
            return;
        }
        BarrieredAccess.writeByte((Object)hub, (int)offset, (byte)value);
    }
}

