/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.struct.OffsetOf;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizationSlotPacking;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64Backend;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.code.InterpreterAccessStubData;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.AllocatableValue;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public class AMD64InterpreterStubs {
    public static final Register TRAMPOLINE_ARGUMENT = AMD64.rax;

    private static SubstrateAMD64RegisterConfig getRegisterConfig() {
        return new SubstrateAMD64RegisterConfig(SubstrateRegisterConfig.ConfigKind.NORMAL, null, ConfigurationValues.getTarget(), SubstrateOptions.PreserveFramePointer.getValue());
    }

    public static int sizeOfInterpreterData() {
        return NumUtil.roundUp((int)SizeOf.get(InterpreterDataAMD64.class), (int)16);
    }

    public static int additionalFrameSizeEnterStub() {
        int wordSize = 8;
        int deoptSlotSize = wordSize + wordSize;
        return AMD64InterpreterStubs.sizeOfInterpreterData() + deoptSlotSize;
    }

    public static int additionalFrameSizeLeaveStub() {
        int wordSize = 8;
        return 4 * wordSize;
    }

    @Fold
    public static int offsetAbiSpReg() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiSpReg");
    }

    @Fold
    public static int offsetAbiGp0() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiGp0");
    }

    @Fold
    public static int offsetAbiGp1() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiGp1");
    }

    @Fold
    public static int offsetAbiGp2() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiGp2");
    }

    @Fold
    public static int offsetAbiGp3() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiGp3");
    }

    @Fold
    public static int offsetAbiGp4() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiGp4");
    }

    @Fold
    public static int offsetAbiGp5() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiGp5");
    }

    @Fold
    public static int offsetAbiFpArg0() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiFpArg0");
    }

    @Fold
    public static int offsetAbiFpArg1() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiFpArg1");
    }

    @Fold
    public static int offsetAbiFpArg2() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiFpArg2");
    }

    @Fold
    public static int offsetAbiFpArg3() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiFpArg3");
    }

    @Fold
    public static int offsetAbiFpArg4() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiFpArg4");
    }

    @Fold
    public static int offsetAbiFpArg5() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiFpArg5");
    }

    @Fold
    public static int offsetAbiFpArg6() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiFpArg6");
    }

    @Fold
    public static int offsetAbiFpArg7() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiFpArg7");
    }

    @Fold
    public static int offsetAbiGpRet() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiGpRet");
    }

    @Fold
    public static int offsetAbiFpRet() {
        return OffsetOf.get(InterpreterDataAMD64.class, "AbiFpRet");
    }

    @RawStructure
    public static interface InterpreterDataAMD64
    extends PointerBase {
        @RawField
        public long getStackSize();

        @RawField
        public void setStackSize(long var1);

        @RawField
        public long getAbiSpReg();

        @RawField
        public void setAbiSpReg(long var1);

        @RawField
        public void setAbiGpRet(long var1);

        @RawField
        public long getAbiGpRet();

        @RawField
        public void setAbiFpRet(long var1);

        @RawField
        public long getAbiFpRet();

        @RawField
        public long getAbiGp0();

        @RawField
        public void setAbiGp0(long var1);

        @RawField
        public long getAbiGp1();

        @RawField
        public void setAbiGp1(long var1);

        @RawField
        public long getAbiGp2();

        @RawField
        public void setAbiGp2(long var1);

        @RawField
        public long getAbiGp3();

        @RawField
        public void setAbiGp3(long var1);

        @RawField
        public long getAbiGp4();

        @RawField
        public void setAbiGp4(long var1);

        @RawField
        public long getAbiGp5();

        @RawField
        public void setAbiGp5(long var1);

        @RawField
        public long getAbiFpArg0();

        @RawField
        public void setAbiFpArg0(long var1);

        @RawField
        public long getAbiFpArg1();

        @RawField
        public void setAbiFpArg1(long var1);

        @RawField
        public long getAbiFpArg2();

        @RawField
        public void setAbiFpArg2(long var1);

        @RawField
        public long getAbiFpArg3();

        @RawField
        public void setAbiFpArg3(long var1);

        @RawField
        public long getAbiFpArg4();

        @RawField
        public void setAbiFpArg4(long var1);

        @RawField
        public long getAbiFpArg5();

        @RawField
        public void setAbiFpArg5(long var1);

        @RawField
        public long getAbiFpArg6();

        @RawField
        public void setAbiFpArg6(long var1);

        @RawField
        public long getAbiFpArg7();

        @RawField
        public void setAbiFpArg7(long var1);
    }

    public static class AMD64InterpreterAccessStubData
    implements InterpreterAccessStubData {
        @Override
        public void setSp(Pointer data, int stackSize, Pointer stackBuffer) {
            VMError.guarantee(stackBuffer.isNonNull());
            InterpreterDataAMD64 p = (InterpreterDataAMD64)data;
            p.setAbiSpReg(stackBuffer.rawValue());
            p.setStackSize(stackSize);
            assert (stackSize % 16 == 0);
            stackBuffer.writeLong(0, DeoptimizationSlotPacking.encodeVariableFrameSizeIntoDeoptSlot(stackSize));
        }

        @Override
        public long getGpArgumentAt(AllocatableValue ccArg, Pointer data, int pos) {
            InterpreterDataAMD64 p = (InterpreterDataAMD64)data;
            return switch (pos) {
                case 0 -> p.getAbiGp0();
                case 1 -> p.getAbiGp1();
                case 2 -> p.getAbiGp2();
                case 3 -> p.getAbiGp3();
                case 4 -> p.getAbiGp4();
                case 5 -> p.getAbiGp5();
                default -> {
                    StackSlot stackSlot = (StackSlot)ccArg;
                    Pointer sp = (Pointer)Word.pointer((long)p.getAbiSpReg());
                    int spAdjustmentOnCall = ConfigurationValues.getTarget().wordSize;
                    int offset = stackSlot.getOffset(0) + spAdjustmentOnCall;
                    yield sp.readLong(offset);
                }
            };
        }

        @Override
        public long setGpArgumentAt(AllocatableValue ccArg, Pointer data, int pos, long val) {
            InterpreterDataAMD64 p = (InterpreterDataAMD64)data;
            if (pos >= 0 && pos <= 5) {
                VMError.guarantee(ccArg instanceof RegisterValue);
                switch (pos) {
                    case 0: {
                        p.setAbiGp0(val);
                        break;
                    }
                    case 1: {
                        p.setAbiGp1(val);
                        break;
                    }
                    case 2: {
                        p.setAbiGp2(val);
                        break;
                    }
                    case 3: {
                        p.setAbiGp3(val);
                        break;
                    }
                    case 4: {
                        p.setAbiGp4(val);
                        break;
                    }
                    case 5: {
                        p.setAbiGp5(val);
                    }
                }
                return 0L;
            }
            StackSlot stackSlot = (StackSlot)ccArg;
            Pointer sp = (Pointer)Word.pointer((long)p.getAbiSpReg());
            int offset = stackSlot.getOffset(0);
            VMError.guarantee(sp.isNonNull());
            VMError.guarantee((long)offset < p.getStackSize());
            sp.writeLong(offset, val);
            VMError.guarantee(pos - 6 < 64, "more than 64 stack args are not supported");
            return 1L << pos - 6;
        }

        private static int upperFpEnd() {
            return Platform.includedIn(InternalPlatform.WINDOWS_BASE.class) ? 3 : 7;
        }

        @Override
        public long getFpArgumentAt(AllocatableValue ccArg, Pointer data, int pos) {
            InterpreterDataAMD64 p = (InterpreterDataAMD64)data;
            if (pos >= 0 && pos <= AMD64InterpreterAccessStubData.upperFpEnd()) {
                VMError.guarantee(ccArg instanceof RegisterValue);
                switch (pos) {
                    case 0: {
                        return p.getAbiFpArg0();
                    }
                    case 1: {
                        return p.getAbiFpArg1();
                    }
                    case 2: {
                        return p.getAbiFpArg2();
                    }
                    case 3: {
                        return p.getAbiFpArg3();
                    }
                    case 4: {
                        return p.getAbiFpArg4();
                    }
                    case 5: {
                        return p.getAbiFpArg5();
                    }
                    case 6: {
                        return p.getAbiFpArg6();
                    }
                    case 7: {
                        return p.getAbiFpArg7();
                    }
                }
            }
            StackSlot stackSlot = (StackSlot)ccArg;
            Pointer sp = (Pointer)Word.pointer((long)p.getAbiSpReg());
            int spAdjustmentOnCall = ConfigurationValues.getTarget().wordSize;
            int offset = stackSlot.getOffset(0) + spAdjustmentOnCall;
            return sp.readLong(offset);
        }

        @Override
        public void setFpArgumentAt(AllocatableValue ccArg, Pointer data, int pos, long val) {
            InterpreterDataAMD64 p = (InterpreterDataAMD64)data;
            if (pos >= 0 && pos <= AMD64InterpreterAccessStubData.upperFpEnd()) {
                VMError.guarantee(ccArg instanceof RegisterValue);
                switch (pos) {
                    case 0: {
                        p.setAbiFpArg0(val);
                        break;
                    }
                    case 1: {
                        p.setAbiFpArg1(val);
                        break;
                    }
                    case 2: {
                        p.setAbiFpArg2(val);
                        break;
                    }
                    case 3: {
                        p.setAbiFpArg3(val);
                        break;
                    }
                    case 4: {
                        p.setAbiFpArg4(val);
                        break;
                    }
                    case 5: {
                        p.setAbiFpArg5(val);
                        break;
                    }
                    case 6: {
                        p.setAbiFpArg6(val);
                        break;
                    }
                    case 7: {
                        p.setAbiFpArg7(val);
                    }
                }
            } else {
                StackSlot stackSlot = (StackSlot)ccArg;
                Pointer sp = (Pointer)Word.pointer((long)p.getAbiSpReg());
                int offset = stackSlot.getOffset(0);
                VMError.guarantee(sp.isNonNull());
                VMError.guarantee((long)offset < p.getStackSize());
                sp.writeLong(offset, val);
            }
        }

        @Override
        public long getGpReturn(Pointer data) {
            return ((InterpreterDataAMD64)data).getAbiGpRet();
        }

        @Override
        public void setGpReturn(Pointer data, long gpReturn) {
            ((InterpreterDataAMD64)data).setAbiGpRet(gpReturn);
        }

        @Override
        public long getFpReturn(Pointer data) {
            return ((InterpreterDataAMD64)data).getAbiFpRet();
        }

        @Override
        public void setFpReturn(Pointer data, long fpReturn) {
            ((InterpreterDataAMD64)data).setAbiFpRet(fpReturn);
        }

        @Override
        @Fold
        public int allocateStubDataSize() {
            return AMD64InterpreterStubs.sizeOfInterpreterData();
        }
    }

    public static class InterpreterLeaveStubContext
    extends SubstrateAMD64Backend.SubstrateAMD64FrameContext {
        public InterpreterLeaveStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method, callingConvention);
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            super.enter(crb);
            AMD64MacroAssembler masm = (AMD64MacroAssembler)crb.asm;
            List<Register> gps = AMD64InterpreterStubs.getRegisterConfig().getJavaGeneralParameterRegs();
            masm.movq(new AMD64Address(AMD64.rsp, 0), gps.get(1));
            masm.movq(new AMD64Address(AMD64.rsp, 8), gps.get(2));
            masm.movq(new AMD64Address(AMD64.rsp, 16), gps.get(3));
            masm.subq(AMD64.rsp, gps.get(2));
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            AMD64MacroAssembler masm = (AMD64MacroAssembler)crb.asm;
            List<Register> gps = AMD64InterpreterStubs.getRegisterConfig().getJavaGeneralParameterRegs();
            List<Register> fps = AMD64InterpreterStubs.getRegisterConfig().getFloatingPointParameterRegs();
            Register callTarget = AMD64.r10;
            masm.movq(callTarget, AMD64.rax);
            masm.movq(AMD64.rax, gps.get(1));
            Register stackSize = AMD64.r11;
            masm.movq(stackSize, gps.get(2));
            Label regsHandling = new Label();
            masm.testq(stackSize, stackSize);
            masm.jccb(AMD64Assembler.ConditionFlag.Zero, regsHandling);
            Register calleeSpArgs = AMD64.r12;
            Register interpDataSp = AMD64.r9;
            masm.movq(interpDataSp, new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiSpReg()));
            masm.movq(calleeSpArgs, AMD64.rsp);
            int wordSize = 8;
            Label spCopyBegin = new Label();
            masm.bind(spCopyBegin);
            masm.movq(gps.get(4), new AMD64Address(interpDataSp, 0));
            masm.movq(new AMD64Address(calleeSpArgs, 0), gps.get(4));
            masm.addq(interpDataSp, wordSize);
            masm.addq(calleeSpArgs, wordSize);
            masm.subl(stackSize, wordSize);
            masm.testq(stackSize, stackSize);
            masm.jccb(AMD64Assembler.ConditionFlag.NotZero, spCopyBegin);
            masm.bind(regsHandling);
            masm.movq(fps.get(0), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg0()));
            masm.movq(fps.get(1), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg1()));
            masm.movq(fps.get(2), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg2()));
            masm.movq(fps.get(3), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg3()));
            if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
                masm.movq(fps.get(4), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg4()));
                masm.movq(fps.get(5), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg5()));
                masm.movq(fps.get(6), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg6()));
                masm.movq(fps.get(7), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg7()));
            }
            masm.movq(gps.get(0), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp0()));
            masm.movq(gps.get(1), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp1()));
            masm.movq(gps.get(2), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp2()));
            masm.movq(gps.get(3), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp3()));
            masm.movq(gps.get(4), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp4()));
            masm.movq(gps.get(5), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp5()));
            masm.call(callTarget);
            Register resultCopy = AMD64.r10;
            masm.movq(resultCopy, AMD64.rax);
            masm.movq(AMD64.r12, new AMD64Address(AMD64.rsp, 0));
            assert (crb.target.stackAlignment == 16);
            masm.shrq(AMD64.r12, 52);
            masm.addq(AMD64.rsp, AMD64.r12);
            masm.movq(AMD64.rax, new AMD64Address(AMD64.rsp, 0));
            masm.movq(new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGpRet()), resultCopy);
            masm.movq(new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpRet()), AMD64.xmm0);
            super.leave(crb);
        }
    }

    public static class InterpreterEnterStubContext
    extends SubstrateAMD64Backend.SubstrateAMD64FrameContext {
        public InterpreterEnterStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method, callingConvention);
        }

        private static AMD64Address createAddress(int offset) {
            int deoptSlotSize = 16;
            return new AMD64Address(AMD64.rsp, deoptSlotSize + offset);
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            AMD64MacroAssembler masm = (AMD64MacroAssembler)crb.asm;
            Register trampArg = TRAMPOLINE_ARGUMENT;
            Register spCopy = AMD64.r11;
            masm.movq(spCopy, AMD64.rsp);
            super.enter(crb);
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiSpReg()), spCopy);
            List<Register> gps = AMD64InterpreterStubs.getRegisterConfig().getJavaGeneralParameterRegs();
            VMError.guarantee(gps.size() == 6);
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiGp0()), gps.get(0));
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiGp1()), gps.get(1));
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiGp2()), gps.get(2));
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiGp3()), gps.get(3));
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiGp4()), gps.get(4));
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiGp5()), gps.get(5));
            List<Register> fps = AMD64InterpreterStubs.getRegisterConfig().getFloatingPointParameterRegs();
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiFpArg0()), fps.get(0));
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiFpArg1()), fps.get(1));
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiFpArg2()), fps.get(2));
            masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiFpArg3()), fps.get(3));
            if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
                VMError.guarantee(fps.size() == 8);
                masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiFpArg4()), fps.get(4));
                masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiFpArg5()), fps.get(5));
                masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiFpArg6()), fps.get(6));
                masm.movq(InterpreterEnterStubContext.createAddress(AMD64InterpreterStubs.offsetAbiFpArg7()), fps.get(7));
            } else {
                assert (Platform.includedIn(InternalPlatform.WINDOWS_BASE.class));
                VMError.guarantee(fps.size() == 4);
            }
            masm.movq(gps.get(1), AMD64.rsp);
            masm.addq(gps.get(1), 16);
            masm.movq(gps.get(0), trampArg);
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            AMD64MacroAssembler masm = (AMD64MacroAssembler)crb.asm;
            masm.movq(AMD64.xmm0, new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpRet()));
            masm.movq(AMD64.rax, new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGpRet()));
            super.leave(crb);
        }
    }
}

