/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.aarch64.SubstrateAArch64MacroAssembler;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.impl.InternalPlatform;

public class SubstrateAArch64RegisterConfig
implements SubstrateRegisterConfig {
    private final TargetDescription target;
    private final int nativeParamsStackOffset;
    private final List<Register> generalParameterRegs;
    private final List<Register> fpParameterRegs;
    private final List<Register> allocatableRegs;
    private final List<Register> calleeSaveRegisters;
    private final List<RegisterAttributes> attributesMap;
    private final MetaAccessProvider metaAccess;
    private final boolean preserveFramePointer;
    public static final Register fp = AArch64.r29;

    public SubstrateAArch64RegisterConfig(SubstrateRegisterConfig.ConfigKind config, MetaAccessProvider metaAccess, TargetDescription target, boolean preserveFramePointer) {
        this.target = target;
        this.metaAccess = metaAccess;
        this.preserveFramePointer = preserveFramePointer;
        this.generalParameterRegs = List.of(AArch64.r0, AArch64.r1, AArch64.r2, AArch64.r3, AArch64.r4, AArch64.r5, AArch64.r6, AArch64.r7);
        this.fpParameterRegs = List.of(AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v5, AArch64.v6, AArch64.v7);
        this.nativeParamsStackOffset = 0;
        ArrayList regs = new ArrayList(AArch64.allRegisters);
        regs.remove(ReservedRegisters.singleton().getFrameRegister());
        regs.remove(AArch64.zr);
        regs.remove(SubstrateAArch64MacroAssembler.scratch1);
        regs.remove(SubstrateAArch64MacroAssembler.scratch2);
        if (preserveFramePointer) {
            regs.remove(fp);
        }
        regs.remove(AArch64.r31);
        regs.remove(ReservedRegisters.singleton().getHeapBaseRegister());
        regs.remove(ReservedRegisters.singleton().getThreadRegister());
        regs.remove(ReservedRegisters.singleton().getCodeBaseRegister());
        if (Platform.includedIn(Platform.DARWIN.class) || Platform.includedIn(InternalPlatform.WINDOWS_BASE.class) || Platform.includedIn(Platform.ANDROID.class)) {
            regs.remove(AArch64.r18);
        }
        this.allocatableRegs = List.copyOf(regs);
        switch (config) {
            case NORMAL: {
                this.calleeSaveRegisters = List.of();
                break;
            }
            case NATIVE_TO_JAVA: {
                this.calleeSaveRegisters = List.of(AArch64.r19, AArch64.r20, AArch64.r21, AArch64.r22, AArch64.r23, AArch64.r24, AArch64.r25, AArch64.r26, AArch64.r27, AArch64.r28, AArch64.v8, AArch64.v9, AArch64.v10, AArch64.v11, AArch64.v12, AArch64.v13, AArch64.v14, AArch64.v15);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereUnexpectedInput((Object)config);
            }
        }
        this.attributesMap = RegisterAttributes.createMap((RegisterConfig)this, (List)AArch64.allRegisters);
    }

    public Register getReturnRegister(JavaKind kind) {
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: 
            case Long: 
            case Object: {
                return AArch64.r0;
            }
            case Float: 
            case Double: {
                return AArch64.v0;
            }
            case Void: {
                return null;
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput(kind);
    }

    public List<Register> getAllocatableRegisters() {
        return this.allocatableRegs;
    }

    public List<Register> getCalleeSaveRegisters() {
        return this.calleeSaveRegisters;
    }

    public List<Register> getCallerSaveRegisters() {
        return this.getAllocatableRegisters();
    }

    public boolean areAllAllocatableRegistersCallerSaved() {
        return true;
    }

    public List<RegisterAttributes> getAttributesMap() {
        return this.attributesMap;
    }

    public List<Register> getCallingConventionRegisters(CallingConvention.Type t, JavaKind kind) {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean shouldPreserveFramePointer() {
        return this.preserveFramePointer;
    }

    private int javaStackParameterAssignment(ValueKindFactory<?> valueKindFactory, AllocatableValue[] locations, int index, JavaKind kind, int currentStackOffset, boolean isOutgoing) {
        ValueKind valueKind = valueKindFactory.getValueKind(kind.getStackKind());
        int alignment = Math.max(valueKind.getPlatformKind().getSizeInBytes(), this.target.wordSize);
        locations[index] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!isOutgoing ? 1 : 0) != 0);
        return currentStackOffset + alignment;
    }

    private int linuxNativeStackParameterAssignment(ValueKindFactory<?> valueKindFactory, AllocatableValue[] locations, int index, JavaKind kind, int currentStackOffset, boolean isOutgoing) {
        ValueKind valueKind = valueKindFactory.getValueKind(isOutgoing ? kind.getStackKind() : kind);
        int alignment = Math.max(kind.getByteCount(), this.target.wordSize);
        locations[index] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!isOutgoing ? 1 : 0) != 0);
        return currentStackOffset + alignment;
    }

    private static int darwinNativeStackParameterAssignment(ValueKindFactory<?> valueKindFactory, AllocatableValue[] locations, int index, JavaKind kind, int currentStackOffset, boolean isOutgoing) {
        int paramByteSize = kind.getByteCount();
        int alignedStackOffset = NumUtil.roundUp((int)currentStackOffset, (int)paramByteSize);
        locations[index] = StackSlot.get((ValueKind)valueKindFactory.getValueKind(kind), (int)alignedStackOffset, (!isOutgoing ? 1 : 0) != 0);
        return alignedStackOffset + paramByteSize;
    }

    public CallingConvention getCallingConvention(CallingConvention.Type t, JavaType returnType, JavaType[] parameterTypes, ValueKindFactory<?> valueKindFactory) {
        SubstrateCallingConventionType type = (SubstrateCallingConventionType)t;
        boolean isEntryPoint = type.nativeABI() && !type.outgoing;
        AllocatableValue[] locations = new AllocatableValue[parameterTypes.length];
        JavaKind[] kinds = new JavaKind[locations.length];
        int firstActualArgument = 0;
        if (type.usesReturnBuffer()) {
            JavaKind kind;
            VMError.guarantee(type.fixedParameterAssignment != null);
            VMError.guarantee(type.fixedParameterAssignment[0].isPlaceholder());
            firstActualArgument = 1;
            kinds[0] = kind = ObjectLayout.getCallSignatureKind(isEntryPoint, parameterTypes[0], this.metaAccess, this.target);
            ValueKind paramValueKind = valueKindFactory.getValueKind(isEntryPoint ? kind : kind.getStackKind());
            locations[0] = AArch64.r8.asValue(paramValueKind);
            for (int i = 1; i < type.fixedParameterAssignment.length; ++i) {
                AssignedLocation storage = type.fixedParameterAssignment[i];
                if (storage.assignsToRegister()) assert (!storage.register().equals((Object)AArch64.r8));
            }
        }
        int currentStackOffset = type.nativeABI() ? this.nativeParamsStackOffset : this.target.wordSize;
        boolean isDarwinPlatform = Platform.includedIn(Platform.DARWIN.class);
        if (!type.customABI()) {
            int currentGeneral = 0;
            int currentFP = 0;
            for (int i = firstActualArgument; i < parameterTypes.length; ++i) {
                JavaKind kind;
                kinds[i] = kind = ObjectLayout.getCallSignatureKind(isEntryPoint, parameterTypes[i], this.metaAccess, this.target);
                Register register = null;
                if (type.kind == SubstrateCallingConventionKind.ForwardReturnValue) {
                    VMError.guarantee(i == 0, "Method with calling convention ForwardReturnValue cannot have more than one parameter");
                    register = this.getReturnRegister(kind);
                } else {
                    switch (kind) {
                        case Boolean: 
                        case Byte: 
                        case Char: 
                        case Short: 
                        case Int: 
                        case Long: 
                        case Object: {
                            if (currentGeneral >= this.generalParameterRegs.size()) break;
                            register = this.generalParameterRegs.get(currentGeneral++);
                            break;
                        }
                        case Float: 
                        case Double: {
                            if (currentFP >= this.fpParameterRegs.size()) break;
                            register = this.fpParameterRegs.get(currentFP++);
                            break;
                        }
                        default: {
                            throw VMError.shouldNotReachHereUnexpectedInput(kind);
                        }
                    }
                }
                if (register != null) {
                    boolean useJavaKind = isEntryPoint && !isDarwinPlatform;
                    locations[i] = register.asValue(valueKindFactory.getValueKind(useJavaKind ? kind : kind.getStackKind()));
                    continue;
                }
                if (type.nativeABI()) {
                    if (isDarwinPlatform) {
                        currentStackOffset = SubstrateAArch64RegisterConfig.darwinNativeStackParameterAssignment(valueKindFactory, locations, i, kind, currentStackOffset, type.outgoing);
                        continue;
                    }
                    currentStackOffset = this.linuxNativeStackParameterAssignment(valueKindFactory, locations, i, kind, currentStackOffset, type.outgoing);
                    continue;
                }
                currentStackOffset = this.javaStackParameterAssignment(valueKindFactory, locations, i, kind, currentStackOffset, type.outgoing);
            }
        } else {
            HashSet<Register> usedRegisters = new HashSet<Register>();
            VMError.guarantee(parameterTypes.length == type.fixedParameterAssignment.length, "Parameters/assignments size mismatch.");
            for (int i = firstActualArgument; i < locations.length; ++i) {
                JavaKind kind;
                kinds[i] = kind = ObjectLayout.getCallSignatureKind(isEntryPoint, parameterTypes[i], this.metaAccess, this.target);
                ValueKind paramValueKind = valueKindFactory.getValueKind(isEntryPoint ? kind : kind.getStackKind());
                AssignedLocation storage = type.fixedParameterAssignment[i];
                if (storage.assignsToRegister()) {
                    if (!kind.isNumericInteger() && !kind.isNumericFloat()) {
                        throw VMError.unsupportedFeature("Unsupported storage/kind pair - Storage: " + String.valueOf(storage) + " ; Kind: " + String.valueOf(kind));
                    }
                    Register reg = storage.register();
                    VMError.guarantee(this.target.arch.canStoreValue(reg.getRegisterCategory(), paramValueKind.getPlatformKind()), "Cannot assign value to register.");
                    locations[i] = reg.asValue(paramValueKind);
                    VMError.guarantee(!usedRegisters.contains(reg), "Register was already used.");
                    usedRegisters.add(reg);
                    continue;
                }
                if (storage.assignsToStack()) {
                    assert (currentStackOffset <= storage.stackOffset()) : "currentStackOffset=" + currentStackOffset + ", stackOffset=" + storage.stackOffset();
                    locations[i] = StackSlot.get((ValueKind)valueKindFactory.getValueKind(kind), (int)storage.stackOffset(), (!type.outgoing ? 1 : 0) != 0);
                    currentStackOffset = storage.stackOffset();
                    continue;
                }
                throw VMError.shouldNotReachHere("Placeholder assignment.");
            }
        }
        JavaKind returnKind = returnType == null ? JavaKind.Void : ObjectLayout.getCallSignatureKind(isEntryPoint, returnType, this.metaAccess, this.target);
        AllocatableValue returnLocation = returnKind == JavaKind.Void ? Value.ILLEGAL : this.getReturnRegister(returnKind).asValue(valueKindFactory.getValueKind(returnKind.getStackKind()));
        return new SubstrateCallingConvention(type, kinds, currentStackOffset, returnLocation, locations);
    }

    public List<Register> filterAllocatableRegisters(PlatformKind kind, List<Register> registers) {
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register reg : registers) {
            if (!this.target.arch.canStoreValue(reg.getRegisterCategory(), kind)) continue;
            list.add(reg);
        }
        return List.copyOf(list);
    }

    public List<Register> getJavaGeneralParameterRegs() {
        return this.generalParameterRegs;
    }
}

