/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.StackVerifier;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.lang.ref.Reference;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class HeapVerifier {
    private static final ObjectVerifier OBJECT_VERIFIER = new ObjectVerifier();
    private static final ObjectReferenceVerifier REFERENCE_VERIFIER = new ObjectReferenceVerifier();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapVerifier() {
    }

    @Fold
    public static HeapVerifier singleton() {
        return (HeapVerifier)ImageSingletons.lookup(HeapVerifier.class);
    }

    public boolean verify(Occasion occasion) {
        boolean success = true;
        success &= this.verifyImageHeap();
        success &= HeapVerifier.verifyYoungGeneration(occasion);
        success &= HeapVerifier.verifyOldGeneration();
        return success &= HeapVerifier.verifyRememberedSets();
    }

    protected boolean verifyImageHeap() {
        boolean success = true;
        for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
            success &= HeapVerifier.verifyAlignedChunks(null, info.getFirstWritableAlignedChunk());
            success &= HeapVerifier.verifyUnalignedChunks(null, info.getFirstWritableUnalignedChunk(), info.getLastWritableUnalignedChunk());
        }
        return success;
    }

    private static boolean verifyYoungGeneration(Occasion occasion) {
        Space eden;
        boolean success = true;
        YoungGeneration youngGeneration = HeapImpl.getHeapImpl().getYoungGeneration();
        if (!(occasion != Occasion.During && occasion != Occasion.After || (eden = youngGeneration.getEden()).isEmpty())) {
            Log.log().string("Eden contains chunks after a collection: firstAlignedChunk: ").zhex((WordBase)eden.getFirstAlignedHeapChunk()).string(", firstUnalignedChunk: ").zhex((WordBase)eden.getFirstUnalignedHeapChunk()).newline();
            success = false;
        }
        success &= HeapVerifier.verifySpace(youngGeneration.getEden());
        for (int i = 0; i < youngGeneration.getMaxSurvivorSpaces(); ++i) {
            Space fromSpace = youngGeneration.getSurvivorFromSpaceAt(i);
            Space toSpace = youngGeneration.getSurvivorToSpaceAt(i);
            if (!toSpace.isEmpty()) {
                Log.log().string("Survivor to-space ").signed(i).string(" contains chunks: firstAlignedChunk: ").zhex((WordBase)toSpace.getFirstAlignedHeapChunk()).string(", firstUnalignedChunk: ").zhex((WordBase)toSpace.getFirstUnalignedHeapChunk()).newline();
                success = false;
            }
            success &= HeapVerifier.verifySpace(fromSpace);
            success &= HeapVerifier.verifySpace(toSpace);
        }
        return success;
    }

    private static boolean verifyOldGeneration() {
        return HeapImpl.getHeapImpl().getOldGeneration().verifySpaces();
    }

    private static boolean verifyRememberedSets() {
        boolean success = true;
        RememberedSet rememberedSet = RememberedSet.get();
        for (ImageHeapInfo info : HeapImpl.getImageHeapInfos()) {
            success &= rememberedSet.verify(info.getFirstWritableAlignedChunk());
            success &= rememberedSet.verify(info.getFirstWritableUnalignedChunk(), info.getLastWritableUnalignedChunk());
        }
        return success &= HeapImpl.getHeapImpl().getOldGeneration().verifyRememberedSets();
    }

    static boolean verifyRememberedSet(Space space) {
        boolean success = true;
        success &= RememberedSet.get().verify(space.getFirstAlignedHeapChunk());
        return success &= RememberedSet.get().verify(space.getFirstUnalignedHeapChunk());
    }

    static boolean verifySpace(Space space) {
        boolean success = true;
        success &= HeapVerifier.verifyChunkList(space, "aligned", space.getFirstAlignedHeapChunk(), space.getLastAlignedHeapChunk());
        success &= HeapVerifier.verifyChunkList(space, "unaligned", space.getFirstUnalignedHeapChunk(), space.getLastUnalignedHeapChunk());
        success &= HeapVerifier.verifyAlignedChunks(space, space.getFirstAlignedHeapChunk());
        return success &= HeapVerifier.verifyUnalignedChunks(space, space.getFirstUnalignedHeapChunk());
    }

    private static boolean verifyChunkList(Space space, String kind, HeapChunk.Header<?> firstChunk, HeapChunk.Header<?> lastChunk) {
        boolean result = true;
        HeapChunk.Header<?> current = firstChunk;
        HeapChunk.Header<?> previous = (HeapChunk.Header<?>)Word.nullPointer();
        while (current.isNonNull()) {
            Object previousOfCurrent = HeapChunk.getPrevious(current);
            if (previousOfCurrent.notEqual((ComparableWord)previous)) {
                Log.log().string("Verification failed for the doubly-linked list that holds ").string(kind).string(" chunks: space: ").string(space.getName()).string(", current: ").zhex((WordBase)current).string(", current.previous: ").zhex((WordBase)previousOfCurrent).string(", previous: ").zhex((WordBase)previous).newline();
                result = false;
            }
            previous = current;
            current = HeapChunk.getNext(current);
        }
        if (previous.notEqual((ComparableWord)lastChunk)) {
            Log.log().string("Verification failed for the doubly-linked list that holds ").string(kind).string(" chunks: space: ").string(space.getName()).string(", previous: ").zhex((WordBase)previous).string(", lastChunk: ").zhex((WordBase)lastChunk).newline();
            result = false;
        }
        return result;
    }

    private static boolean verifyAlignedChunks(Space space, AlignedHeapChunk.AlignedHeader firstAlignedHeapChunk) {
        boolean success = true;
        AlignedHeapChunk.AlignedHeader aChunk = firstAlignedHeapChunk;
        while (aChunk.isNonNull()) {
            if (space != aChunk.getSpace()) {
                Log.log().string("Space ").string(space.getName()).string(" contains aligned chunk ").zhex((WordBase)aChunk).string(" but the chunk does not reference the correct space: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)aChunk.getSpace())).newline();
                success = false;
            }
            if (aChunk.getShouldSweepInsteadOfCompact()) {
                Log.log().string("Aligned chunk ").zhex((WordBase)aChunk).string(" is marked for sweeping while this should only be used during collections.").newline();
                success = false;
            }
            OBJECT_VERIFIER.initialize(aChunk, (UnalignedHeapChunk.UnalignedHeader)Word.nullPointer());
            AlignedHeapChunk.walkObjects(aChunk, OBJECT_VERIFIER);
            aChunk = HeapChunk.getNext(aChunk);
            success &= HeapVerifier.OBJECT_VERIFIER.result;
        }
        return success;
    }

    private static boolean verifyUnalignedChunks(Space space, UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk) {
        return HeapVerifier.verifyUnalignedChunks(space, firstUnalignedHeapChunk, (UnalignedHeapChunk.UnalignedHeader)Word.nullPointer());
    }

    private static boolean verifyUnalignedChunks(Space space, UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk, UnalignedHeapChunk.UnalignedHeader lastUnalignedHeapChunk) {
        boolean success = true;
        UnalignedHeapChunk.UnalignedHeader uChunk = firstUnalignedHeapChunk;
        while (uChunk.isNonNull()) {
            if (space != uChunk.getSpace()) {
                Log.log().string("Space ").string(space.getName()).string(" contains unaligned chunk ").zhex((WordBase)uChunk).string(" but the chunk does not reference the correct space: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)uChunk.getSpace())).newline();
                success = false;
            }
            OBJECT_VERIFIER.initialize((AlignedHeapChunk.AlignedHeader)Word.nullPointer(), uChunk);
            UnalignedHeapChunk.walkObjects(uChunk, OBJECT_VERIFIER);
            success &= HeapVerifier.OBJECT_VERIFIER.result;
            if (uChunk.equal((ComparableWord)lastUnalignedHeapChunk)) break;
            uChunk = HeapChunk.getNext(uChunk);
        }
        return success;
    }

    private static boolean verifyObject(Object obj, AlignedHeapChunk.AlignedHeader aChunk, UnalignedHeapChunk.UnalignedHeader uChunk) {
        Space space;
        HeapChunk.Header<?> enclosingHeapChunk;
        HeapChunk.Header<AlignedHeapChunk.AlignedHeader> chunk;
        Word ptr = Word.objectToUntrackedPointer((Object)obj);
        if (ptr.isNull()) {
            Log.log().string("Encounter a null pointer while walking the heap objects.").newline();
            return false;
        }
        int objectAlignment = ConfigurationValues.getObjectLayout().getAlignment();
        if (ptr.unsignedRemainder(objectAlignment).notEqual(0)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" is not properly aligned to ").signed(objectAlignment).string(" bytes.").newline();
            return false;
        }
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word header = oh.readHeaderFromPointer((Pointer)ptr);
        if (ObjectHeaderImpl.isProducedHeapChunkZapped((UnsignedWord)header) || ObjectHeaderImpl.isConsumedHeapChunkZapped((UnsignedWord)header)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" has a zapped header: ").zhex((WordBase)header).newline();
            return false;
        }
        if (ObjectHeaderImpl.isForwardedHeader((UnsignedWord)header)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" has a forwarded header: ").zhex((WordBase)header).newline();
            return false;
        }
        if (!HeapImpl.getHeap().getObjectHeader().isEncodedObjectHeader(header)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" does not have a valid hub: ").zhex((WordBase)header).newline();
            return false;
        }
        if (SerialGCOptions.useCompactingOldGen() && ObjectHeaderImpl.isMarkedHeader((UnsignedWord)header)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" has a marked header: ").zhex((WordBase)header).newline();
            return false;
        }
        assert (aChunk.isNonNull() ^ uChunk.isNonNull());
        HeapChunk.Header<AlignedHeapChunk.AlignedHeader> header2 = chunk = aChunk.isNonNull() ? aChunk : uChunk;
        if ((HeapImpl.isImageHeapAligned() || !HeapImpl.getHeapImpl().isInImageHeap(obj)) && chunk.notEqual((ComparableWord)(enclosingHeapChunk = HeapChunk.getEnclosingHeapChunk(obj)))) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" should have ").zhex((WordBase)chunk).string(" as its enclosing chunk but getEnclosingHeapChunk returned ").zhex((WordBase)enclosingHeapChunk).newline();
            return false;
        }
        Pointer chunkStart = HeapChunk.asPointer(chunk);
        Pointer chunkTop = HeapChunk.getTopPointer(chunk);
        if (chunkStart.aboveOrEqual((UnsignedWord)ptr) || chunkTop.belowOrEqual((UnsignedWord)ptr)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" is not within the allocated part of the chunk: ").zhex((WordBase)chunkStart).string(" - ").zhex((WordBase)chunkTop).string("").newline();
            return false;
        }
        if (aChunk.isNonNull()) {
            if (!ObjectHeaderImpl.isAlignedHeader((UnsignedWord)header)) {
                Log.log().string("Header of object ").zhex((WordBase)ptr).string(" is not marked as aligned: ").zhex((WordBase)header).newline();
                return false;
            }
        } else {
            assert (uChunk.isNonNull());
            if (!ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)header)) {
                Log.log().string("Header of object ").zhex((WordBase)ptr).string(" is not marked as unaligned: ").zhex((WordBase)header).newline();
                return false;
            }
        }
        if ((space = chunk.getSpace()) == null) {
            if (!HeapImpl.getHeapImpl().isInImageHeap(obj)) {
                Log.log().string("Object ").zhex((WordBase)ptr).string(" is not an image heap object even though the space of the parent chunk ").zhex((WordBase)chunk).string(" is null.").newline();
                return false;
            }
        } else if (space.isOldSpace()) {
            if (SerialGCOptions.useRememberedSet() && !RememberedSet.get().hasRememberedSet((UnsignedWord)header)) {
                Log.log().string("Object ").zhex((WordBase)ptr).string(" is in old generation chunk ").zhex((WordBase)chunk).string(" but does not have a remembered set.").newline();
                return false;
            }
        } else if (space.isYoungSpace() && SerialGCOptions.useRememberedSet() && RememberedSet.get().hasRememberedSet((UnsignedWord)header)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" is in ").string(space.getName()).string(" chunk ").zhex((WordBase)chunk).string(" but has a remembered set.").newline();
            return false;
        }
        return HeapVerifier.verifyReferences(obj);
    }

    private static boolean verifyReferences(Object obj) {
        if (!SerialGCOptions.VerifyReferences.getValue().booleanValue() && !SerialGCOptions.VerifyReferencesPointIntoValidChunk.getValue().booleanValue()) {
            return true;
        }
        REFERENCE_VERIFIER.initialize();
        InteriorObjRefWalker.walkObject(obj, REFERENCE_VERIFIER);
        boolean success = HeapVerifier.REFERENCE_VERIFIER.result;
        DynamicHub hub = KnownIntrinsics.readHub(obj);
        if (hub.isReferenceInstanceClass()) {
            Reference ref = (Reference)obj;
            success &= HeapVerifier.verifyReferent(ref);
        }
        return success;
    }

    private static boolean verifyReferent(Reference<?> ref) {
        return HeapVerifier.verifyReference(ref, ReferenceInternals.getReferentFieldAddress(ref), ReferenceInternals.getReferentPointer(ref));
    }

    public static boolean verifyReference(Object parentObject, Pointer objRef, boolean compressed) {
        Word ptr = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
        return HeapVerifier.verifyReference(parentObject, objRef, (Pointer)ptr);
    }

    private static boolean verifyReference(Object parentObject, Pointer reference, Pointer referencedObject) {
        if (referencedObject.isNull()) {
            return true;
        }
        if (SerialGCOptions.VerifyReferencesPointIntoValidChunk.getValue().booleanValue() && !HeapImpl.getHeapImpl().isInHeap(referencedObject)) {
            Log.log().string("Object reference at ").zhex((WordBase)reference).string(" points outside the Java heap: ").zhex((WordBase)referencedObject).string(". ");
            HeapVerifier.printParent(parentObject);
            return false;
        }
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word header = oh.readHeaderFromPointer(referencedObject);
        if (!ObjectHeaderImpl.getObjectHeaderImpl().isEncodedObjectHeader(header)) {
            Log.log().string("Object reference at ").zhex((WordBase)reference).string(" does not point to a Java object or the object header of the Java object is invalid: ").zhex((WordBase)referencedObject).string(". ");
            HeapVerifier.printParent(parentObject);
            return false;
        }
        if (ObjectHeaderImpl.isAlignedHeader((UnsignedWord)header)) {
            AlignedHeapChunk.AlignedHeader chunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(referencedObject);
            if (referencedObject.belowThan((UnsignedWord)AlignedHeapChunk.getObjectsStart(chunk)) || referencedObject.aboveOrEqual((UnsignedWord)HeapChunk.getTopPointer(chunk))) {
                Log.log().string("Object reference ").zhex((WordBase)reference).string(" points to ").zhex((WordBase)referencedObject).string(", which is outside the usable part of the corresponding aligned chunk.");
                HeapVerifier.printParent(parentObject);
                return false;
            }
        } else {
            assert (ObjectHeaderImpl.isUnalignedHeader((UnsignedWord)header));
            UnalignedHeapChunk.UnalignedHeader chunk = UnalignedHeapChunk.getEnclosingChunkFromObjectPointer(referencedObject);
            if (referencedObject != UnalignedHeapChunk.getObjectStart(chunk)) {
                Log.log().string("Object reference ").zhex((WordBase)reference).string(" points to ").zhex((WordBase)referencedObject).string(", which is outside the usable part of the corresponding unaligned chunk.");
                HeapVerifier.printParent(parentObject);
                return false;
            }
        }
        return true;
    }

    private static void printParent(Object parentObject) {
        if (parentObject instanceof StackVerifier.VerifyFrameReferencesVisitor) {
            StackVerifier.VerifyFrameReferencesVisitor visitor = (StackVerifier.VerifyFrameReferencesVisitor)parentObject;
            Log.log().string("The invalid reference is on the stack: sp=").zhex((WordBase)visitor.getSP()).string(", ip=").zhex((WordBase)visitor.getIP()).newline();
        } else {
            assert (parentObject != null);
            Log.log().string("The object that contains the invalid reference is of type ").string(parentObject.getClass().getName()).newline();
        }
    }

    public static enum Occasion {
        Before,
        During,
        After;

    }

    private static class ObjectVerifier
    implements ObjectVisitor {
        protected boolean result;
        private AlignedHeapChunk.AlignedHeader aChunk;
        private UnalignedHeapChunk.UnalignedHeader uChunk;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        ObjectVerifier() {
        }

        void initialize(AlignedHeapChunk.AlignedHeader aChunk, UnalignedHeapChunk.UnalignedHeader uChunk) {
            this.result = true;
            this.aChunk = aChunk;
            this.uChunk = uChunk;
        }

        @Override
        public void visitObject(Object object) {
            this.result &= HeapVerifier.verifyObject(object, this.aChunk, this.uChunk);
        }
    }

    private static class ObjectReferenceVerifier
    implements ObjectReferenceVisitor {
        private boolean result;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        ObjectReferenceVerifier() {
        }

        public void initialize() {
            this.result = true;
        }

        @Override
        public void visitObjectReferences(Pointer firstObjRef, boolean compressed, int referenceSize, Object holderObject, int count) {
            Pointer pos = firstObjRef;
            Pointer end = firstObjRef.add(Word.unsigned((int)count).multiply(referenceSize));
            while (pos.belowThan((UnsignedWord)end)) {
                this.visitObjectReference(pos, compressed, holderObject);
                pos = pos.add(referenceSize);
            }
        }

        private void visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
            this.result &= HeapVerifier.verifyReference(holderObject, objRef, compressed);
        }
    }
}

