/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.heap.FillerArray;
import com.oracle.svm.core.heap.FillerObject;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class FillerObjectUtil {
    private static final Class<?> ARRAY_CLASS = FillerArray.class;
    private static final JavaKind ARRAY_ELEMENT_KIND = JavaKind.Int;
    private static final int ARRAY_ELEMENT_SIZE = ARRAY_ELEMENT_KIND.getByteCount();

    @Fold
    public static UnsignedWord objectMinSize() {
        return Word.unsigned((int)ConfigurationValues.getObjectLayout().getMinImageHeapObjectSize());
    }

    @Fold
    static int arrayMinSize() {
        return NumUtil.safeToInt((long)ConfigurationValues.getObjectLayout().getArraySize(ARRAY_ELEMENT_KIND, 0, false));
    }

    @Fold
    static int arrayBaseOffset() {
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(ARRAY_ELEMENT_KIND);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void writeFillerObjectAt(Pointer p, UnsignedWord size, boolean rememberedSet) {
        assert (size.aboveThan(0));
        if (size.aboveOrEqual(FillerObjectUtil.arrayMinSize())) {
            int length = UnsignedUtils.safeToInt(size.subtract(FillerObjectUtil.arrayBaseOffset()).unsignedDivide(ARRAY_ELEMENT_SIZE));
            FormatArrayNode.formatArray(p, ARRAY_CLASS, length, rememberedSet, false, AllocationSnippets.FillContent.WITH_GARBAGE_IF_ASSERTIONS_ENABLED, false);
        } else {
            FormatObjectNode.formatObject(p, FillerObject.class, rememberedSet, AllocationSnippets.FillContent.WITH_GARBAGE_IF_ASSERTIONS_ENABLED, false);
        }
        assert (LayoutEncoding.getSizeFromObjectInGC(p.toObject()).equal(size));
    }
}

