/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.genscavenge.AdaptiveCollectionPolicy;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.heap.DynamicHeapSizeManager;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.UnsignedWord;

class DynamicCollectionPolicy
extends AdaptiveCollectionPolicy {
    DynamicCollectionPolicy() {
    }

    @Override
    public String getName() {
        return "dynamic";
    }

    @Override
    protected long getMaximumHeapSizeOptionValue() {
        if (ImageSingletons.contains(DynamicHeapSizeManager.class)) {
            return ((DynamicHeapSizeManager)ImageSingletons.lookup(DynamicHeapSizeManager.class)).maxHeapSize().rawValue();
        }
        return SubstrateGCOptions.MaxHeapSize.getValue();
    }

    @Override
    public boolean isOutOfMemory(UnsignedWord usedBytes) {
        if (ImageSingletons.contains(DynamicHeapSizeManager.class)) {
            return ((DynamicHeapSizeManager)ImageSingletons.lookup(DynamicHeapSizeManager.class)).outOfMemory(usedBytes);
        }
        return super.isOutOfMemory(usedBytes);
    }

    @Override
    public void onMaximumHeapSizeExceeded() {
        if (this.isOutOfMemory(HeapImpl.getAccounting().getUsedBytes())) {
            super.onMaximumHeapSizeExceeded();
        } else {
            GCImpl.getPolicy().updateSizeParameters();
        }
    }
}

