/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.util.PointerUtils;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public final class AlignedHeapChunk {
    private AlignedHeapChunk() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initialize(AlignedHeader chunk, UnsignedWord chunkSize) {
        assert (chunk.isNonNull());
        assert (chunkSize.equal(HeapParameters.getAlignedHeapChunkSize())) : "expecting all aligned chunks to be the same size";
        HeapChunk.initialize(chunk, AlignedHeapChunk.getObjectsStart(chunk), chunkSize);
        chunk.setShouldSweepInsteadOfCompact(false);
    }

    public static void reset(AlignedHeader chunk) {
        long alignedChunkSize = SerialAndEpsilonGCOptions.AlignedHeapChunkSize.getValue();
        assert (HeapChunk.getEndOffset(chunk).rawValue() == alignedChunkSize);
        AlignedHeapChunk.initialize(chunk, Word.unsigned((long)alignedChunkSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getObjectsStart(AlignedHeader that) {
        return HeapChunk.asPointer(that).add(AlignedHeapChunk.getObjectsStartOffset());
    }

    public static Pointer getObjectsEnd(AlignedHeader that) {
        return HeapChunk.getEndPointer(that);
    }

    public static boolean isEmpty(AlignedHeader that) {
        return HeapChunk.getTopOffset(that).equal(AlignedHeapChunk.getObjectsStartOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static Pointer allocateMemory(AlignedHeader that, UnsignedWord size) {
        Pointer result = (Pointer)Word.nullPointer();
        UnsignedWord available = HeapChunk.availableObjectMemory(that);
        if (size.belowOrEqual(available)) {
            result = HeapChunk.getTopPointer(that);
            Pointer newTop = result.add(size);
            HeapChunk.setTopPointerCarefully(that, newTop);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static AlignedHeader getEnclosingChunk(Object obj) {
        Word ptr = Word.objectToUntrackedPointer((Object)obj);
        return AlignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)ptr);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static AlignedHeader getEnclosingChunkFromObjectPointer(Pointer ptr) {
        if (!GraalDirectives.inIntrinsic()) assert (HeapImpl.isImageHeapAligned() || !HeapImpl.getHeapImpl().isInImageHeap(ptr)) : "can't be used because the image heap is unaligned";
        return (AlignedHeader)PointerUtils.roundDown((PointerBase)ptr, HeapParameters.getAlignedHeapChunkAlignment());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getObjectOffset(AlignedHeader that, Pointer objectPointer) {
        Pointer objectsStart = AlignedHeapChunk.getObjectsStart(that);
        return objectPointer.subtract((UnsignedWord)objectsStart);
    }

    static void walkObjects(AlignedHeader that, ObjectVisitor visitor) {
        HeapChunk.walkObjectsFrom(that, AlignedHeapChunk.getObjectsStart(that), visitor);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void walkObjectsFromInline(AlignedHeader that, Pointer start, GreyToBlackObjectVisitor visitor) {
        HeapChunk.walkObjectsFromInline(that, start, visitor);
    }

    @Fold
    public static UnsignedWord getObjectsStartOffset() {
        return RememberedSet.get().getHeaderSizeOfAlignedChunk();
    }

    @Fold
    public static UnsignedWord getUsableSizeForObjects() {
        return HeapParameters.getAlignedHeapChunkSize().subtract(AlignedHeapChunk.getObjectsStartOffset());
    }

    @RawStructure
    public static interface AlignedHeader
    extends HeapChunk.Header<AlignedHeader> {
        @RawField
        public boolean getShouldSweepInsteadOfCompact();

        @RawField
        public void setShouldSweepInsteadOfCompact(boolean var1);
    }

    public static interface Visitor {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while visiting the heap.")
        public boolean visitChunk(AlignedHeader var1);
    }
}

