/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.cpufeature;

import com.oracle.svm.core.SubstrateTargetDescription;
import java.util.EnumSet;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.replacements.nodes.AESNode;
import jdk.graal.compiler.replacements.nodes.BigIntegerMulAddNode;
import jdk.graal.compiler.replacements.nodes.BigIntegerMultiplyToLenNode;
import jdk.graal.compiler.replacements.nodes.BigIntegerSquareToLenNode;
import jdk.graal.compiler.replacements.nodes.CipherBlockChainingAESNode;
import jdk.graal.compiler.replacements.nodes.CounterModeAESNode;
import jdk.graal.compiler.replacements.nodes.GHASHProcessBlocksNode;
import jdk.graal.compiler.replacements.nodes.MessageDigestNode;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class Stubs {
    public static final String RUNTIME_CHECKED_CPU_FEATURES_NAME_SUFFIX = "RTC";

    public static EnumSet<?> getRequiredCPUFeatures(Class<? extends ValueNode> klass) {
        Architecture arch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        if (arch instanceof AMD64) {
            return AMD64Features.getRequiredCPUFeatures(klass);
        }
        if (arch instanceof AArch64) {
            return AArch64Features.getRequiredCPUFeatures(klass);
        }
        throw GraalError.unsupportedArchitecture((Architecture)arch);
    }

    @Fold
    public static EnumSet<?> getRuntimeCheckedCPUFeatures(Class<? extends ValueNode> klass) {
        return Stubs.getRequiredCPUFeatures(klass);
    }

    @Platforms(value={Platform.AMD64.class})
    public static class AMD64Features {
        public static final EnumSet<AMD64.CPUFeature> RUNTIME_CHECKED_CPU_FEATURES_AMD64 = EnumSet.of(AMD64.CPUFeature.SSE2, new AMD64.CPUFeature[]{AMD64.CPUFeature.SSE3, AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.SSE4_1, AMD64.CPUFeature.SSE4_2, AMD64.CPUFeature.POPCNT, AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2});
        public static final EnumSet<AMD64.CPUFeature> GHASH_CPU_FEATURES_AMD64 = EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.CLMUL);
        public static final EnumSet<AMD64.CPUFeature> BIGINTEGER_MULTIPLY_TO_LEN_CPU_FEATURES_AMD64 = EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.BMI2, AMD64.CPUFeature.ADX);
        public static final EnumSet<AMD64.CPUFeature> BIGINTEGER_MUL_ADD_CPU_FEATURES_AMD64 = EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.BMI2);

        public static EnumSet<AMD64.CPUFeature> getRequiredCPUFeatures(Class<? extends ValueNode> klass) {
            if (AESNode.class.equals(klass)) {
                return AESNode.minFeaturesAMD64();
            }
            if (CounterModeAESNode.class.equals(klass)) {
                return CounterModeAESNode.minFeaturesAMD64();
            }
            if (CipherBlockChainingAESNode.class.equals(klass)) {
                return CipherBlockChainingAESNode.minFeaturesAMD64();
            }
            if (GHASHProcessBlocksNode.class.equals(klass)) {
                return GHASH_CPU_FEATURES_AMD64;
            }
            if (BigIntegerMultiplyToLenNode.class.equals(klass)) {
                return BIGINTEGER_MULTIPLY_TO_LEN_CPU_FEATURES_AMD64;
            }
            if (BigIntegerMulAddNode.class.equals(klass)) {
                return BIGINTEGER_MUL_ADD_CPU_FEATURES_AMD64;
            }
            if (BigIntegerSquareToLenNode.class.equals(klass)) {
                return BIGINTEGER_MULTIPLY_TO_LEN_CPU_FEATURES_AMD64;
            }
            if (MessageDigestNode.SHA1Node.class.equals(klass)) {
                return MessageDigestNode.SHA1Node.minFeaturesAMD64();
            }
            if (MessageDigestNode.SHA256Node.class.equals(klass)) {
                return MessageDigestNode.SHA256Node.minFeaturesAMD64();
            }
            if (MessageDigestNode.SHA3Node.class.equals(klass)) {
                return MessageDigestNode.SHA3Node.minFeaturesAMD64();
            }
            if (MessageDigestNode.SHA512Node.class.equals(klass)) {
                return MessageDigestNode.SHA512Node.minFeaturesAMD64();
            }
            return RUNTIME_CHECKED_CPU_FEATURES_AMD64;
        }
    }

    @Platforms(value={Platform.AARCH64.class})
    public static class AArch64Features {
        public static final EnumSet<AArch64.CPUFeature> EMPTY_CPU_FEATURES_AARCH64 = EnumSet.noneOf(AArch64.CPUFeature.class);

        public static EnumSet<AArch64.CPUFeature> getRequiredCPUFeatures(Class<? extends ValueNode> klass) {
            if (AESNode.class.equals(klass)) {
                return AESNode.minFeaturesAARCH64();
            }
            if (CounterModeAESNode.class.equals(klass)) {
                return CounterModeAESNode.minFeaturesAARCH64();
            }
            if (CipherBlockChainingAESNode.class.equals(klass)) {
                return CipherBlockChainingAESNode.minFeaturesAARCH64();
            }
            if (GHASHProcessBlocksNode.class.equals(klass)) {
                return GHASHProcessBlocksNode.minFeaturesAARCH64();
            }
            if (MessageDigestNode.SHA1Node.class.equals(klass)) {
                return MessageDigestNode.SHA1Node.minFeaturesAARCH64();
            }
            if (MessageDigestNode.SHA256Node.class.equals(klass)) {
                return MessageDigestNode.SHA256Node.minFeaturesAARCH64();
            }
            if (MessageDigestNode.SHA3Node.class.equals(klass)) {
                return MessageDigestNode.SHA3Node.minFeaturesAARCH64();
            }
            if (MessageDigestNode.SHA512Node.class.equals(klass)) {
                return MessageDigestNode.SHA512Node.minFeaturesAARCH64();
            }
            return EMPTY_CPU_FEATURES_AARCH64;
        }
    }
}

